/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.security.cmskeystore.CMSLoadStoreParameterFactory;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ssl.JSSEProvider;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.ws.ssl.config.WSKeyStore;
import java.io.File;
import java.security.KeyStore;

public class CMSKeyStoreUtility {
    private static final TraceComponent tc = Tr.register(CMSKeyStoreUtility.class, (String)"SSL", (String)"com.ibm.ws.ssl.resources.ssl");

    private CMSKeyStoreUtility() {
    }

    public static void storeCMSKeyStore(KeyStore ks, String SSLKeyFile, String SSLKeyPassword, String SSLKeyStoreType, String SSLKeyStoreStash) throws SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"storeCMSKeyStore", (Object[])new Object[0]);
        }
        KeyStore.LoadStoreParameter loadParm = null;
        File sslKeyFile = new File(SSLKeyFile);
        if (SSLKeyStoreType.equals("CMSKS")) {
            boolean stashFile = Boolean.parseBoolean(SSLKeyStoreStash);
            loadParm = CMSLoadStoreParameterFactory.newCMSStoreParameter((File)sslKeyFile, (KeyStore.ProtectionParameter)new KeyStore.PasswordProtection(SSLKeyPassword.toCharArray()), (boolean)stashFile);
        }
        if (loadParm != null) {
            try {
                ks.store(loadParm);
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Could not store the keystore.", (Object[])new Object[]{e});
                }
                throw new SSLException(e.getMessage(), e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"storeCMSKeyStore");
        }
    }

    public static KeyStore loadCMSKeyStore(File kFile, String keyStoreLocation, String SSLKeyPassword, String SSLKeyStoreType, String SSLKeyStoreProvider, String SSLKeyStoreStash) throws SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"loadCMSKeyStore", (Object[])new Object[0]);
        }
        KeyStore ks1 = null;
        try {
            KeyStore.LoadStoreParameter loadParm = null;
            if (SSLKeyStoreType.equals("CMSKS")) {
                loadParm = CMSLoadStoreParameterFactory.newCMSLoadParameter((File)kFile, (KeyStore.ProtectionParameter)new KeyStore.PasswordProtection(WSKeyStore.decodePassword(SSLKeyPassword).toCharArray()));
            }
            if (loadParm != null) {
                JSSEProvider jsseProvider = JSSEProviderFactory.getInstance(SSLKeyStoreProvider);
                ks1 = jsseProvider.getKeyStoreInstance(SSLKeyStoreType, SSLKeyStoreProvider);
                ks1.load(loadParm);
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception loading the CMS keystore.", (Object[])new Object[]{e});
            }
            throw new SSLException(e.getMessage(), e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"loadCMSKeyStore");
        }
        return ks1;
    }
}

