/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jndi.internal;

import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jndi.internal.literals.LiteralParser;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.vendor=IBM"})
public class JNDIEntry {
    private static final TraceComponent tc = Tr.register(JNDIEntry.class);
    ServiceRegistration<?> serviceRegistration;
    static final long serialVersionUID = 6144922758303547790L;

    /*
     * WARNING - void declaration
     */
    protected synchronized void activate(BundleContext context, Map<String, Object> props) {
        String jndiName = (String)props.get("jndiName");
        String originalValue = (String)props.get("value");
        boolean decode = (Boolean)props.get("decode");
        if (jndiName == null || jndiName.isEmpty() || originalValue == null || originalValue.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unable to register JNDIEntry with jndiName " + jndiName + " and value " + originalValue + " because both must be set"), (Object[])new Object[0]);
            }
            return;
        }
        String value = originalValue;
        if (decode) {
            try {
                value = PasswordUtil.decode((String)originalValue);
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jndi.internal.JNDIEntry", (String)"75", (Object)this, (Object[])new Object[]{context, props});
                Tr.error((TraceComponent)tc, (String)"jndi.decode.failed", (Object[])new Object[]{originalValue, e});
            }
        }
        Object parsedValue = LiteralParser.parse(value);
        String valueClassName = parsedValue.getClass().getName();
        Object serviceObject = decode ? new Decode(originalValue) : parsedValue;
        Hashtable<String, String> propertiesForJndiService = new Hashtable<String, String>();
        ((Dictionary)propertiesForJndiService).put("osgi.jndi.service.name", jndiName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Registering JNDIEntry " + valueClassName + " with value " + parsedValue + " and JNDI name " + jndiName), (Object[])new Object[0]);
        }
        this.serviceRegistration = context.registerService(valueClassName, serviceObject, propertiesForJndiService);
    }

    protected synchronized void deactivate(ComponentContext context) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Unregistering JNDIEntry " + this.serviceRegistration), (Object[])new Object[0]);
        }
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class Decode
    implements ServiceFactory<Object> {
        private final String value;
        static final long serialVersionUID = -3671400669166867006L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public Decode(String value) {
            this.value = value;
        }

        /*
         * WARNING - void declaration
         */
        public Object getService(Bundle bundle, ServiceRegistration<Object> registration) {
            try {
                String decodedValue = PasswordUtil.decode((String)this.value);
                Object parsedValue = LiteralParser.parse(decodedValue);
                return parsedValue;
            }
            catch (Exception decodedValue) {
                void e;
                FFDCFilter.processException((Throwable)decodedValue, (String)"com.ibm.ws.jndi.internal.JNDIEntry$Decode", (String)"122", (Object)this, (Object[])new Object[]{bundle, registration});
                Tr.error((TraceComponent)tc, (String)"jndi.decode.failed", (Object[])new Object[]{this.value, e});
                return this.value;
            }
        }

        public void ungetService(Bundle bundle, ServiceRegistration<Object> registration, Object service) {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(Decode.class);
        }
    }
}

