/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.transport.client;

import com.ibm.ws.repository.common.enums.AttachmentLinkType;
import com.ibm.ws.repository.common.enums.AttachmentType;
import com.ibm.ws.repository.common.enums.FilterableAttribute;
import com.ibm.ws.repository.common.enums.ResourceType;
import com.ibm.ws.repository.common.enums.StateAction;
import com.ibm.ws.repository.transport.client.AbstractRepositoryClient;
import com.ibm.ws.repository.transport.client.ClientLoginInfo;
import com.ibm.ws.repository.transport.client.JSONAssetConverter;
import com.ibm.ws.repository.transport.client.LoginInfoClientProxy;
import com.ibm.ws.repository.transport.client.RepositoryReadableClient;
import com.ibm.ws.repository.transport.client.RepositoryWriteableClient;
import com.ibm.ws.repository.transport.exceptions.BadVersionException;
import com.ibm.ws.repository.transport.exceptions.RequestFailureException;
import com.ibm.ws.repository.transport.model.Asset;
import com.ibm.ws.repository.transport.model.Attachment;
import com.ibm.ws.repository.transport.model.AttachmentSummary;
import com.ibm.ws.repository.transport.model.StateUpdateAction;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.xml.bind.DatatypeConverter;

public class RestClient
extends AbstractRepositoryClient
implements RepositoryReadableClient,
RepositoryWriteableClient {
    private final ClientLoginInfo loginInfo;
    private static final String NEWLINE = "\r\n";
    private static final int REPOSITORY_SOCKET_READ_TIMEOUT = 300000;

    public RestClient(ClientLoginInfo loginInfo) {
        this.loginInfo = loginInfo;
    }

    public List<Asset> getAllAssets() throws IOException, RequestFailureException {
        HttpURLConnection connection = this.createHttpURLConnectionToMassive("/assets");
        connection.setRequestMethod("GET");
        this.testResponseCode(connection);
        return JSONAssetConverter.readValues(connection.getInputStream());
    }

    @Override
    public void checkRepositoryStatus() throws IOException, RequestFailureException {
        this.getAllAssetsMetadata();
    }

    public Map<String, List<String>> getAllAssetsMetadata() throws IOException, RequestFailureException {
        HttpURLConnection connection = this.createHttpURLConnectionToMassive("/assets");
        connection.setRequestMethod("HEAD");
        this.testResponseCode(connection);
        return connection.getHeaderFields();
    }

    @Override
    public Asset addAsset(Asset asset) throws IOException, BadVersionException, RequestFailureException {
        HttpURLConnection connection = this.createHttpURLConnectionToMassive("/assets");
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setDoOutput(true);
        JSONAssetConverter.writeValue(connection.getOutputStream(), asset);
        this.testResponseCode(connection);
        Asset returnedAsset = JSONAssetConverter.readValue(connection.getInputStream());
        returnedAsset = this.getAsset(returnedAsset.get_id());
        return returnedAsset;
    }

    @Override
    public Asset updateAsset(Asset asset) throws IOException, BadVersionException, RequestFailureException {
        HttpURLConnection connection = this.createHttpURLConnectionToMassive("/assets/" + asset.get_id());
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setDoOutput(true);
        JSONAssetConverter.writeValue(connection.getOutputStream(), asset);
        this.testResponseCode(connection, true);
        return this.getAsset(asset.get_id());
    }

    private void deleteAsset(String id) throws IOException, RequestFailureException {
        HttpURLConnection connection = this.createHttpURLConnectionToMassive("/assets/" + id);
        connection.setRequestMethod("DELETE");
        this.testResponseCode(connection, true);
    }

    @Override
    public List<Asset> findAssets(String searchString, Collection<ResourceType> types) throws IOException, RequestFailureException {
        String encodedSearchString = URLEncoder.encode(searchString, "UTF-8");
        StringBuffer url = new StringBuffer("/assets?q=" + encodedSearchString);
        if (types != null && !types.isEmpty()) {
            HashSet<String> typeValues = new HashSet<String>();
            for (ResourceType type : types) {
                typeValues.add(type.getValue());
            }
            url.append("&" + this.createListFilter(FilterableAttribute.TYPE, typeValues));
        }
        HttpURLConnection connection = this.createHttpURLConnectionToMassive(url.toString());
        connection.setRequestMethod("GET");
        this.testResponseCode(connection);
        InputStream is = connection.getInputStream();
        List<Asset> assets = JSONAssetConverter.readValues(is);
        return assets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getStartBytes(AttachmentSummary attSummary, String boundary) throws IOException {
        String name = attSummary.getName();
        File fileToWrite = attSummary.getFile();
        Attachment attach = attSummary.getAttachment();
        ByteArrayOutputStream startOutputStream = new ByteArrayOutputStream();
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)startOutputStream, Charset.forName("UTF-8"));
            writer.write("--" + boundary + NEWLINE);
            writer.write("Content-Disposition: form-data; name=\"attachmentInfo\"\r\n");
            writer.write("Content-Type: application/json\r\n");
            writer.write(NEWLINE);
            writer.flush();
            JSONAssetConverter.writeValue(startOutputStream, attach);
            writer.write(NEWLINE);
            writer.write("--" + boundary + NEWLINE);
            writer.write("Content-Disposition: form-data; name=\"" + name + "\"; filename=\"" + fileToWrite.getName() + "\"" + NEWLINE);
            String uploadType = "application/binary";
            if (attach.getType() == null) {
                throw new IllegalArgumentException("Attachments must have a Type specified");
            }
            switch (attach.getType()) {
                case LICENSE: {
                    uploadType = "text/html";
                    break;
                }
                case LICENSE_AGREEMENT: 
                case LICENSE_INFORMATION: {
                    uploadType = "text/plain";
                    break;
                }
            }
            writer.write("Content-Type: " + uploadType + NEWLINE);
            writer.write(NEWLINE);
            writer.close();
        }
        finally {
            if (startOutputStream != null) {
                startOutputStream.close();
            }
        }
        return startOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getEndBytes(AttachmentSummary attSummary, String boundary) throws IOException {
        ByteArrayOutputStream endOutputStream = new ByteArrayOutputStream();
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)endOutputStream, Charset.forName("UTF-8"));
            writer.write(NEWLINE);
            writer.write("--" + boundary + "--" + NEWLINE);
            writer.close();
        }
        finally {
            if (endOutputStream != null) {
                endOutputStream.close();
            }
        }
        return endOutputStream.toByteArray();
    }

    @Override
    public Attachment addAttachment(String assetId, AttachmentSummary attSummary) throws IOException, BadVersionException, RequestFailureException {
        Attachment attach = attSummary.getAttachment();
        String name = attSummary.getName();
        String urlString = "/assets/" + assetId + "/attachments?name=" + name;
        if (attach.getType() != null) {
            urlString = urlString + "&type=" + attach.getType().toString();
        }
        HttpURLConnection connection = this.createHttpURLConnectionToMassive(urlString);
        if (attSummary.getURL() == null) {
            this.writeMultiPart(assetId, attSummary, connection);
        } else {
            this.writeSinglePart(assetId, attSummary, connection);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.testResponseCode(connection);
        InputStream is = connection.getInputStream();
        int len = 0;
        while ((len = is.read()) != -1) {
            baos.write((byte)len);
        }
        is.close();
        baos.close();
        Attachment attachment = JSONAssetConverter.readValue(new ByteArrayInputStream(baos.toByteArray()), Attachment.class);
        return attachment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMultiPart(String assetId, final AttachmentSummary attSummary, HttpURLConnection connection) throws IOException, BadVersionException, RequestFailureException {
        final File fileToWrite = attSummary.getFile();
        String boundary = "---------------------------287032381131322";
        byte[] startBytes = this.getStartBytes(attSummary, boundary);
        byte[] endBytes = this.getEndBytes(attSummary, boundary);
        long fileSize = AccessController.doPrivileged(new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                return attSummary.getFile().length();
            }
        });
        long contentLength = (long)(startBytes.length + endBytes.length) + fileSize;
        connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        connection.setRequestProperty("Content-Length", "" + contentLength);
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        OutputStream httpStream = connection.getOutputStream();
        httpStream.write(startBytes);
        httpStream.flush();
        FileInputStream inputStream = null;
        try {
            int read;
            try {
                inputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                    @Override
                    public FileInputStream run() throws IOException {
                        return new FileInputStream(fileToWrite);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (IOException)e.getCause();
            }
            byte[] buffer = new byte[1024];
            int total = 0;
            while ((read = inputStream.read(buffer)) != -1) {
                httpStream.write(buffer, 0, read);
                total += read;
            }
            if ((long)total != fileSize) {
                throw new IOException("File size was " + fileSize + " but we only uploaded " + total + " bytes");
            }
            httpStream.flush();
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        httpStream.write(endBytes);
        httpStream.flush();
        httpStream.close();
    }

    private void writeSinglePart(String assetId, AttachmentSummary attSummary, HttpURLConnection connection) throws IOException, BadVersionException, RequestFailureException {
        Attachment attach = attSummary.getAttachment();
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        OutputStream httpStream = connection.getOutputStream();
        JSONAssetConverter.writeValue(httpStream, attach);
        httpStream.flush();
        httpStream.close();
    }

    @Override
    public InputStream getAttachment(Asset asset, Attachment attachment) throws IOException, BadVersionException, RequestFailureException {
        HttpURLConnection connection = attachment.getType() == AttachmentType.CONTENT ? this.createHttpURLConnection(attachment.getUrl() + "?license=agree") : this.createHttpURLConnection(attachment.getUrl());
        if (attachment.getLinkType() == AttachmentLinkType.DIRECT && this.loginInfo.getAttachmentBasicAuthUserId() != null && this.loginInfo.getAttachmentBasicAuthPassword() != null) {
            String userpass = this.loginInfo.getAttachmentBasicAuthUserId() + ":" + this.loginInfo.getAttachmentBasicAuthPassword();
            String basicAuth = "Basic " + DatatypeConverter.printBase64Binary((byte[])userpass.getBytes(Charset.forName("UTF-8")));
            connection.setRequestProperty("Authorization", basicAuth);
        }
        connection.setRequestMethod("GET");
        this.testResponseCode(connection);
        return connection.getInputStream();
    }

    public Attachment getAttachmentMetaData(String assetId, String attachmentId) throws IOException, BadVersionException, RequestFailureException {
        Asset ass = this.getAsset(assetId);
        List<Attachment> allAttachments = ass.getAttachments();
        for (Attachment attachment : allAttachments) {
            if (!attachmentId.equals(attachment.get_id())) continue;
            return attachment;
        }
        return null;
    }

    @Override
    public void deleteAttachment(String assetId, String attachmentId) throws IOException, RequestFailureException {
        HttpURLConnection connection = this.createHttpURLConnectionToMassive("/assets/" + assetId + "/attachments/" + attachmentId);
        connection.setRequestMethod("DELETE");
        this.testResponseCode(connection, true);
    }

    @Override
    public void deleteAssetAndAttachments(String assetId) throws IOException, RequestFailureException {
        Asset ass = this.getUnverifiedAsset(assetId);
        List<Attachment> attachments = ass.getAttachments();
        if (attachments != null) {
            for (Attachment attachment : attachments) {
                this.deleteAttachment(assetId, attachment.get_id());
            }
        }
        this.deleteAsset(assetId);
    }

    @Override
    public Asset getAsset(String assetId) throws IOException, BadVersionException, RequestFailureException {
        HttpURLConnection connection = this.createHttpURLConnectionToMassive("/assets/" + assetId);
        connection.setRequestMethod("GET");
        this.testResponseCode(connection);
        return JSONAssetConverter.readValue(connection.getInputStream());
    }

    private Asset getUnverifiedAsset(String assetId) throws IOException, RequestFailureException {
        HttpURLConnection connection = this.createHttpURLConnectionToMassive("/assets/" + assetId);
        connection.setRequestMethod("GET");
        this.testResponseCode(connection);
        return JSONAssetConverter.readUnverifiedValue(connection.getInputStream());
    }

    @Override
    public void updateState(String assetId, StateAction action) throws IOException, RequestFailureException {
        StateUpdateAction newState = new StateUpdateAction(action);
        HttpURLConnection connection = this.createHttpURLConnectionToMassive("/assets/" + assetId + "/state");
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setDoOutput(true);
        JSONAssetConverter.writeValue(connection.getOutputStream(), newState);
        this.testResponseCode(connection, true);
    }

    private HttpURLConnection createHttpURLConnectionToMassive(String path) throws IOException {
        return this.createHttpURLConnection(this.loginInfo.getRepositoryUrl() + path);
    }

    private HttpURLConnection createHttpURLConnection(String urlString) throws IOException {
        String connectingString = urlString.contains("?") ? "&" : "?";
        return this.createRealHttpURLConnection(urlString + connectingString + "apiKey=" + this.loginInfo.getApiKey());
    }

    private URL createURL(final String urlString) throws MalformedURLException {
        URL url;
        try {
            url = AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){

                @Override
                public URL run() throws MalformedURLException {
                    return new URL(urlString);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (MalformedURLException)e.getCause();
        }
        return url;
    }

    /*
     * Enabled aggressive block sorting
     */
    private HttpURLConnection createRealHttpURLConnection(String urlString) throws IOException {
        URL url = this.createURL(urlString);
        HttpURLConnection connection = null;
        if (this.loginInfo.getProxy() != null) {
            LoginInfoClientProxy clientProxy = this.loginInfo.getProxy();
            if (!clientProxy.isHTTPorHTTPS()) {
                UnsupportedOperationException ue = new UnsupportedOperationException("Non-HTTP proxy not supported");
                throw new IOException(ue);
            }
            LoginInfoClientProxy loginProxy = this.loginInfo.getProxy();
            Proxy javaNetProxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(loginProxy.getProxyURL().getHost(), loginProxy.getProxyURL().getPort()));
            connection = (HttpURLConnection)url.openConnection(javaNetProxy);
        } else {
            connection = (HttpURLConnection)url.openConnection();
        }
        connection.setReadTimeout(300000);
        this.addAuthToConnection(connection);
        String userAgent = this.loginInfo.getUserAgent();
        if (userAgent != null && !userAgent.isEmpty()) {
            connection.setRequestProperty("User-Agent", userAgent);
        }
        return connection;
    }

    private void addAuthToConnection(HttpURLConnection connection) {
        String basicAuthUserPass = null;
        if (this.loginInfo.getSoftlayerUserId() != null) {
            basicAuthUserPass = this.loginInfo.getSoftlayerUserId() + ":" + this.loginInfo.getSoftlayerPassword();
        } else if (this.loginInfo.getUserId() != null && this.loginInfo.getPassword() != null) {
            basicAuthUserPass = this.loginInfo.getUserId() + ":" + this.loginInfo.getPassword();
        }
        if (basicAuthUserPass != null) {
            String basicAuth = "Basic " + DatatypeConverter.printBase64Binary((byte[])basicAuthUserPass.getBytes(Charset.forName("UTF-8")));
            connection.setRequestProperty("Authorization", basicAuth);
        }
        if (this.loginInfo.getUserId() != null) {
            connection.addRequestProperty("userId", this.loginInfo.getUserId());
        }
        if (this.loginInfo.getPassword() != null) {
            connection.addRequestProperty("password", this.loginInfo.getPassword());
        }
    }

    @Override
    public Attachment updateAttachment(String assetId, AttachmentSummary summary) throws IOException, BadVersionException, RequestFailureException {
        Asset ass = this.getAsset(assetId);
        List<Attachment> attachments = ass.getAttachments();
        if (attachments != null) {
            for (Attachment attachment : attachments) {
                if (!attachment.getName().equals(summary.getName())) continue;
                this.deleteAttachment(assetId, attachment.get_id());
                break;
            }
        }
        return this.addAttachment(assetId, summary);
    }

    @Override
    public Collection<Asset> getFilteredAssets(Map<FilterableAttribute, Collection<String>> filters) throws IOException, RequestFailureException {
        if (filters == null || this.allFiltersAreEmpty(filters)) {
            return this.getAllAssets();
        }
        HashSet<String> filterStrings = new HashSet<String>();
        for (Map.Entry<FilterableAttribute, Collection<String>> filter : filters.entrySet()) {
            Collection<String> values = filter.getValue();
            if (values == null || values.isEmpty()) continue;
            filterStrings.add(this.createListFilter(filter.getKey(), values));
        }
        StringBuilder filterString = new StringBuilder("?");
        boolean isFirst = true;
        for (String filter : filterStrings) {
            if (isFirst) {
                isFirst = false;
            } else {
                filterString.append("&");
            }
            filterString.append(filter);
        }
        HttpURLConnection connection = this.createHttpURLConnectionToMassive("/assets" + filterString.toString());
        connection.setRequestMethod("GET");
        this.testResponseCode(connection);
        return JSONAssetConverter.readValues(connection.getInputStream());
    }

    private String createListFilter(FilterableAttribute attribute, Collection<String> values) {
        Collection<Object> filter2Values;
        boolean firstFilter1Value = true;
        boolean firstFilter2Value = true;
        StringBuilder filter1 = new StringBuilder(attribute.getAttributeName()).append("=");
        StringBuilder filter2 = new StringBuilder();
        Collection<Object> collection = filter2Values = attribute.getValuesInSecondaryAttributeName() == null ? Collections.emptySet() : attribute.getValuesInSecondaryAttributeName();
        if (attribute.getSecondaryAttributeName() != null) {
            filter2 = filter2.append(attribute.getSecondaryAttributeName()).append("=");
        }
        for (String value : values) {
            if (filter2Values.contains(value)) {
                try {
                    value = URLEncoder.encode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
                if (firstFilter2Value) {
                    firstFilter2Value = false;
                } else {
                    filter2.append("|");
                }
                filter2.append(value);
                continue;
            }
            try {
                value = URLEncoder.encode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            if (firstFilter1Value) {
                firstFilter1Value = false;
            } else {
                filter1.append("|");
            }
            filter1.append(value);
        }
        if (!firstFilter1Value && !firstFilter2Value) {
            throw new IllegalArgumentException("Unable to filter values that come from two different JSON objects, attempted to filter " + (Object)((Object)attribute) + " using values " + values);
        }
        if (!firstFilter1Value) {
            return filter1.toString();
        }
        if (!firstFilter2Value) {
            return filter2.toString();
        }
        return null;
    }

    private void testResponseCode(HttpURLConnection connection) throws RequestFailureException, IOException {
        this.testResponseCode(connection, false);
    }

    private void testResponseCode(HttpURLConnection connection, boolean clearInputStream) throws RequestFailureException, IOException {
        int responseCode = connection.getResponseCode();
        if (responseCode >= 200 && responseCode < 300) {
            if (clearInputStream) {
                this.clearInputStream(connection);
            }
            return;
        }
        InputStream errorStream = connection.getErrorStream();
        String errorStreamString = null;
        String message = null;
        if (errorStream != null) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            int read = -1;
            while ((read = errorStream.read()) != -1) {
                outputStream.write(read);
            }
            errorStreamString = outputStream.toString(RestClient.getCharset(connection.getContentType()));
            message = this.parseErrorObject(errorStreamString);
        } else {
            message = connection.getResponseMessage();
        }
        throw new RequestFailureException(responseCode, message, connection.getURL(), errorStreamString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearInputStream(HttpURLConnection conn) {
        InputStream is = null;
        byte[] buffer = new byte[1024];
        try {
            is = conn.getInputStream();
            while (is.read(buffer) != -1) {
            }
        }
        catch (IOException e) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static String getCharset(String contentType) {
        String charset;
        block3: {
            charset = "UTF-8";
            try {
                String[] params;
                if (contentType == null || contentType.isEmpty() || !contentType.contains(";")) break block3;
                for (String param : params = contentType.substring(contentType.indexOf(";")).split(";")) {
                    String paramValue;
                    String paramName;
                    if ((param = param.trim()).indexOf("=") <= 0 || !"charset".equals(paramName = param.substring(0, param.indexOf("=")).trim()) || param.length() <= param.indexOf("=") + 1 || (paramValue = param.substring(param.indexOf("=") + 1).trim()) == null || paramValue.isEmpty() || !Charset.isSupported(paramValue)) continue;
                    charset = paramValue;
                    break;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return charset;
    }

    private String parseErrorObject(String errorObject) {
        if (errorObject == null) {
            return null;
        }
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(errorObject.getBytes(Charset.forName("UTF-8")));
            JsonReader jsonReader = Json.createReader((InputStream)inputStream);
            JsonObject parsedObject = jsonReader.readObject();
            jsonReader.close();
            Object errorMessage = parsedObject.get((Object)"message");
            if (errorMessage != null && errorMessage instanceof JsonString && !((JsonString)errorMessage).getString().isEmpty()) {
                return ((JsonString)errorMessage).getString();
            }
            return errorObject;
        }
        catch (JsonException e) {
            return errorObject;
        }
    }
}

