/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.resources.internal;

import com.ibm.ws.repository.common.enums.ResourceType;
import com.ibm.ws.repository.connections.RepositoryConnection;
import com.ibm.ws.repository.exceptions.RepositoryBackendException;
import com.ibm.ws.repository.exceptions.RepositoryResourceCreationException;
import com.ibm.ws.repository.exceptions.RepositoryResourceException;
import com.ibm.ws.repository.resources.AttachmentResource;
import com.ibm.ws.repository.resources.internal.AppliesToProcessor;
import com.ibm.ws.repository.resources.internal.ExtendedMatchingData;
import com.ibm.ws.repository.resources.internal.ProductRelatedResourceImpl;
import com.ibm.ws.repository.resources.internal.RepositoryResourceImpl;
import com.ibm.ws.repository.resources.internal.RepositoryResourceMatchingData;
import com.ibm.ws.repository.resources.writeable.ProductResourceWritable;
import com.ibm.ws.repository.transport.model.AppliesToFilterInfo;
import com.ibm.ws.repository.transport.model.Asset;
import java.util.List;
import org.osgi.resource.Requirement;

public class ProductResourceImpl
extends ProductRelatedResourceImpl
implements ProductResourceWritable {
    public ProductResourceImpl(RepositoryConnection repoConnection) {
        this(repoConnection, null);
    }

    public ProductResourceImpl(RepositoryConnection repoConnection, Asset ass) {
        super(repoConnection, ass);
    }

    @Override
    public RepositoryResourceMatchingData createMatchingData() {
        ExtendedMatchingData matchingData = new ExtendedMatchingData();
        matchingData.setType(this.getType());
        matchingData.setName(this.getName());
        matchingData.setProviderName(this.getProviderName());
        if (this.getType().equals((Object)ResourceType.INSTALL)) {
            matchingData.setVersion(this.getProductVersion());
        } else {
            try {
                List<AppliesToFilterInfo> atfi = this.generateAppliesToFilterInfoList(false);
                matchingData.setAtfi(atfi);
            }
            catch (RepositoryResourceCreationException e) {
                // empty catch block
            }
        }
        for (Requirement requirement : this.getGenericRequirements()) {
            if (!requirement.getNamespace().equals("osgi.native")) continue;
            matchingData.setPlatformInfo((String)requirement.getDirectives().get("filter"));
        }
        return matchingData;
    }

    @Override
    protected String getNameForVanityUrl() {
        String name = this.getName();
        try {
            int index;
            AttachmentResource attach = this.getMainAttachment();
            if (attach != null && (name = attach.getName()) != null && !name.isEmpty() && (index = name.lastIndexOf("-")) != -1) {
                name = name.substring(0, index);
            }
        }
        catch (RepositoryBackendException e) {
            return this.getName();
        }
        catch (RepositoryResourceException e) {
            return this.getName();
        }
        return name;
    }

    @Override
    public void setAppliesTo(String appliesTo) {
        this._asset.getWlpInformation().setAppliesTo(appliesTo);
    }

    @Override
    public String getAppliesTo() {
        return this._asset.getWlpInformation().getAppliesTo();
    }

    @Override
    protected void copyFieldsFrom(RepositoryResourceImpl fromResource, boolean includeAttachmentInfo) {
        super.copyFieldsFrom(fromResource, includeAttachmentInfo);
        ProductResourceImpl prodRes = (ProductResourceImpl)fromResource;
        this.setAppliesTo(prodRes.getAppliesTo());
    }

    @Override
    public void setType(ResourceType type) {
        super.setType(type);
    }

    @Override
    public void updateGeneratedFields(boolean performEditionChecking) throws RepositoryResourceCreationException {
        super.updateGeneratedFields(performEditionChecking);
        if (this.getType() == ResourceType.INSTALL) {
            this.generateAppliesToFilterInfo();
        }
    }

    public void generateAppliesToFilterInfo() {
        List<AppliesToFilterInfo> filter = AppliesToProcessor.parseAppliesToHeader(this.getProductId() + "; productEdition=" + this.getProductEdition() + "; productVersion=" + this.getProductVersion());
        this._asset.getWlpInformation().setAppliesToFilterInfo(filter);
    }
}

