/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.messaging.security.authorization.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.messaging.security.MessagingSecurityException;
import com.ibm.ws.messaging.security.authorization.MessagingAuthorizationException;
import com.ibm.ws.messaging.security.authorization.MessagingAuthorizationService;
import com.ibm.ws.messaging.security.beans.Permission;
import com.ibm.ws.messaging.security.beans.QueuePermission;
import com.ibm.ws.messaging.security.beans.TemporaryDestinationPermission;
import com.ibm.ws.messaging.security.beans.TopicPermission;
import com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImpl;
import com.ibm.ws.messaging.security.utility.MessagingSecurityUtility;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;

public class MessagingAuthorizationServiceImpl
implements MessagingAuthorizationService {
    private static TraceComponent tc = SibTr.register(MessagingAuthorizationServiceImpl.class, (String)"MessagingSecurity", (String)"com.ibm.ws.messaging.security.CWWKMMessages");
    private static final String CLASS_NAME = "com.ibm.ws.messaging.security.authorization.internal.MessagingAuthorizationServiceImpl";
    private MessagingSecurityServiceImpl messagingSecurityService = null;

    public MessagingAuthorizationServiceImpl(MessagingSecurityServiceImpl messagingSecurityService) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authorization.internal.MessagingAuthorizationServiceImplconstructor", (Object)messagingSecurityService);
        }
        this.messagingSecurityService = messagingSecurityService;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authorization.internal.MessagingAuthorizationServiceImplconstructor");
        }
    }

    private void checkIfUserIsAuthenticated(Subject subject) throws MessagingAuthorizationException {
        try {
            this.messagingSecurityService.isUnauthenticated(subject);
        }
        catch (Exception e) {
            throw new MessagingAuthorizationException(e.getMessage());
        }
    }

    public boolean checkQueueAccess(Subject authenticatedSubject, String destination, String operationType, boolean logWarning) throws MessagingAuthorizationException {
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authorization.internal.MessagingAuthorizationServiceImplcheckQueueAccess", (Object)new Object[]{authenticatedSubject, destination, operationType});
        if (operationType.equalsIgnoreCase("BROWSE") && this.checkQueueAccess(authenticatedSubject, destination, "RECEIVE", false)) {
            return true;
        }
        this.checkIfUserIsAuthenticated(authenticatedSubject);
        String userName = null;
        try {
            userName = MessagingSecurityUtility.getUniqueUserName(authenticatedSubject);
        }
        catch (MessagingSecurityException e) {
            throw new MessagingAuthorizationException(Tr.formatMessage((TraceComponent)tc, (String)"USER_NOT_AUTHORIZED_MSE1010", (Object[])new Object[]{userName, operationType, destination}), (Throwable)e);
        }
        Map<String, QueuePermission> queuePermissions = this.messagingSecurityService.getQueuePermissions();
        QueuePermission permission = queuePermissions.get(destination);
        boolean result = this.checkPermission((Permission)permission, operationType, userName);
        if (!result && logWarning) {
            SibTr.debug((TraceComponent)tc, (String)"USER_NOT_AUTHORIZED_MSE1010", (Object)new Object[]{userName, operationType, destination});
            throw new MessagingAuthorizationException(Tr.formatMessage((TraceComponent)tc, (String)"USER_NOT_AUTHORIZED_MSE1010", (Object[])new Object[]{userName, operationType, destination}));
        }
        SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authorization.internal.MessagingAuthorizationServiceImplcheckQueueAccess", (Object)result);
        return result;
    }

    private boolean checkPermission(Permission permission, String operationType, String userName) {
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authorization.internal.MessagingAuthorizationServiceImplcheckPermission", (Object)new Object[]{permission, operationType, userName});
        if (permission != null) {
            List<String> groups;
            Map userRoleMap = permission.getRoleToUserMap();
            Set usersHavingRole = (Set)userRoleMap.get(operationType);
            if (usersHavingRole != null && usersHavingRole.contains(userName)) {
                SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authorization.internal.MessagingAuthorizationServiceImplcheckPermission", (Object)true);
                return true;
            }
            Map groupRoleMap = permission.getRoleToGroupMap();
            Set groupsHavingRole = (Set)groupRoleMap.get(operationType);
            if (groupsHavingRole != null && (groups = MessagingSecurityUtility.getGroupsAssociatedToUser(userName, this.messagingSecurityService)) != null) {
                for (String group : groups) {
                    if (!groupsHavingRole.contains(group)) continue;
                    SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authorization.internal.MessagingAuthorizationServiceImplcheckPermission", (Object)true);
                    return true;
                }
            }
        }
        SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authorization.internal.MessagingAuthorizationServiceImplcheckPermission", (Object)false);
        return false;
    }

    public boolean checkTemporaryDestinationAccess(Subject authenticatedSubject, String destinationName, String operationType) throws MessagingAuthorizationException {
        String prefix;
        TemporaryDestinationPermission permission;
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authorization.internal.MessagingAuthorizationServiceImplcheckTemporaryDestinationAccess", (Object)new Object[]{authenticatedSubject, destinationName, operationType});
        this.checkIfUserIsAuthenticated(authenticatedSubject);
        String userName = null;
        boolean result = false;
        try {
            userName = MessagingSecurityUtility.getUniqueUserName(authenticatedSubject);
        }
        catch (MessagingSecurityException e) {
            throw new MessagingAuthorizationException(Tr.formatMessage((TraceComponent)tc, (String)"USER_NOT_AUTHORIZED_MSE1010", (Object[])new Object[]{userName, operationType, destinationName}), (Throwable)e);
        }
        Map<String, TemporaryDestinationPermission> tempDestinationPermissions = this.messagingSecurityService.getTemporaryDestinationPermissions();
        List<String> prefixList = this.getPrefixMatchingTemporaryDestination(tempDestinationPermissions.keySet(), destinationName);
        Iterator<String> iterator = prefixList.iterator();
        while (iterator.hasNext() && !(result = this.checkPermission((Permission)(permission = tempDestinationPermissions.get(prefix = iterator.next())), operationType, userName))) {
        }
        if (!result) {
            SibTr.debug((TraceComponent)tc, (String)"USER_NOT_AUTHORIZED_MSE1010", (Object)new Object[]{userName, operationType, destinationName});
            throw new MessagingAuthorizationException(Tr.formatMessage((TraceComponent)tc, (String)"USER_NOT_AUTHORIZED_MSE1010", (Object[])new Object[]{userName, operationType, destinationName}));
        }
        SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authorization.internal.MessagingAuthorizationServiceImplcheckTemporaryDestinationAccess", (Object)result);
        return result;
    }

    private List<String> getPrefixMatchingTemporaryDestination(Set<String> keySet, String destinationName) {
        ArrayList<String> prefixList = new ArrayList<String>();
        for (String key : keySet) {
            if (!destinationName.startsWith(key)) continue;
            prefixList.add(key);
        }
        return prefixList;
    }

    public boolean checkTopicAccess(Subject authenticatedSubject, String topicSpace, String topicName, String operationType) throws MessagingAuthorizationException {
        String destinationName = topicSpace;
        if (topicName != null) {
            destinationName = topicSpace + "/" + topicName;
        }
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authorization.internal.MessagingAuthorizationServiceImplcheckTopicAccess", (Object)new Object[]{authenticatedSubject, destinationName, operationType});
        this.checkIfUserIsAuthenticated(authenticatedSubject);
        String userName = null;
        try {
            userName = MessagingSecurityUtility.getUniqueUserName(authenticatedSubject);
        }
        catch (MessagingSecurityException e) {
            throw new MessagingAuthorizationException(Tr.formatMessage((TraceComponent)tc, (String)"USER_NOT_AUTHORIZED_MSE1010", (Object[])new Object[]{userName, operationType, destinationName}), (Throwable)e);
        }
        Map<String, TopicPermission> topicPermissions = this.messagingSecurityService.getTopicPermissions();
        TopicPermission permission = this.getTopicPermission(topicPermissions, destinationName);
        boolean result = this.checkPermission((Permission)permission, operationType, userName);
        if (!result) {
            SibTr.debug((TraceComponent)tc, (String)"USER_NOT_AUTHORIZED_MSE1010", (Object)new Object[]{userName, operationType, destinationName});
            throw new MessagingAuthorizationException(Tr.formatMessage((TraceComponent)tc, (String)"USER_NOT_AUTHORIZED_MSE1010", (Object[])new Object[]{userName, operationType, destinationName}));
        }
        SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authorization.internal.MessagingAuthorizationServiceImplcheckTopicAccess", (Object)result);
        return result;
    }

    private TopicPermission getTopicPermission(Map<String, TopicPermission> topicPermissions, String destinationName) {
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authorization.internal.MessagingAuthorizationServiceImplgetTopicPermission", (Object)destinationName);
        TopicPermission permission = null;
        Set<String> topicKeySet = topicPermissions.keySet();
        int lastIndexOfDelimiter = -1;
        if (topicKeySet.contains(destinationName)) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authorization.internal.MessagingAuthorizationServiceImplgetTopicPermission", permission);
            return topicPermissions.get(destinationName);
        }
        while ((lastIndexOfDelimiter = destinationName.lastIndexOf("/")) != -1) {
            destinationName = destinationName.substring(0, lastIndexOfDelimiter);
            permission = this.getTopicPermission(topicPermissions, destinationName);
        }
        SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authorization.internal.MessagingAuthorizationServiceImplgetTopicPermission", permission);
        return permission;
    }

    public boolean checkAliasAccess(Subject authenticatedSubject, String destination, String aliasDestination, int destinationType, String operationType, boolean logWarning) throws MessagingAuthorizationException {
        Map<String, QueuePermission> destinationPermission;
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authorization.internal.MessagingAuthorizationServiceImplcheckAliasAccess", (Object)new Object[]{authenticatedSubject, aliasDestination, operationType});
        if (operationType.equalsIgnoreCase("BROWSE") && this.checkAliasAccess(authenticatedSubject, destination, aliasDestination, destinationType, "RECEIVE", false)) {
            return true;
        }
        this.checkIfUserIsAuthenticated(authenticatedSubject);
        String userName = null;
        try {
            userName = MessagingSecurityUtility.getUniqueUserName(authenticatedSubject);
        }
        catch (MessagingSecurityException e) {
            throw new MessagingAuthorizationException(Tr.formatMessage((TraceComponent)tc, (String)"USER_NOT_AUTHORIZED_MSE1010", (Object[])new Object[]{userName, operationType, aliasDestination}), (Throwable)e);
        }
        Permission permission = null;
        if (destinationType == 0) {
            destinationPermission = this.messagingSecurityService.getQueuePermissions();
            permission = (Permission)destinationPermission.get(destination);
        } else if (destinationType == 1) {
            destinationPermission = this.messagingSecurityService.getTopicPermissions();
            permission = (Permission)destinationPermission.get(destination);
        }
        boolean result = this.checkPermission(permission, operationType, userName);
        if (!result && logWarning) {
            SibTr.debug((TraceComponent)tc, (String)"USER_NOT_AUTHORIZED_MSE1010", (Object)new Object[]{userName, operationType, aliasDestination});
            throw new MessagingAuthorizationException(Tr.formatMessage((TraceComponent)tc, (String)"USER_NOT_AUTHORIZED_MSE1010", (Object[])new Object[]{userName, operationType, aliasDestination}));
        }
        SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authorization.internal.MessagingAuthorizationServiceImplcheckAliasAccess", (Object)result);
        return result;
    }
}

