/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.member.metadata;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.collective.member.metadata.AdminMetadataPublisher;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={EventHandler.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM", "event.topics=com/ibm/wsspi/collective/repository/publish/mbean", "event.filter=(|(mbeanObjectName=WebSphere:feature=clusterMember,type=ClusterMember,name=ClusterMember) (mbeanObjectName=WebSphere:service=com.ibm.websphere.application.ApplicationMBean*))"})
public class AdminMetadataMemberEventHandler
implements EventHandler {
    private static final TraceComponent tc = Tr.register(AdminMetadataMemberEventHandler.class, (String)"Collective", (String)"com.ibm.ws.collective.member.internal.resources.CollectiveMemberMessages");
    public static final String CLUSTER_MEMBER_MBEAN_OBJECT_NAME = "WebSphere:feature=clusterMember,type=ClusterMember,name=ClusterMember";
    public static final String APPLICATION_MBEAN_OBJECT_NAME = "WebSphere:service=com.ibm.websphere.application.ApplicationMBean*";
    private static final String APPLICATION_MBEAN_OBJECT_NAME_INTERNAL = "WebSphere:service=com.ibm.websphere.application.ApplicationMBean";
    private volatile boolean active = false;
    private AdminMetadataPublisher metadataPublisher = null;
    static final long serialVersionUID = -3755963514033578733L;

    @Reference(service=AdminMetadataPublisher.class)
    protected void setAdminMetadataPublisher(AdminMetadataPublisher reference) {
        this.metadataPublisher = reference;
    }

    protected void unsetAdminMetadataPublisher(AdminMetadataPublisher reference) {
        if (this.metadataPublisher == reference) {
            this.metadataPublisher = null;
        }
    }

    @Activate
    protected void activate(ComponentContext cc) {
        this.active = true;
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.active = false;
    }

    public void handleEvent(Event event) {
        String objectName = (String)event.getProperty("mbeanObjectName");
        String attributeName = (String)event.getProperty("mbeanAttributeName");
        Object attributeValue = event.getProperty("mbeanAttributeValue");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Event received, topic=" + event.getTopic() + ", objectName=" + objectName + ", attributeName=" + attributeName + ", attributeValue=" + attributeValue), (Object[])new Object[0]);
        }
        if (this.active) {
            if (objectName.equals(CLUSTER_MEMBER_MBEAN_OBJECT_NAME)) {
                this.publishCluster(attributeValue);
            } else if (objectName.contains(APPLICATION_MBEAN_OBJECT_NAME_INTERNAL)) {
                this.publishApp(objectName, attributeValue);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"deactivated, skipping this event", (Object[])new Object[0]);
        }
    }

    private void publishCluster(Object attributeValue) {
        String clusterName = (String)attributeValue;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("cluster is updated: " + clusterName), (Object[])new Object[0]);
        }
        if (this.metadataPublisher != null && this.metadataPublisher.publishMetadata("cluster", clusterName)) {
            Tr.info((TraceComponent)tc, (String)"SERVER_CONFIGURATION_CHANGED", (Object[])new Object[]{clusterName});
        }
    }

    private void publishApp(String objectName, Object attributeValue) {
        String appName = this.getAppName(objectName.toString());
        String state = (String)attributeValue;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("app is updated: " + appName + " and app's state: " + state), (Object[])new Object[0]);
        }
        if (state != null && (state.equals("INSTALLED") || state.equals("STARTED")) && this.metadataPublisher != null && this.metadataPublisher.publishMetadata("application", appName)) {
            Tr.info((TraceComponent)tc, (String)"SERVER_CONFIGURATION_CHANGED", (Object[])new Object[]{appName});
        }
    }

    private String getAppName(String objectName) {
        String appName = objectName.substring(objectName.indexOf("name=") + 5);
        return appName.split(",")[0];
    }
}

