/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.member.internal.publisher;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.collective.member.MemberJMXEndpoint;
import com.ibm.ws.collective.member.internal.HostAuthConfig;
import com.ibm.ws.collective.member.internal.ssh.SSHKeyUtility;
import com.ibm.ws.collective.member.internal.ssh.SSHKeyUtilityImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.collective.repository.publisher.RepositoryPublisher;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={EventHandler.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM", "event.topics=com/ibm/wsspi/collective/repository/publishStatus/data", "event.filter=(|(dataName=sys.host.auth.info) (dataName=sys.jmx.auth.info))"})
public final class ServerManagementPublisher
implements EventHandler {
    private static final TraceComponent tc = Tr.register(ServerManagementPublisher.class);
    static final String KEY_EVENT_ADMIN_REF = "eventAdmin";
    static final String KEY_LOCATION_ADMIN_REF = "locationAdmin";
    static final String KEY_HOST_AUTH_CONFIG_REF = "hostAuthConfig";
    static final String KEY_MEMBER_JMX_ENDPOINT_REF = "memberJMXEndpoint";
    private final AtomicServiceReference<EventAdmin> eventAdminRef = new AtomicServiceReference("eventAdmin");
    private final AtomicServiceReference<WsLocationAdmin> locationAdminRef = new AtomicServiceReference("locationAdmin");
    private final AtomicServiceReference<HostAuthConfig> hostAuthConfigRef = new AtomicServiceReference("hostAuthConfig");
    private final AtomicServiceReference<MemberJMXEndpoint> memberJMXEndpointRef = new AtomicServiceReference("memberJMXEndpoint");
    static final String PATH_HOST_AUTH_INFO = "sys.host.auth.info";
    static final String PATH_JMX_AUTH_INFO = "sys.jmx.auth.info";
    private boolean publishedHostAuthInfo = false;
    private boolean publishedJMXAuthInfo = false;
    private ExecutorService executorService = null;
    private ServiceRegistration<EventHandler> jmxEndpointChangeListnerReg = null;
    private final SSHKeyUtility sshKeyUtil;
    static final long serialVersionUID = 5483810504767530832L;

    public ServerManagementPublisher() {
        this.sshKeyUtil = new SSHKeyUtilityImpl();
    }

    public ServerManagementPublisher(SSHKeyUtility sshKeyUtil) {
        this.sshKeyUtil = sshKeyUtil;
    }

    @Reference(name="eventAdmin", service=EventAdmin.class)
    protected void setEventAdminService(ServiceReference<EventAdmin> ref) {
        this.eventAdminRef.setReference(ref);
    }

    protected void unsetEventAdminService(ServiceReference<EventAdmin> ref) {
        this.eventAdminRef.unsetReference(ref);
    }

    @Reference(service=ExecutorService.class)
    protected void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    protected void unsetExecutorService(ExecutorService executorService) {
        this.executorService = null;
    }

    @Reference(name="locationAdmin", service=WsLocationAdmin.class, policy=ReferencePolicy.DYNAMIC)
    protected void setLocationAdmin(ServiceReference<WsLocationAdmin> ref) {
        this.locationAdminRef.setReference(ref);
    }

    protected void unsetLocationAdmin(ServiceReference<WsLocationAdmin> ref) {
        this.locationAdminRef.unsetReference(ref);
    }

    @Reference(name="hostAuthConfig", service=HostAuthConfig.class, policy=ReferencePolicy.DYNAMIC)
    protected void setHostAuthConfig(ServiceReference<HostAuthConfig> ref) {
        this.hostAuthConfigRef.setReference(ref);
    }

    protected void updatedHostAuthConfig(ServiceReference<HostAuthConfig> ref) {
        this.executorService.submit(new PublishAuthInfo());
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"The hostAuthInfo config has changed. The management configuration has been scheduled for publishing", (Object[])new Object[0]);
        }
    }

    protected void unsetHostAuthConfig(ServiceReference<HostAuthConfig> ref) {
        this.hostAuthConfigRef.unsetReference(ref);
    }

    @Reference(name="memberJMXEndpoint", service=MemberJMXEndpoint.class)
    protected void setMemberJMXEndpoint(ServiceReference<MemberJMXEndpoint> reference) {
        this.memberJMXEndpointRef.setReference(reference);
    }

    protected void unsetMemberJMXEndpoint(ServiceReference<MemberJMXEndpoint> reference) {
        this.memberJMXEndpointRef.unsetReference(reference);
    }

    @Reference(service=RepositoryPublisher.class)
    protected void setRepositoryPublisher(ServiceReference<RepositoryPublisher> ref) {
    }

    protected void unsetRepositoryPublisher(ServiceReference<RepositoryPublisher> ref) {
    }

    private ServiceRegistration<EventHandler> registerJMXEndpointChangeListener(ComponentContext cc) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("event.topics", "com/ibm/ws/management/repository/member/MemberJMXEndpoint/updated");
        return cc.getBundleContext().registerService(EventHandler.class, (Object)new JMXEndpointUpdatedEventHandler(), properties);
    }

    @Activate
    protected void activate(ComponentContext cc) throws Exception {
        this.eventAdminRef.activate(cc);
        this.locationAdminRef.activate(cc);
        this.hostAuthConfigRef.activate(cc);
        this.memberJMXEndpointRef.activate(cc);
        this.jmxEndpointChangeListnerReg = this.registerJMXEndpointChangeListener(cc);
        this.executorService.submit(new PublishAuthInfo());
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Server management configuration has been scheduled for publishing", (Object[])new Object[0]);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) throws Exception {
        if (this.jmxEndpointChangeListnerReg != null) {
            this.jmxEndpointChangeListnerReg.unregister();
            this.jmxEndpointChangeListnerReg = null;
        }
        this.eventAdminRef.deactivate(cc);
        this.locationAdminRef.deactivate(cc);
        this.hostAuthConfigRef.deactivate(cc);
        this.memberJMXEndpointRef.deactivate(cc);
    }

    @Trivial
    private void putIfDefined(Map<String, Object> source, Map<String, Object> target, String key) {
        if (source.containsKey(key)) {
            target.put(key, source.get(key));
        }
    }

    @Sensitive
    private Map<String, Object> buildHostAuthInfo(@Sensitive Map<String, Object> configData) {
        HashMap<String, Object> hostAuthInfo = new HashMap<String, Object>();
        hostAuthInfo.put("osName", configData.get("osName"));
        hostAuthInfo.put("rpcHost", configData.get("rpcHost"));
        hostAuthInfo.put("rpcPort", configData.get("rpcPort"));
        hostAuthInfo.put("rpcUser", configData.get("rpcUser"));
        this.putIfDefined(configData, hostAuthInfo, "rpcUserPassword");
        this.putIfDefined(configData, hostAuthInfo, "sshPrivateKey");
        this.putIfDefined(configData, hostAuthInfo, "sshPrivateKeyPassword");
        this.putIfDefined(configData, hostAuthInfo, "useSudo");
        this.putIfDefined(configData, hostAuthInfo, "sudoUser");
        this.putIfDefined(configData, hostAuthInfo, "sudoUserPassword");
        return hostAuthInfo;
    }

    private void publishHostAuthInfo(EventAdmin eventAdmin, @Sensitive Map<String, Object> configData) {
        HashMap<String, Object> eventProps = new HashMap<String, Object>();
        if (!configData.isEmpty()) {
            Map<String, Object> hostAuthInfo = this.buildHostAuthInfo(configData);
            eventProps.put("operation", "UPDATE");
            eventProps.put("dataValue", hostAuthInfo);
        } else {
            eventProps.put("operation", "DELETE");
        }
        eventProps.put("sendStatusEvent", "true");
        eventProps.put("dataName", PATH_HOST_AUTH_INFO);
        eventAdmin.postEvent(new Event("com/ibm/wsspi/collective/repository/publish/data", eventProps));
    }

    private Map<String, Object> buildJMXAuthInfo(MemberJMXEndpoint jmxEndpoint) {
        String hostName = jmxEndpoint.getHostName();
        String httpsPort = jmxEndpoint.getHTTPSPort();
        if (tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)(" Retrieved jmx endpoint info: hostName = " + hostName + ", httpsPort = " + httpsPort), (Object[])new Object[0]);
        }
        HashMap<String, Object> jmxAuthInfo = null;
        if (hostName == null || httpsPort == null) {
            Tr.warning((TraceComponent)tc, (String)"SERVER_MANAGEMENT_INCOMPLETE_ENDPOINT_DATA", (Object[])new Object[0]);
        } else {
            jmxAuthInfo = new HashMap<String, Object>();
            jmxAuthInfo.put("jmxHost", hostName);
            jmxAuthInfo.put("jmxPort", httpsPort);
        }
        return jmxAuthInfo;
    }

    private void publishJMXAuthInfo(EventAdmin eventAdmin, MemberJMXEndpoint jmxEndpoint) {
        Map<String, Object> jmxAuthInfo = this.buildJMXAuthInfo(jmxEndpoint);
        if (jmxAuthInfo != null) {
            HashMap<String, Object> eventProps = new HashMap<String, Object>();
            eventProps.put("operation", "UPDATE");
            eventProps.put("sendStatusEvent", "true");
            eventProps.put("dataName", PATH_JMX_AUTH_INFO);
            eventProps.put("dataValue", jmxAuthInfo);
            eventAdmin.postEvent(new Event("com/ibm/wsspi/collective/repository/publish/data", eventProps));
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"We could not build the JMX auth info, nothing to publish. A warning will have been printed earlier to describe what went wrong.", (Object[])new Object[0]);
        }
    }

    private void validateMapInput(@Sensitive Map<String, Object> configData) {
        if (configData.containsKey("rpcUserPassword") && configData.containsKey("sshPrivateKeyPath")) {
            throw new IllegalStateException("This should never happen. We have a HostAuthConfig with both a user password and an SSH private key. This is not valid input for " + this.getClass().getCanonicalName());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void publishAuthInfo() {
        HashMap<String, Object> configData;
        block5: {
            this.publishedHostAuthInfo = false;
            this.publishedJMXAuthInfo = false;
            configData = new HashMap<String, Object>(this.getHostAuthConfigService().getHostAuthConfig());
            this.validateMapInput(configData);
            if (configData.containsKey("sshPrivateKeyPath")) {
                try {
                    String serverName = this.getEventAdminService().getServerName();
                    String publicKeyComment = "Generated SSH key for Liberty server " + serverName + " for Liberty management.";
                    String userHome = (String)configData.get("rpcUserHome");
                    String privateKeyPathName = (String)configData.get("sshPrivateKeyPath");
                    String publicKeyPathName = (String)configData.get("sshPublicKeyPath");
                    String encodedPrivateKey = this.sshKeyUtil.useSSHKeyPair(publicKeyComment, userHome, publicKeyPathName, privateKeyPathName);
                    configData.put("sshPrivateKey", encodedPrivateKey);
                }
                catch (NoSuchAlgorithmException serverName) {
                    FFDCFilter.processException((Throwable)serverName, (String)"com.ibm.ws.collective.member.internal.publisher.ServerManagementPublisher", (String)"417", (Object)this, (Object[])new Object[0]);
                    Tr.error((TraceComponent)tc, (String)"SSH_KEYGEN_NOSUCHALGORITHMEXCEPTION", (Object[])new Object[]{"RSA"});
                    if (tc.isDebugEnabled()) {
                        void e;
                        Tr.debug((TraceComponent)tc, (String)("Unable to compute SSH keys. Caught NoSuchAlgorithmException: " + e.getMessage()), (Object[])new Object[]{e});
                    }
                }
                catch (IOException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.collective.member.internal.publisher.ServerManagementPublisher", (String)"422", (Object)this, (Object[])new Object[0]);
                    Tr.error((TraceComponent)tc, (String)"SSH_KEYGEN_IOEXCEPTION", (Object[])new Object[]{e.getLocalizedMessage()});
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug((TraceComponent)tc, (String)("Unable to compute SSH keys. Caught IOException: " + e.getMessage()), (Object[])new Object[]{e});
                }
            }
        }
        EventAdmin eventAdmin = (EventAdmin)this.eventAdminRef.getService();
        this.publishHostAuthInfo(eventAdmin, configData);
        MemberJMXEndpoint jmxEndpoint = (MemberJMXEndpoint)this.memberJMXEndpointRef.getService();
        this.publishJMXAuthInfo(eventAdmin, jmxEndpoint);
    }

    private void handleOurStatusEvent(@Sensitive Event statusEvent, String publishedData) {
        if (statusEvent.containsProperty("errorMessage")) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Error during publishing " + publishedData), (Object[])new Object[]{statusEvent.getProperty("errorMessage")});
            }
            Tr.error((TraceComponent)tc, (String)"PUBLISHED_SERVER_MANAGEMENT_INFO_ERROR", (Object[])new Object[]{statusEvent.getProperty("errorMessage")});
        } else {
            if (PATH_HOST_AUTH_INFO.equals(publishedData)) {
                this.publishedHostAuthInfo = true;
            }
            if (PATH_JMX_AUTH_INFO.equals(publishedData)) {
                this.publishedJMXAuthInfo = true;
            }
            if (this.publishedHostAuthInfo && this.publishedJMXAuthInfo) {
                Tr.info((TraceComponent)tc, (String)"PUBLISHED_SERVER_MANAGEMENT_INFO", (Object[])new Object[0]);
            }
        }
    }

    public void handleEvent(@Sensitive Event statusEvent) {
        if (statusEvent == null) {
            return;
        }
        Object dataName = statusEvent.getProperty("dataName");
        if (dataName instanceof String) {
            String publishedData = (String)dataName;
            if (PATH_HOST_AUTH_INFO.equals(publishedData) || PATH_JMX_AUTH_INFO.equals(publishedData)) {
                this.handleOurStatusEvent(statusEvent, publishedData);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Received unexpected event.", (Object[])new Object[]{statusEvent});
            }
        }
    }

    @Trivial
    private HostAuthConfig getHostAuthConfigService() {
        HostAuthConfig service = (HostAuthConfig)this.hostAuthConfigRef.getService();
        if (service == null) {
            if (FrameworkState.isStopping()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Ignore that HostAuthConfigService is null because Framework is in the process of stopping or already stopped", (Object[])new Object[0]);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"HostAuthConfigService is null and Framework is not in the process of stopping or already stopped", (Object[])new Object[0]);
                }
                IllegalStateException ise = new IllegalStateException("The HostAuthConfig service is not available - it was likely accessed after it was deactivated.");
                ise.fillInStackTrace();
                throw ise;
            }
        }
        return service;
    }

    @Trivial
    private WsLocationAdmin getEventAdminService() {
        WsLocationAdmin service = (WsLocationAdmin)this.locationAdminRef.getService();
        if (service == null) {
            if (FrameworkState.isStopping()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Ignore that EventAdminService is null because Framework is in the process of stopping or already stopped", (Object[])new Object[0]);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"EventAdminService is null and Framework is not in the process of stopping or already stopped", (Object[])new Object[0]);
                }
                IllegalStateException ise = new IllegalStateException("The EventAdmin service is not available - it was likely accessed after it was deactivated.");
                ise.fillInStackTrace();
                throw ise;
            }
        }
        return service;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    final class PublishAuthInfo
    implements Callable<Object> {
        static final long serialVersionUID = -6301327350485550098L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        PublishAuthInfo() {
        }

        @Override
        public Object call() throws Exception {
            ServerManagementPublisher.this.publishAuthInfo();
            return null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(PublishAuthInfo.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    final class JMXEndpointUpdatedEventHandler
    implements EventHandler {
        static final long serialVersionUID = 1958508215858034653L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        JMXEndpointUpdatedEventHandler() {
        }

        public void handleEvent(Event event) {
            if (event == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"JMXEndpointUpdatedEventHandler received a null event, ignoring...", (Object[])new Object[0]);
                }
                return;
            }
            if ("com/ibm/ws/management/repository/member/MemberJMXEndpoint/updated".equals(event.getTopic())) {
                if (ServerManagementPublisher.this.executorService != null) {
                    ServerManagementPublisher.this.executorService.submit(new PublishAuthInfo());
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"The JMX endpoint has changed. The management configuration has been scheduled for publishing", (Object[])new Object[0]);
                    }
                } else if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"The executorService is null, we've been deactivated so nothing to do...", (Object[])new Object[0]);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"JMXEndpointUpdatedEventHandler received an unexpected topic, ignoring...", (Object[])new Object[0]);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(JMXEndpointUpdatedEventHandler.class);
        }
    }
}

