/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.classloading.ClassGenerator;
import com.ibm.ws.classloading.ClassLoaderIdentifierService;
import com.ibm.ws.classloading.LibertyClassLoadingService;
import com.ibm.ws.classloading.internal.AppClassLoader;
import com.ibm.ws.classloading.internal.ClassGeneratorManager;
import com.ibm.ws.classloading.internal.ClassLoaderConfigurationImpl;
import com.ibm.ws.classloading.internal.ClassLoaderFactory;
import com.ibm.ws.classloading.internal.CompositeResourceProvider;
import com.ibm.ws.classloading.internal.GatewayBundleFactory;
import com.ibm.ws.classloading.internal.GatewayClassLoader;
import com.ibm.ws.classloading.internal.GatewayConfigurationImpl;
import com.ibm.ws.classloading.internal.ShadowClassLoader;
import com.ibm.ws.classloading.internal.ThreadContextClassLoader;
import com.ibm.ws.classloading.internal.ThreadContextClassLoaderForBundles;
import com.ibm.ws.classloading.internal.UnifiedClassLoader;
import com.ibm.ws.classloading.internal.providers.WeakLibraryListener;
import com.ibm.ws.classloading.internal.util.CanonicalStore;
import com.ibm.ws.classloading.internal.util.ClassRedefiner;
import com.ibm.ws.classloading.internal.util.Factory;
import com.ibm.ws.classloading.serializable.ClassLoaderIdentityImpl;
import com.ibm.ws.container.service.metadata.extended.MetaDataIdentifierService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.classloading.ApiType;
import com.ibm.wsspi.classloading.ClassLoaderConfiguration;
import com.ibm.wsspi.classloading.ClassLoaderIdentity;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.classloading.ClassTransformer;
import com.ibm.wsspi.classloading.GatewayConfiguration;
import com.ibm.wsspi.classloading.ResourceProvider;
import com.ibm.wsspi.config.Fileset;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import com.ibm.wsspi.library.Library;
import java.io.File;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.equinox.region.RegionDigraph;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.BundleReference;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.url.URLStreamHandlerService;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={ClassLoadingService.class, LibertyClassLoadingService.class, ClassLoaderIdentifierService.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class ClassLoadingServiceImpl
implements LibertyClassLoadingService,
ClassLoaderIdentifierService {
    static final TraceComponent tc = Tr.register(ClassLoadingServiceImpl.class);
    private static final int TCCL_LOCK_WAIT = Integer.getInteger("com.ibm.ws.classloading.tcclLockWaitTimeMillis", 15000);
    static final String REFERENCE_GENERATORS = "generators";
    private BundleContext bundleContext;
    private CanonicalStore<ClassLoaderIdentity, AppClassLoader> aclStore;
    private CanonicalStore<String, ThreadContextClassLoader> tcclStore;
    private final ReentrantLock tcclStoreLock = new ReentrantLock();
    private RegionDigraph digraph;
    private ClassRedefiner redefiner = new ClassRedefiner(null);
    private final BundleListener listener = new BundleListener(){
        static final long serialVersionUID = -9159707349812113172L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bundleChanged(BundleEvent event) {
            if (event.getType() == 16) {
                ClassLoadingServiceImpl.this.classloaders.remove(event.getBundle());
            } else if (event.getType() == 32) {
                Map<Bundle, Set<GatewayClassLoader>> map = ClassLoadingServiceImpl.this.classloaders;
                synchronized (map) {
                    Set<GatewayClassLoader> gwCLs = ClassLoadingServiceImpl.this.classloaders.get(event.getBundle());
                    if (gwCLs != null) {
                        for (GatewayClassLoader gwCL : gwCLs) {
                            gwCL.populateNewLoader();
                        }
                    }
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class);
        }
    };
    final Map<Bundle, Set<GatewayClassLoader>> classloaders = Collections.synchronizedMap(new HashMap());
    private final CompositeResourceProvider resourceProviders = new CompositeResourceProvider();
    private final Map<String, WeakReference<Bundle>> rememberedBundles = new ConcurrentHashMap<String, WeakReference<Bundle>>();
    private final ReferenceQueue<Bundle> collectedBundles = new ReferenceQueue();
    private final ConcurrentServiceReferenceSet<ClassGenerator> generatorRefs = new ConcurrentServiceReferenceSet("generators");
    private final ClassGeneratorManager generatorManager = new ClassGeneratorManager(this.generatorRefs);
    private Map<String, ProtectionDomain> protectionDomainMap = null;
    protected MetaDataIdentifierService metadataIdentifierService;
    static final long serialVersionUID = -6576157393173485176L;

    @Activate
    protected void activate(ComponentContext cCtx, Map<String, Object> properties) {
        this.generatorRefs.activate(cCtx);
        this.bundleContext = cCtx.getBundleContext();
        this.aclStore = new CanonicalStore();
        this.tcclStore = new CanonicalStore();
        Bundle systemBundle = this.bundleContext.getBundle("System Bundle");
        BundleContext systemContext = systemBundle.getBundleContext();
        systemContext.addBundleListener(this.listener);
    }

    @Deactivate
    protected void deactivate(ComponentContext cCtx) {
        this.generatorRefs.deactivate(cCtx);
        Bundle systemBundle = this.bundleContext.getBundle("System Bundle");
        BundleContext systemContext = systemBundle.getBundleContext();
        systemContext.removeBundleListener(this.listener);
        this.bundleContext = null;
        this.cleanupRememberedBundles();
        this.aclStore = null;
        this.resourceProviders.clear();
    }

    @org.osgi.service.component.annotations.Reference(name="generators", service=ClassGenerator.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addGenerator(ServiceReference<ClassGenerator> ref) {
        this.generatorRefs.addReference(ref);
    }

    protected void removeGenerator(ServiceReference<ClassGenerator> ref) {
        this.generatorRefs.removeReference(ref);
    }

    @org.osgi.service.component.annotations.Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addResourceProvider(ResourceProvider rp) {
        this.resourceProviders.add(rp);
    }

    protected void removeResourceProvider(ResourceProvider rp) {
        this.resourceProviders.remove(rp);
    }

    @org.osgi.service.component.annotations.Reference
    protected void setRegionDigraph(RegionDigraph digraph) {
        this.digraph = digraph;
    }

    protected void unsetRegionDigraph(RegionDigraph digraph) {
    }

    @org.osgi.service.component.annotations.Reference(cardinality=ReferenceCardinality.OPTIONAL)
    protected void setInstrumentation(Instrumentation inst) {
        this.redefiner = new ClassRedefiner(inst);
    }

    protected void unsetInstrumentation(Instrumentation inst) {
        this.redefiner = null;
    }

    @org.osgi.service.component.annotations.Reference(service=MetaDataIdentifierService.class, name="metadataIdentifierService")
    protected void setMetadataIdentifierService(MetaDataIdentifierService svc) {
        this.metadataIdentifierService = svc;
    }

    protected void unsetMetadataIdentifierService(MetaDataIdentifierService svc) {
        this.metadataIdentifierService = null;
    }

    @org.osgi.service.component.annotations.Reference(service=URLStreamHandlerService.class, target="(url.handler.protocol=wsjar)")
    protected void setURLStreamHandlerService(URLStreamHandlerService svc) {
    }

    protected void unsetURLStreamHandlerService(URLStreamHandlerService svc) {
    }

    @Override
    public AppClassLoader createTopLevelClassLoader(List<Container> classPath, GatewayConfiguration gwConfig, ClassLoaderConfiguration clConfig) {
        AppClassLoader result = new ClassLoaderFactory(this.bundleContext, this.digraph, this.classloaders, this.aclStore, this.resourceProviders, this.redefiner, this.generatorManager).setClassPath(classPath).configure(gwConfig).configure(clConfig).create();
        this.rememberBundle(result.getBundle());
        return result;
    }

    @Override
    public AppClassLoader createBundleAddOnClassLoader(List<File> classPath, ClassLoader gwClassLoader, ClassLoaderConfiguration clConfig) {
        return new ClassLoaderFactory(this.bundleContext, this.digraph, this.classloaders, this.aclStore, this.resourceProviders, this.redefiner, this.generatorManager).setSharedLibPath(classPath).configure(this.createGatewayConfiguration()).useBundleAddOnLoader(gwClassLoader).configure(clConfig).create();
    }

    @Override
    public AppClassLoader createChildClassLoader(List<Container> classPath, ClassLoaderConfiguration config) {
        return new ClassLoaderFactory(this.bundleContext, this.digraph, this.classloaders, this.aclStore, this.resourceProviders, this.redefiner, this.generatorManager).setClassPath(classPath).configure(config).create();
    }

    @Override
    public GatewayConfigurationImpl createGatewayConfiguration() {
        return new GatewayConfigurationImpl();
    }

    @Override
    public ClassLoaderConfigurationImpl createClassLoaderConfiguration() {
        return new ClassLoaderConfigurationImpl();
    }

    @Override
    public ClassLoaderIdentityImpl createIdentity(String domain, String id) {
        return new ClassLoaderIdentityImpl(domain, id);
    }

    @Override
    @FFDCIgnore(value={ClassCastException.class})
    public ShadowClassLoader getShadowClassLoader(ClassLoader loader) {
        try {
            return new ShadowClassLoader((AppClassLoader)loader);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Override
    public boolean registerTransformer(ClassTransformer transformer, ClassLoader loader) {
        try {
            return ((AppClassLoader)loader).addTransformer(new ClassFileTransformerAdapter(transformer));
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.classloading.internal.ClassLoadingServiceImpl", (String)"297", (Object)this, (Object[])new Object[]{transformer, loader});
            return false;
        }
    }

    @Override
    public boolean unregisterTransformer(ClassTransformer transformer, ClassLoader loader) {
        try {
            return ((AppClassLoader)loader).removeTransformer(new ClassFileTransformerAdapter(transformer));
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.classloading.internal.ClassLoadingServiceImpl", (String)"306", (Object)this, (Object[])new Object[]{transformer, loader});
            return false;
        }
    }

    @Override
    public UnifiedClassLoader unify(ClassLoader parent, ClassLoader ... followOns) {
        return new UnifiedClassLoader(parent, followOns);
    }

    @Override
    public AppClassLoader getSharedLibraryClassLoader(Library lib) {
        ClassLoaderIdentityImpl clId = this.createIdentity("Shared Library", lib.id());
        AppClassLoader loader = this.aclStore.retrieve(clId);
        if (loader != null) {
            return loader;
        }
        EnumSet<ApiType> apiTypeVisibility = lib.getApiTypeVisibility();
        ClassLoaderConfiguration clsCfg = this.createClassLoaderConfiguration().setId(clId).setSharedLibraries(lib.id());
        Collection<Fileset> filesets = lib.getFilesets();
        if (filesets != null && !filesets.isEmpty()) {
            for (Fileset fileset : filesets) {
                this.setProtectionDomain(fileset.getFileset(), clsCfg);
            }
        } else {
            Collection<File> files = lib.getFiles();
            if (files != null && !files.isEmpty()) {
                this.setProtectionDomain(files, clsCfg);
            }
        }
        AppClassLoader result = new ClassLoaderFactory(this.bundleContext, this.digraph, this.classloaders, this.aclStore, this.resourceProviders, this.redefiner, this.generatorManager).configure(this.createGatewayConfiguration().setApplicationName("Shared Library: " + lib.id()).setDynamicImportPackage("*").setApiTypeVisibility(apiTypeVisibility)).configure(clsCfg).onCreate(this.listenForLibraryChanges(lib.id())).getCanonical();
        this.rememberBundle(result.getBundle());
        return result;
    }

    private void setProtectionDomain(Collection<File> files, ClassLoaderConfiguration clsCfg) {
        for (File file : files) {
            String path = file.getPath();
            path = path.replace("\\", "/");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("path: " + path), (Object[])new Object[0]);
            }
            String matchingDomainKey = this.getProtectionDomainMapKey(path);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("matchingDomainKey: " + matchingDomainKey), (Object[])new Object[0]);
            }
            if (matchingDomainKey == null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Setting the protection domain", (Object[])new Object[0]);
            }
            clsCfg.setProtectionDomain(this.protectionDomainMap.get(matchingDomainKey));
            break;
        }
    }

    public Map<String, ProtectionDomain> getProtectionDomainMap() {
        return this.protectionDomainMap;
    }

    public String getProtectionDomainMapKey(String path) {
        if (this.protectionDomainMap == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"protectionDomainMap is null", (Object[])new Object[0]);
            }
            return null;
        }
        if (this.protectionDomainMap.containsKey(path)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("protectionDomainMap is not null, returning path: " + path), (Object[])new Object[0]);
            }
            return path;
        }
        for (String codebase : this.protectionDomainMap.keySet()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("codebase = " + codebase), (Object[])new Object[0]);
            }
            if (codebase.endsWith("-")) {
                if (!path.startsWith(codebase.substring(0, codebase.indexOf(45)))) continue;
                return codebase;
            }
            if (!codebase.endsWith("*")) continue;
            String temp = codebase.substring(0, codebase.indexOf(42) - 1);
            File jarFile = new File(path);
            String pathParent = jarFile.getParent().replace("\\", "/");
            if (pathParent == null || !pathParent.equalsIgnoreCase(temp)) continue;
            return codebase;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"nothing matched in the protectionDomainMap, returning null", (Object[])new Object[0]);
        }
        return null;
    }

    private ClassLoaderFactory.PostCreateAction listenForLibraryChanges(final String libid) {
        return new ClassLoaderFactory.PostCreateAction(){
            static final long serialVersionUID = -65768333330841311L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void invoke(AppClassLoader acl) {
                ClassLoadingServiceImpl.this.listenForLibraryChanges(libid, acl);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        };
    }

    private void listenForLibraryChanges(String libid, AppClassLoader acl) {
        new WeakLibraryListener(libid, acl.getKey().getId(), acl, this.bundleContext){
            static final long serialVersionUID = 4175496090837118711L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            protected void update() {
                Object cl = this.get();
                if (cl instanceof AppClassLoader) {
                    ClassLoadingServiceImpl.this.aclStore.remove((AppClassLoader)cl);
                }
                this.deregister();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(3.class);
            }
        };
    }

    @Override
    @FFDCIgnore(value={InterruptedException.class})
    public ThreadContextClassLoader createThreadContextClassLoader(final ClassLoader applicationClassLoader) {
        ThreadContextClassLoader result;
        block15: {
            String key;
            String methodName = "createThreadContextClassLoader(): ";
            if (applicationClassLoader == null) {
                throw new IllegalArgumentException("ClassLoader argument is null");
            }
            if (applicationClassLoader instanceof AppClassLoader) {
                key = ((AppClassLoader)applicationClassLoader).getKey().toString();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("createThreadContextClassLoader(): Instance of LibertyClassLoader, key = " + key), (Object[])new Object[0]);
                }
            } else if (applicationClassLoader instanceof BundleReference) {
                key = Long.toString(((BundleReference)applicationClassLoader).getBundle().getBundleId());
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("createThreadContextClassLoader(): Instance of BundleReference, key = " + key), (Object[])new Object[0]);
                }
            } else {
                throw new IllegalArgumentException(applicationClassLoader.toString() + " + is an unexpected ClassLoader type");
            }
            try {
                if (this.tcclStoreLock.tryLock(TCCL_LOCK_WAIT, TimeUnit.MILLISECONDS)) {
                    do {
                        if ((result = this.tcclStore.retrieveOrCreate(key, new Factory<ThreadContextClassLoader>(){
                            static final long serialVersionUID = -8724024091149290930L;
                            private static final /* synthetic */ TraceComponent $$$tc$$$;

                            @Override
                            public ThreadContextClassLoader createInstance() {
                                return ClassLoadingServiceImpl.this.createTCCL(applicationClassLoader, key);
                            }

                            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                            static {
                                $$$tc$$$ = Tr.register(4.class);
                            }
                        })).isFor(applicationClassLoader)) continue;
                        this.tcclStore.remove(result);
                        result = null;
                    } while (result == null);
                    result.incrementRefCount();
                    break block15;
                }
                throw new IllegalStateException("Unable to acquire TCCL store lock");
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Thread interrupted while acquiring TCCL store lock");
            }
            finally {
                if (this.tcclStoreLock.isHeldByCurrentThread()) {
                    this.tcclStoreLock.unlock();
                }
            }
        }
        return result;
    }

    private ThreadContextClassLoader createTCCL(ClassLoader cl, String key) {
        GatewayConfiguration gwConfig = this.createGatewayConfiguration().setApplicationName("ThreadContextClassLoader").setDynamicImportPackage("*;thread-context=\"true\"").setDelegateToSystem(false);
        ClassLoaderConfiguration clConfig = this.createClassLoaderConfiguration().setId(this.createIdentity("Thread Context", key));
        GatewayBundleFactory gatewayBundleFactory = new GatewayBundleFactory(this.bundleContext, this.digraph, this.classloaders);
        GatewayClassLoader aug = gatewayBundleFactory.createGatewayBundleClassLoader(gwConfig, clConfig, this.resourceProviders);
        ThreadContextClassLoader tccl = cl instanceof BundleReference ? new ThreadContextClassLoaderForBundles(aug, cl, key) : new ThreadContextClassLoader(aug, cl, key);
        return tccl;
    }

    private void cleanupRememberedBundles() {
        String methodName = "cleanupRememberedBundles(): ";
        for (WeakReference<Bundle> r : this.rememberedBundles.values()) {
            Bundle b = (Bundle)r.get();
            if (b == null) continue;
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("cleanupRememberedBundles(): Uninstalling bundle location: " + b.getLocation() + ", bundle id: " + b.getBundleId()), (Object[])new Object[0]);
                }
                b.uninstall();
            }
            catch (BundleException bundleException) {
                FFDCFilter.processException((Throwable)bundleException, (String)"com.ibm.ws.classloading.internal.ClassLoadingServiceImpl", (String)"535", (Object)this, (Object[])new Object[0]);
            }
            catch (IllegalStateException illegalStateException) {
                FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.ws.classloading.internal.ClassLoadingServiceImpl", (String)"536", (Object)this, (Object[])new Object[0]);
            }
        }
    }

    private void forgetStaleBundles() {
        Reference<Bundle> o = this.collectedBundles.poll();
        while (o != null) {
            this.rememberedBundles.values().remove(o);
            o = this.collectedBundles.poll();
        }
    }

    private void rememberBundle(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        this.forgetStaleBundles();
        WeakReference<Bundle> oldRef = this.rememberedBundles.get(bundle.getLocation());
        if (oldRef != null && oldRef.get() == bundle) {
            return;
        }
        WeakReference<Bundle> ref = new WeakReference<Bundle>(bundle, this.collectedBundles);
        oldRef = this.rememberedBundles.put(bundle.getLocation(), ref);
        if (oldRef != null) {
            oldRef.clear();
        }
    }

    @Override
    public void destroyThreadContextClassLoader(ClassLoader loader) {
        if (loader instanceof ThreadContextClassLoader) {
            this.tcclStoreLock.lock();
            try {
                ThreadContextClassLoader tccl = (ThreadContextClassLoader)loader;
                if (tccl.decrementRefCount() <= 0) {
                    this.tcclStore.remove(tccl);
                }
            }
            finally {
                this.tcclStoreLock.unlock();
            }
        }
    }

    @Override
    public String getClassLoaderIdentifier(ClassLoader classloader) throws IllegalArgumentException {
        if (classloader instanceof ThreadContextClassLoader && !(classloader instanceof ThreadContextClassLoaderForBundles)) {
            return ((ThreadContextClassLoader)classloader).getKey();
        }
        return null;
    }

    @Override
    public ClassLoader getClassLoader(String identifier) throws IllegalArgumentException {
        if (identifier == null) {
            return null;
        }
        ThreadContextClassLoader classloader = this.tcclStore.retrieve(identifier);
        if (classloader != null) {
            return classloader;
        }
        return null;
    }

    @Override
    public String getClassLoaderIdentifier(String type, String appName, String moduleName, String componentName) {
        String metadataId = this.metadataIdentifierService.getMetaDataIdentifier(type, appName, moduleName, componentName);
        MetaData metadata = this.metadataIdentifierService.getMetaData(metadataId);
        ClassLoader classLoader = this.metadataIdentifierService.getClassLoader(type, (ComponentMetaData)metadata);
        return this.getClassLoaderIdentifier(classLoader);
    }

    @Override
    public boolean isAppClassLoader(ClassLoader cl) {
        return cl instanceof AppClassLoader;
    }

    @Override
    public boolean isThreadContextClassLoader(ClassLoader cl) {
        return cl instanceof ThreadContextClassLoader;
    }

    @Override
    public void setSharedLibraryProtectionDomains(Map<String, ProtectionDomain> protectionDomainMap) {
        this.protectionDomainMap = protectionDomainMap;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static class ClassFileTransformerAdapter
    implements ClassFileTransformer {
        private final ClassTransformer transformer;
        static final long serialVersionUID = 1036452955082884629L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ClassFileTransformerAdapter(ClassTransformer transformer) {
            this.transformer = transformer;
        }

        @Override
        public byte[] transform(ClassLoader loader, String name, Class<?> classBeingRedefined, ProtectionDomain pd, byte[] bytes) throws IllegalClassFormatException {
            return this.transformer.transformClass(name, bytes, pd == null ? null : pd.getCodeSource(), loader);
        }

        public boolean equals(Object o) {
            return o instanceof ClassFileTransformerAdapter && ((ClassFileTransformerAdapter)o).transformer.equals(this.transformer);
        }

        public int hashCode() {
            return this.transformer.hashCode();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ClassFileTransformerAdapter.class);
        }
    }
}

