/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.metadata;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.jaxws.metadata.JaxWsClientMetaData;
import com.ibm.ws.jaxws.metadata.JaxWsServerMetaData;
import com.ibm.ws.jaxws.support.JaxWsInstanceManager;
import com.ibm.ws.jaxws.utils.JaxWsUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.injectionengine.ReferenceContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JaxWsModuleMetaData {
    private volatile JaxWsServerMetaData serverMetaData;
    private volatile JaxWsClientMetaData clientMetaData;
    private String name;
    private final ClassLoader appContextClassLoader;
    private final J2EEName j2EEName;
    private final Container moduleContainer;
    private final ModuleInfo moduleInfo;
    private final Map<Class<?>, ReferenceContext> referenceContextMap;
    private final JaxWsInstanceManager jaxWsInstanceManager;
    private final List<ModuleMetaData> enclosingModuleMetaDatas = new ArrayList<ModuleMetaData>(2);
    private final Map<String, String> appNameURLMap = new HashMap<String, String>();
    private String contextRoot;
    static final long serialVersionUID = -386873239150159063L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public JaxWsModuleMetaData(ModuleMetaData moduleMetaData, Container moduleContainer, ClassLoader appContextClassLoader) {
        this.moduleContainer = moduleContainer;
        this.enclosingModuleMetaDatas.add(moduleMetaData);
        this.j2EEName = moduleMetaData.getJ2EEName();
        this.moduleInfo = JaxWsUtils.getModuleInfo(moduleContainer);
        this.jaxWsInstanceManager = new JaxWsInstanceManager(this.moduleInfo.getClassLoader(), new JaxWsInstanceManager.InstanceInterceptor[0]);
        this.appContextClassLoader = appContextClassLoader;
        this.referenceContextMap = new HashMap();
    }

    public Map<Class<?>, ReferenceContext> getReferenceContextMap() {
        return this.referenceContextMap;
    }

    public ReferenceContext getReferenceContext(Class<?> clazz) {
        return this.referenceContextMap.get(clazz);
    }

    public void setReferenceContext(Class<?> clazz, ReferenceContext referenceContext) {
        this.referenceContextMap.put(clazz, referenceContext);
    }

    public ModuleInfo getModuleInfo() {
        return this.moduleInfo;
    }

    public JaxWsInstanceManager getJaxWsInstanceManager() {
        return this.jaxWsInstanceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JaxWsServerMetaData getServerMetaData() {
        if (this.serverMetaData == null) {
            JaxWsModuleMetaData jaxWsModuleMetaData = this;
            synchronized (jaxWsModuleMetaData) {
                if (this.serverMetaData == null) {
                    this.serverMetaData = new JaxWsServerMetaData(this);
                }
            }
        }
        return this.serverMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JaxWsClientMetaData getClientMetaData() {
        if (this.clientMetaData == null) {
            JaxWsModuleMetaData jaxWsModuleMetaData = this;
            synchronized (jaxWsModuleMetaData) {
                if (this.clientMetaData == null) {
                    this.clientMetaData = new JaxWsClientMetaData(this);
                }
            }
        }
        return this.clientMetaData;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ClassLoader getAppContextClassLoader() {
        return this.appContextClassLoader;
    }

    public J2EEName getJ2EEName() {
        return this.j2EEName;
    }

    public Container getModuleContainer() {
        return this.moduleContainer;
    }

    public List<ModuleMetaData> getEnclosingModuleMetaDatas() {
        return this.enclosingModuleMetaDatas;
    }

    public Map<String, String> getAppNameURLMap() {
        return this.appNameURLMap;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
    }

    public void destroy() {
        if (this.serverMetaData != null) {
            this.serverMetaData.destroy();
        }
        if (this.clientMetaData != null) {
            this.clientMetaData.destroy();
        }
        if (!this.appNameURLMap.isEmpty()) {
            this.appNameURLMap.clear();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(JaxWsModuleMetaData.class);
    }
}

