/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.registry.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.wim.ras.WIMMessageHelper;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.registry.EntryNotFoundException;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.wim.registry.dataobject.IDAndRealm;
import com.ibm.ws.security.wim.registry.util.BridgeUtils;
import com.ibm.ws.security.wim.registry.util.TypeMappings;
import com.ibm.wsspi.security.wim.exception.EntityNotFoundException;
import com.ibm.wsspi.security.wim.exception.InvalidIdentifierException;
import com.ibm.wsspi.security.wim.exception.WIMException;
import com.ibm.wsspi.security.wim.model.Context;
import com.ibm.wsspi.security.wim.model.Group;
import com.ibm.wsspi.security.wim.model.PersonAccount;
import com.ibm.wsspi.security.wim.model.Root;
import com.ibm.wsspi.security.wim.model.SearchControl;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class DisplayNameBridge {
    private static final TraceComponent tc = Tr.register(DisplayNameBridge.class);
    private TypeMappings propertyMap = null;
    private BridgeUtils mappingUtils = null;
    static final long serialVersionUID = 869303381677205174L;

    public DisplayNameBridge(BridgeUtils mappingUtil) {
        this.mappingUtils = mappingUtil;
        this.propertyMap = new TypeMappings(mappingUtil);
    }

    @FFDCIgnore(value={WIMException.class})
    public String getUserDisplayName(String inputUserSecurityName) throws EntryNotFoundException, RegistryException {
        String returnValue = "";
        try {
            String mappedProp;
            Root resultRoot;
            Context context;
            boolean allowDNAsPrincipalName;
            String inputAttrName;
            String id;
            String quote;
            Root root;
            IDAndRealm idAndRealm;
            block19: {
                List contexts;
                this.mappingUtils.validateId(inputUserSecurityName);
                idAndRealm = this.mappingUtils.separateIDAndRealm(inputUserSecurityName);
                root = this.mappingUtils.getWimService().createRootObject();
                if (idAndRealm.isRealmDefined()) {
                    this.mappingUtils.createRealmDataObject(root, idAndRealm.getRealm());
                }
                quote = "'";
                id = idAndRealm.getId();
                if (id.indexOf("'") != -1) {
                    quote = "\"";
                }
                inputAttrName = this.propertyMap.getInputUniqueUserId(idAndRealm.getRealm());
                inputAttrName = this.mappingUtils.getRealInputAttrName(inputAttrName, id, true);
                String outputAttrName = this.propertyMap.getOutputUserDisplayName(idAndRealm.getRealm());
                allowDNAsPrincipalName = this.mappingUtils.allowDNAsPrincipalName;
                if (allowDNAsPrincipalName && (contexts = root.getContexts()) != null) {
                    Context ctx = new Context();
                    ctx.setKey("allowDNPrincipalNameAsLiteral");
                    ctx.setValue((Object)allowDNAsPrincipalName);
                    contexts.add(ctx);
                }
                context = new Context();
                context.setKey("isURBridgeResult");
                context.setValue((Object)"false");
                root.getContexts().add(context);
                resultRoot = null;
                try {
                    if (outputAttrName != null && outputAttrName.equalsIgnoreCase("principalName")) {
                        outputAttrName = "displayBridgePrincipalName";
                    }
                    resultRoot = this.mappingUtils.getEntityByIdentifier(root, inputAttrName, id, outputAttrName, this.mappingUtils);
                }
                catch (WIMException e) {
                    if (allowDNAsPrincipalName) break block19;
                    throw e;
                }
            }
            boolean foundInURBridge = false;
            if (resultRoot != null && !resultRoot.getEntities().isEmpty()) {
                List contexts = resultRoot.getContexts();
                for (Context ctx : contexts) {
                    String key = ctx.getKey();
                    if (key == null || !"isURBridgeResult".equals(key) || !"true".equalsIgnoreCase((String)ctx.getValue())) continue;
                    foundInURBridge = true;
                }
            }
            root.getContexts().clear();
            if (resultRoot != null && !resultRoot.getEntities().isEmpty() && (DisplayNameBridge.isDN(id) || foundInURBridge)) {
                root = resultRoot;
            } else {
                List controls = root.getControls();
                SearchControl srchCtrl = new SearchControl();
                if (controls != null) {
                    controls.add(srchCtrl);
                }
                if (!this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getOutputUserDisplayName(idAndRealm.getRealm()))) {
                    srchCtrl.getProperties().add(this.propertyMap.getOutputUserDisplayName(idAndRealm.getRealm()));
                }
                if (allowDNAsPrincipalName) {
                    inputAttrName = "principalName";
                }
                srchCtrl.setExpression("//entities[@xsi:type='LoginAccount' and " + inputAttrName + "=" + quote + id + quote + "]");
                context = new Context();
                context.set("key", (Object)"useUserFilterForSearch");
                context.set("value", (Object)id);
                root.getContexts().add(context);
                root = this.mappingUtils.getWimService().search(root);
            }
            List returnList = root.getEntities();
            if (returnList.isEmpty()) {
                throw new EntityNotFoundException("ENTITY_NOT_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)inputUserSecurityName)));
            }
            if (returnList.size() != 1) {
                throw new EntityNotFoundException("MULTIPLE_PRINCIPALS_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"MULTIPLE_PRINCIPALS_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)inputUserSecurityName)));
            }
            PersonAccount loginAccount = (PersonAccount)returnList.get(0);
            returnValue = !this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getOutputUserDisplayName(idAndRealm.getRealm())) ? ((mappedProp = this.propertyMap.getOutputUserDisplayName(idAndRealm.getRealm())).equals("displayName") ? (loginAccount.getDisplayName().size() == 0 ? "" : (String)loginAccount.getDisplayName().get(0)) : (mappedProp.equals("principalName") && foundInURBridge ? (!this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getOutputUserPrincipal(idAndRealm.getRealm())) ? (String)loginAccount.get(this.propertyMap.getOutputUserPrincipal(idAndRealm.getRealm())) : (String)loginAccount.getIdentifier().get(this.propertyMap.getOutputUserPrincipal(idAndRealm.getRealm()))) : (String)loginAccount.get(mappedProp))) : (String)loginAccount.getIdentifier().get(this.propertyMap.getOutputUserDisplayName(idAndRealm.getRealm()));
        }
        catch (WIMException toCatch) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)toCatch.getMessage(), (Object[])new Object[]{toCatch});
            }
            if (toCatch instanceof EntityNotFoundException || toCatch instanceof InvalidIdentifierException) {
                throw new EntryNotFoundException(toCatch.getMessage(), (Throwable)toCatch);
            }
            throw new RegistryException(toCatch.getMessage(), (Throwable)toCatch);
        }
        return returnValue;
    }

    @FFDCIgnore(value={WIMException.class})
    public String getGroupDisplayName(String inputGroupSecurityName) throws EntryNotFoundException, RegistryException {
        String returnValue = "";
        try {
            Object value;
            Root resultRoot;
            this.mappingUtils.validateId(inputGroupSecurityName);
            IDAndRealm idAndRealm = this.mappingUtils.separateIDAndRealm(inputGroupSecurityName);
            Root root = this.mappingUtils.getWimService().createRootObject();
            if (idAndRealm.isRealmDefined()) {
                this.mappingUtils.createRealmDataObject(root, idAndRealm.getRealm());
            }
            String quote = "'";
            String id = idAndRealm.getId();
            if (id.indexOf("'") != -1) {
                quote = "\"";
            }
            String inputAttrName = this.propertyMap.getInputGroupSecurityName(idAndRealm.getRealm());
            inputAttrName = this.mappingUtils.getRealInputAttrName(inputAttrName, id, false);
            String outputAttrName = this.propertyMap.getOutputGroupDisplayName(idAndRealm.getRealm());
            if (outputAttrName != null && outputAttrName.equalsIgnoreCase("cn")) {
                outputAttrName = "displayBridgeCN";
            }
            if ((resultRoot = this.mappingUtils.getEntityByIdentifier(root, inputAttrName, id, outputAttrName, this.mappingUtils)) != null) {
                root = resultRoot;
            } else {
                List controls = root.getControls();
                SearchControl searchControl = new SearchControl();
                if (controls != null) {
                    controls.add(searchControl);
                }
                if (!this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getOutputGroupDisplayName(idAndRealm.getRealm()))) {
                    searchControl.getProperties().add(this.propertyMap.getOutputGroupDisplayName(idAndRealm.getRealm()));
                }
                searchControl.setExpression("//entities[@xsi:type='Group' and " + inputAttrName + "=" + quote + id + quote + "]");
                Context context = new Context();
                context.set("key", (Object)"useGroupFilterForSearch");
                context.set("value", (Object)id);
                root.getContexts().add(context);
                root = this.mappingUtils.getWimService().search(root);
            }
            List returnList = root.getEntities();
            if (returnList.isEmpty()) {
                throw new EntityNotFoundException("ENTITY_NOT_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)inputGroupSecurityName)));
            }
            if (returnList.size() != 1) {
                throw new EntityNotFoundException("MULTIPLE_PRINCIPALS_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"MULTIPLE_PRINCIPALS_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)inputGroupSecurityName)));
            }
            Group group = (Group)returnList.get(0);
            returnValue = !this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getOutputGroupDisplayName(idAndRealm.getRealm())) ? ((value = group.get(this.propertyMap.getOutputGroupDisplayName(idAndRealm.getRealm()))) instanceof String ? (String)value : String.valueOf(((List)value).get(0))) : (String)group.getIdentifier().get(this.propertyMap.getOutputGroupDisplayName(idAndRealm.getRealm()));
        }
        catch (WIMException toCatch) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)toCatch.getMessage(), (Object[])new Object[]{toCatch});
            }
            if (toCatch instanceof EntityNotFoundException || toCatch instanceof InvalidIdentifierException) {
                throw new EntryNotFoundException(toCatch.getMessage(), (Throwable)toCatch);
            }
            throw new RegistryException(toCatch.getMessage(), (Throwable)toCatch);
        }
        return returnValue;
    }

    @FFDCIgnore(value={InvalidNameException.class})
    public static boolean isDN(String uniqueName) {
        if (uniqueName == null) {
            return false;
        }
        try {
            new LdapName(uniqueName);
            return true;
        }
        catch (InvalidNameException e) {
            return false;
        }
    }
}

