/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.utility.tasks;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.collective.utility.IMaintenanceModeMBeanConnection;
import com.ibm.ws.collective.utility.TaskErrorException;
import com.ibm.ws.collective.utility.tasks.BaseCommandTask;
import com.ibm.ws.collective.utility.utils.ConsoleWrapper;
import com.ibm.ws.collective.utils.RepositoryPathUtility;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;

public class SetMaintenanceTask
extends BaseCommandTask {
    private static final TraceComponent tc = Tr.register(SetMaintenanceTask.class);
    private static final String ARG_BREAK = "--break";
    private static final String ARG_FORCE = "--force";
    private static final String ARG_SERVER = "--server";
    private static final String ARG_USR_DIR = "--usrDir";
    private static final String ARG_HOSTNAME = "--hostName";
    private final IMaintenanceModeMBeanConnection maintenanceMode;

    public SetMaintenanceTask(String scriptName, IMaintenanceModeMBeanConnection mbeanconn) {
        super(tc, scriptName, null);
        this.maintenanceMode = mbeanconn;
        this.reqArgs.add("--host");
        this.reqArgs.add("--port");
        this.reqArgs.add("--user");
        this.reqArgs.add("--password");
        this.reqArgs.add(ARG_HOSTNAME);
        this.promptableArgs.add("--password");
        this.flagArgs.add(ARG_BREAK);
        this.flagArgs.add(ARG_FORCE);
        this.knownArgs.addAll(this.reqArgs);
        this.knownArgs.addAll(this.flagArgs);
        this.knownArgs.addAll(this.promptableArgs);
        this.knownArgs.add(ARG_USR_DIR);
        this.knownArgs.add(ARG_SERVER);
        this.addAutoAcceptArgument();
    }

    @Override
    public String getTaskName() {
        return "enterMaintenanceMode";
    }

    @Override
    public String getTaskUsage() {
        return this.getTaskUsage("enterMaintenanceMode.usage.options");
    }

    @Override
    public String getTaskHelp() {
        String footer = this.buildScriptOptions("enterMaintenance.option-key.", "enterMaintenance.option-desc.") + this.buildScriptOptions("certProps.option-key.autoAccept", "certProps.option-desc.autoAccept") + NL + NL + this.getOption("sslTrust.autoAccept", "com.ibm.websphere.collective.utility.autoAcceptCertificates");
        return this.getTaskHelp("enterMaintenanceMode.desc", "enterMaintenanceMode.usage.options", "connection.option-key", "connection.option-desc", null, footer, this.scriptName);
    }

    @Override
    public String getTaskDescription() {
        return this.getOption("enterMaintenanceMode.desc", new Object[0]);
    }

    @Override
    public void handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) throws TaskErrorException {
        String MAGICAL_SENTINEL = "@!$#%$#%32543265k425k4/3nj5k43n?m2|5k4\\n5k2345";
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Validating command arguments...", (Object[])new Object[0]);
        }
        this.validateArgumentList(args, false, false);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Parsing command arguments...", (Object[])new Object[0]);
        }
        String controllerHost = this.getArgumentValue("--host", args, null);
        int port = Integer.parseInt(this.getArgumentValue("--port", args, null));
        String user = this.getArgumentValue("--user", args, null);
        String pwd = this.getArgumentValue("--password", args, null);
        String hostName = this.getArgumentValue(ARG_HOSTNAME, args, null);
        String serverName = this.getArgumentValue(ARG_SERVER, args, null);
        String usrDir = this.getArgumentValue(ARG_USR_DIR, args, null);
        boolean force = this.getArgumentValue(ARG_FORCE, args, "@!$#%$#%32543265k425k4/3nj5k43n?m2|5k4\\n5k2345") != "@!$#%$#%32543265k425k4/3nj5k43n?m2|5k4\\n5k2345";
        boolean breakAffinity = this.getArgumentValue(ARG_BREAK, args, "@!$#%$#%32543265k425k4/3nj5k43n?m2|5k4\\n5k2345") != "@!$#%$#%32543265k425k4/3nj5k43n?m2|5k4\\n5k2345";
        this.handleAutoAcceptArgument(args);
        if (serverName != null && usrDir == null || usrDir != null && serverName == null) {
            String missingArg;
            String string = missingArg = usrDir == null ? ARG_USR_DIR : ARG_SERVER;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unable to set maintenance mode for server on host: " + hostName + " due to missing arg: " + missingArg), (Object[])new Object[0]);
            }
            this.abort(this.getMessage("missingArg", missingArg));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("controllerHost: " + controllerHost), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("controllerPort: " + port), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("username: " + user), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("password: " + pwd.replaceAll(".", "*")), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("targetHost: " + hostName), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("server: " + serverName), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("usrDir: " + usrDir), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("force: " + force), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("breakAffinity: " + breakAffinity), (Object[])new Object[0]);
        }
        this.setMaintenanceMode(controllerHost, port, user, pwd, hostName, usrDir, serverName, force, !breakAffinity);
    }

    private void setMaintenanceMode(String host, int port, String user, String pwd, String hostName, String usrDir, String serverName, boolean force, boolean affinity) throws TaskErrorException {
        String target;
        if (serverName == null) {
            target = hostName;
        } else {
            usrDir = RepositoryPathUtility.normalizePath((String)usrDir);
            target = RepositoryPathUtility.buildServerTuple((String)hostName, (String)usrDir, (String)serverName);
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Setting maintenance mode on target: " + target), (Object[])new Object[0]);
            }
            ArrayList<String> targets = new ArrayList<String>(1);
            targets.add(target);
            List<Map<String, String>> results = serverName == null ? this.maintenanceMode.enterHostMaintenanceMode(host, port, user, pwd, targets, affinity, force) : this.maintenanceMode.enterServerMaintenanceMode(host, port, user, pwd, targets, affinity, force);
            Map<String, String> result = results.get(0);
            if (serverName == null) {
                this.processResult(hostName, result.get(hostName));
            }
            for (Map.Entry<String, String> entry : result.entrySet()) {
                String key = entry.getKey();
                if (key.equals(hostName)) continue;
                int lastTupleComponent = Math.max(0, key.lastIndexOf(44));
                String name = key.substring(lastTupleComponent + 1);
                this.processResult(name, entry.getValue());
            }
        }
        catch (UnknownHostException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("UnknownHostException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.abort(this.getMessage("common.hostError", host));
        }
        catch (RuntimeMBeanException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Unexpected RuntimeMBeanException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("common.connectionError", e.getMessage()));
        }
        catch (ConnectException e) {
            if (e.getMessage() != null && e.getMessage().contains(this.maintenanceMode.getMaintModeConnectExceptionMsg())) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Caught ConnectException, this happens if there was a problemconnecting to the target machine: " + target), (Object[])new Object[]{e});
                }
                this.abort(this.getMessage("setMaintenanceMode.connectionError", hostName));
            } else {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("ConnectException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
                }
                this.abort(this.getMessage("common.portError", String.valueOf(port)));
            }
        }
        catch (IOException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("IOException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.abort(this.getMessage("common.connectionError", e.getMessage()));
        }
        catch (KeyManagementException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Caught KeyManagementException, this happens if the keys cannot be trusted.", (Object[])new Object[]{e});
            }
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("setMaintenanceMode.error", target));
        }
        catch (InstanceNotFoundException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Caught InstanceNotFoundException, this happens if the MBean has not been registered.", (Object[])new Object[]{e});
            }
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("setMaintenanceMode.error", target));
        }
        catch (NoSuchAlgorithmException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Caught NoSuchAlgorithmException, this should only happen if a crypto algorithm is not implemented.", (Object[])new Object[]{e});
            }
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("setMaintenanceMode.error", target));
        }
        catch (ReflectionException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Caught ReflectionException, this happens if the method invocation signature does not match the bean declaration.", (Object[])new Object[]{e});
            }
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("setMaintenanceMode.error", target));
        }
        catch (MBeanException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Caught MBeanException, an unexpected declared exception occurred.", (Object[])new Object[]{e});
            }
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("setMaintenanceMode.error", target));
        }
    }

    private void processResult(String name, String status) throws TaskErrorException {
        if (status.equals("inMaintenanceMode")) {
            this.stdout.println(this.getMessage("setMaintenanceMode.success", name));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Successfully set maintenance mode for " + name), (Object[])new Object[0]);
            }
        } else if (status.equals("alternateServerStarting")) {
            this.stdout.println(this.getMessage("setMaintenanceMode.alt", name));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Alternate server is starting for " + name), (Object[])new Object[0]);
            }
        } else if (status.equals("alternateServerUnavailable")) {
            this.stderr.println(this.getMessage("setMaintenanceMode.noAltServer", name));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Alternate server is not available for " + name), (Object[])new Object[0]);
            }
        } else {
            this.stderr.println(this.getMessage("setMaintenanceMode.error", name));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Encountered an error while setting maintenance mode for " + name), (Object[])new Object[0]);
            }
        }
    }

    @Override
    protected void abort(String message) throws TaskErrorException {
        throw new TaskErrorException(message);
    }

    @Override
    protected void abortAndPerformCleanup(String message, File cleanupRoot) throws TaskErrorException {
        throw new TaskErrorException(message);
    }
}

