/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.utility.tasks;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.collective.member.internal.ssh.SSHKeyGenerator;
import com.ibm.ws.collective.member.internal.ssh.SSHKeyUtility;
import com.ibm.ws.collective.utility.ICollectiveRegistrationMBeanConnection;
import com.ibm.ws.collective.utility.IFileUtility;
import com.ibm.ws.collective.utility.TaskErrorException;
import com.ibm.ws.collective.utility.tasks.BaseCommandTask;
import com.ibm.ws.collective.utility.utils.ConsoleWrapper;
import com.ibm.ws.collective.utils.PasswordMaskUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.RuntimeMBeanException;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;

public class ReplicateTask
extends BaseCommandTask {
    private static final TraceComponent tc = Tr.register(ReplicateTask.class);
    private final SSHKeyGenerator sshKeyGen;
    private final SSHKeyUtility sshKeyUtil;
    private File collectiveResourcesDir;
    private final ICollectiveRegistrationMBeanConnection registrationMBean;
    private static final Integer DEFAULT_REPLICA_PORT = 10010;

    public ReplicateTask(String scriptName, IFileUtility fileUtility, SSHKeyGenerator sshKeyGen, SSHKeyUtility sshKeyUtil, ICollectiveRegistrationMBeanConnection registrationMBean) {
        super(tc, scriptName, fileUtility);
        this.sshKeyGen = sshKeyGen;
        this.sshKeyUtil = sshKeyUtil;
        this.registrationMBean = registrationMBean;
        this.reqArgs.add("--host");
        this.reqArgs.add("--port");
        this.reqArgs.add("--user");
        this.reqArgs.add("--password");
        this.reqArgs.add("--keystorePassword");
        this.promptableArgs.add("--password");
        this.confirmedArgs.add("--keystorePassword");
        this.confirmedArgs.add("--serverIdentityKeystorePassword");
        this.confirmedArgs.add("--collectiveTrustKeystorePassword");
        this.confirmedArgs.add("--httpsKeystorePassword");
        this.confirmedArgs.add("--httpsTruststorePassword");
        this.flagArgs.add("--createConfigFile");
        this.flagArgs.add("--useHostCredentials");
        this.knownArgs.addAll(this.reqArgs);
        this.knownArgs.addAll(this.promptableArgs);
        this.knownArgs.addAll(this.confirmedArgs);
        this.knownArgs.addAll(this.promptableArgs);
        this.knownArgs.addAll(this.flagArgs);
        this.knownArgs.add("--serverIdentityCertificateValidity");
        this.knownArgs.add("--httpsCertificateSubject");
        this.knownArgs.add("--httpsCertificateValidity");
        this.knownArgs.add("--hostName");
        this.knownArgs.add("--encoding");
        this.knownArgs.add("--key");
        this.addHostAuthInfoArgs(false);
        this.addAutoAcceptArgument();
    }

    @Override
    public String getTaskName() {
        return "replicate";
    }

    @Override
    public String getTaskUsage() {
        return this.getTaskUsage("replicate.usage.options");
    }

    @Override
    public String getTaskHelp() {
        String footer = this.buildScriptOptions("keystore.option-key.", "keystore.option-desc.") + this.buildScriptOptions("certProps.option-key.", "certProps.option-desc.") + this.buildScriptOptions("replicate.option-key.", "replicate.option-desc.") + this.buildScriptOptions("encoding.option-key.", "encoding.option-desc.") + this.buildScriptOptions("common.option-key.", "common.option-desc.") + this.buildScriptOptions("hostAuthInfo.option-key.", "hostAuthInfo.option-desc.") + NL + NL + this.getOption("sslTrust.autoAccept", "com.ibm.websphere.collective.utility.autoAcceptCertificates");
        return this.getTaskHelp("replicate.desc", "replicate.usage.options", "connection.option-key.", "connection.option-desc.", null, footer, this.scriptName);
    }

    @Override
    public String getTaskDescription() {
        return this.getOption("replicate.desc", new Object[0]);
    }

    @Override
    protected void abort(String message) throws TaskErrorException {
        this.stdout.println(this.getMessage("replicate.abort", new Object[0]));
        throw new TaskErrorException(message);
    }

    @Override
    protected void abortAndPerformCleanup(String message, File collectiveResourcesDir) throws TaskErrorException {
        this.stdout.println(this.getMessage("replicate.abort", new Object[0]));
        if (!this.fileUtility.recurisveDelete(collectiveResourcesDir)) {
            this.stdout.println(this.getMessage("replicate.cleanupFail", collectiveResourcesDir));
        }
        throw new TaskErrorException(message);
    }

    private Map<String, byte[]> replicate(String controllerHost, int controllerPort, String user, String password, String hostName, String userDir, String serverName, String installDir, String keystorePassword, Map<String, Object> certProps, Map<String, Object> hostAuthInfo) throws TaskErrorException {
        try {
            Map<String, byte[]> ret = this.registrationMBean.replicate(controllerHost, controllerPort, user, password, hostName, userDir, serverName, installDir, keystorePassword, certProps, hostAuthInfo);
            this.stdout.println(this.getMessage("replicate.mbeanComplete", new Object[0]));
            return ret;
        }
        catch (RuntimeMBeanException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Caught RuntimeMBeanException, this may be expected, but here's the stack incase it helps.", (Object[])new Object[]{e});
            }
            if (e.getCause() instanceof IllegalStateException) {
                this.abortAndPerformCleanup(this.getMessage("replicate.registeredAlready", serverName), this.collectiveResourcesDir);
            } else if (e.getCause() instanceof IllegalArgumentException) {
                this.abortAndPerformCleanup(this.getMessage("common.connectionError", e.getMessage()), this.collectiveResourcesDir);
            } else {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Unexpected RuntimeMBeanException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
                }
                this.stderr.println(this.getMessage("error", e.getMessage()));
                this.abortAndPerformCleanup(this.getMessage("common.connectionError", e.getMessage()), this.collectiveResourcesDir);
            }
        }
        catch (UnknownHostException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("UnknownHostException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.abortAndPerformCleanup(this.getMessage("common.hostError", controllerHost), this.collectiveResourcesDir);
        }
        catch (ConnectException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("ConnectException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.abortAndPerformCleanup(this.getMessage("common.portError", String.valueOf(controllerPort)), this.collectiveResourcesDir);
        }
        catch (IOException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("IOException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.abortAndPerformCleanup(this.getMessage("common.connectionError", e.getMessage()), this.collectiveResourcesDir);
        }
        catch (Exception e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Unexpected Exception while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abortAndPerformCleanup(this.getMessage("common.connectionError", e.getMessage()), this.collectiveResourcesDir);
        }
        return null;
    }

    @Override
    public void handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) throws TaskErrorException {
        byte[] collectiveName;
        String encodedKeystorePassword;
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
        this.validateArgumentList(args, false);
        String serverName = this.getTaskTarget(args);
        String userDir = this.fileUtility.getUserDir();
        String installDir = this.fileUtility.getInstallDir();
        String serverDir = userDir + "servers" + "/" + serverName + "/";
        if (!this.fileUtility.exists(serverDir)) {
            userDir = this.fileUtility.resolvePath(userDir);
            this.abort(this.getMessage("serverNotFound", serverName, userDir));
        }
        this.collectiveResourcesDir = new File(serverDir + "resources/collective");
        if (this.fileUtility.exists(this.collectiveResourcesDir) && !this.fileUtility.isDirectoryEmpty(this.collectiveResourcesDir)) {
            this.abort(this.getMessage("replicate.errorAlreadyHasResources", new Object[0]));
        }
        this.handleAutoAcceptArgument(args);
        boolean checkInDefaultsDir = true;
        if (this.isConfigFileInDropins(args, checkInDefaultsDir)) {
            this.abort(this.getMessage("create.configLocationInDefaults", new Object[0]));
        }
        String controllerHost = this.getArgumentValue("--host", args, null);
        int controllerPort = Integer.valueOf(this.getArgumentValue("--port", args, null));
        String user = this.getArgumentValue("--user", args, null);
        String password = this.getArgumentValue("--password", args, null);
        String hostName = this.getArgumentValue("--hostName", args, this.getHostName());
        String defaultHTTPSCertificateSubject = "CN=" + hostName + ",OU=" + serverName + ",O=ibm,C=us";
        String keystorePassword = this.getArgumentValue("--keystorePassword", args, null);
        String serverIdentityKeystorePassword = this.getArgumentValue("--serverIdentityKeystorePassword", args, keystorePassword);
        Integer serverIdentityCertificateValidity = Integer.valueOf(this.getArgumentValue("--serverIdentityCertificateValidity", args, String.valueOf(1825)));
        String collectiveTrustKSPassword = this.getArgumentValue("--collectiveTrustKeystorePassword", args, keystorePassword);
        String httpsKSPassword = this.getArgumentValue("--httpsKeystorePassword", args, keystorePassword);
        String httpsCertificateSubject = this.getArgumentValue("--httpsCertificateSubject", args, defaultHTTPSCertificateSubject);
        Integer httpsCertificateValidity = Integer.valueOf(this.getArgumentValue("--httpsCertificateValidity", args, String.valueOf(1825)));
        String httpsTSPassword = this.getArgumentValue("--httpsTruststorePassword", args, keystorePassword);
        if (serverIdentityCertificateValidity < 365) {
            this.abort(this.getMessage("common.validityTooShort", "--serverIdentityCertificateValidity"));
        }
        if (httpsCertificateValidity < 365) {
            this.abort(this.getMessage("common.validityTooShort", "--httpsCertificateValidity"));
        }
        try {
            new LdapName(httpsCertificateSubject);
        }
        catch (InvalidNameException e) {
            this.abort(this.getMessage("common.invalidDN", "--httpsCertificateSubject", httpsCertificateSubject));
        }
        String encoding = this.getArgumentValue("--encoding", args, "xor");
        String key = this.getArgumentValue("--key", args, null);
        this.validateEncoding(encoding, key);
        HashMap<String, Object> hostAuthInfo = null;
        List<String> list = Arrays.asList(args);
        Boolean useHostCredentials = list.contains("--useHostCredentials");
        this.validateUseHostCredentialsOverrides(list, useHostCredentials);
        if (useHostCredentials.booleanValue()) {
            hostAuthInfo = new HashMap<String, Boolean>();
            hostAuthInfo.put("useHostCredentials", Boolean.TRUE);
        } else {
            hostAuthInfo = this.buildHostAuthInfo(args, this.sshKeyGen, this.sshKeyUtil, hostName, true, true, serverName, serverDir);
        }
        if (tc.isEventEnabled()) {
            Map hostAuthInfoWithMaskPassword = PasswordMaskUtil.maskPasswordsInMap(hostAuthInfo);
            Tr.event((TraceComponent)tc, (String)("Resulting hostAuthInfo:\n" + hostAuthInfoWithMaskPassword), (Object[])new Object[0]);
        }
        if ((encodedKeystorePassword = this.encodePassword(keystorePassword, "--keystorePassword", encoding, key)) == null) {
            this.abort(null);
        }
        String encodedServerIdentityKeystorePassword = this.encodePassword(serverIdentityKeystorePassword, "--serverIdentityKeystorePassword", encoding, key);
        String encodedCollectiveTrustKSPassword = this.encodePassword(collectiveTrustKSPassword, "--collectiveTrustKeystorePassword", encoding, key);
        String encodedHTTPSKSPassword = this.encodePassword(httpsKSPassword, "--httpsKeystorePassword", encoding, key);
        String encodedHTTPSTSPassword = this.encodePassword(httpsTSPassword, "--httpsTruststorePassword", encoding, key);
        if (encodedServerIdentityKeystorePassword == null || encodedCollectiveTrustKSPassword == null || encodedHTTPSKSPassword == null || encodedHTTPSTSPassword == null) {
            this.abort(null);
        }
        HashMap<String, Object> certProps = new HashMap<String, Object>();
        certProps.put("serverIdentityKeystorePassword", encodedServerIdentityKeystorePassword);
        certProps.put("serverIdentityCertificateValidity", serverIdentityCertificateValidity);
        certProps.put("collectiveTrustKeystorePassword", encodedCollectiveTrustKSPassword);
        certProps.put("httpsKeystorePassword", encodedHTTPSKSPassword);
        certProps.put("httpsCertificateSubject", httpsCertificateSubject);
        certProps.put("httpsCertificateValidity", httpsCertificateValidity);
        certProps.put("httpsTruststorePassword", encodedHTTPSTSPassword);
        File serverIdentityKeyFile = new File(serverDir + "resources/collective/serverIdentity.jks");
        File collectiveTrustKeyFile = new File(serverDir + "resources/collective/collectiveTrust.jks");
        File rootKeysKeyFile = new File(serverDir + "resources/collective/rootKeys.jks");
        File collectiveUUIDFile = new File(serverDir + "resources/collective/collective.uuid");
        File collectiveNameFile = new File(serverDir + "resources/collective/collective.name");
        File httpsKSFile = new File(serverDir + "resources/security/key.jks");
        File tmpHttpsKSFile = new File(serverDir + "resources/security/key.jks" + ".tmp");
        if (httpsKSFile.exists()) {
            stdout.println(this.getMessage("common.regenerateKey", httpsKSFile.getAbsolutePath()));
        }
        File httpsTSFile = new File(serverDir + "resources/security/trust.jks");
        File tmpHttpsTSFile = new File(serverDir + "resources/security/trust.jks" + ".tmp");
        if (httpsTSFile.exists()) {
            stdout.println(this.getMessage("common.regenerateTrust", httpsTSFile.getAbsolutePath()));
        }
        if (!this.fileUtility.createParentDirectory(stdout, serverIdentityKeyFile)) {
            this.abortAndPerformCleanup(null, this.collectiveResourcesDir);
        }
        if (!this.fileUtility.createParentDirectory(stdout, collectiveTrustKeyFile)) {
            this.abortAndPerformCleanup(null, this.collectiveResourcesDir);
        }
        if (!this.fileUtility.createParentDirectory(stdout, rootKeysKeyFile)) {
            this.abortAndPerformCleanup(null, this.collectiveResourcesDir);
        }
        if (!this.fileUtility.createParentDirectory(stdout, collectiveUUIDFile)) {
            this.abortAndPerformCleanup(null, this.collectiveResourcesDir);
        }
        if (!this.fileUtility.createParentDirectory(stdout, collectiveNameFile)) {
            this.abortAndPerformCleanup(null, this.collectiveResourcesDir);
        }
        if (!this.fileUtility.createParentDirectory(stdout, httpsKSFile)) {
            this.abortAndPerformCleanup(null, this.collectiveResourcesDir);
        }
        if (!this.fileUtility.createParentDirectory(stdout, tmpHttpsKSFile)) {
            this.abortAndPerformCleanup(null, this.collectiveResourcesDir);
        }
        if (!this.fileUtility.createParentDirectory(stdout, httpsTSFile)) {
            this.abortAndPerformCleanup(null, this.collectiveResourcesDir);
        }
        if (!this.fileUtility.createParentDirectory(stdout, tmpHttpsTSFile)) {
            this.abortAndPerformCleanup(null, this.collectiveResourcesDir);
        }
        stdout.println(this.getMessage("replicate.start", controllerHost, String.valueOf(controllerPort)));
        Map<String, byte[]> joinResult = this.replicate(controllerHost, controllerPort, user, password, hostName, userDir, serverName, installDir, keystorePassword, certProps, hostAuthInfo);
        if (!this.fileUtility.writeBytesToFile(stderr, joinResult.get("serverIdentity.jks"), serverIdentityKeyFile)) {
            this.abortAndPerformCleanup(this.getMessage("replicate.writeKeystoreFail", serverIdentityKeyFile.getAbsolutePath()), this.collectiveResourcesDir);
        }
        if (!this.fileUtility.writeBytesToFile(stderr, joinResult.get("collectiveTrust.jks"), collectiveTrustKeyFile)) {
            this.abortAndPerformCleanup(this.getMessage("replicate.writeKeystoreFail", collectiveTrustKeyFile.getAbsolutePath()), this.collectiveResourcesDir);
        }
        if (!this.fileUtility.writeBytesToFile(stderr, joinResult.get("rootKeys.jks"), rootKeysKeyFile)) {
            this.abortAndPerformCleanup(this.getMessage("replicate.writeKeystoreFail", rootKeysKeyFile.getAbsolutePath()), this.collectiveResourcesDir);
        }
        if (!this.fileUtility.writeBytesToFile(stderr, joinResult.get("collective.uuid"), collectiveUUIDFile)) {
            this.abortAndPerformCleanup(this.getMessage("replicate.writeFileFail", collectiveUUIDFile.getAbsolutePath()), this.collectiveResourcesDir);
        }
        if ((collectiveName = joinResult.get("collective.name")) == null) {
            try {
                collectiveName = "defaultCollective".getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (collectiveName == null || !this.fileUtility.writeBytesToFile(stderr, joinResult.get("key.jks"), tmpHttpsKSFile)) {
            this.abortAndPerformCleanup(this.getMessage("replicate.writeKeystoreFail", tmpHttpsKSFile.getAbsolutePath()), this.collectiveResourcesDir);
        }
        if (!this.fileUtility.writeBytesToFile(stderr, joinResult.get("key.jks"), tmpHttpsKSFile)) {
            this.abortAndPerformCleanup(this.getMessage("replicate.writeKeystoreFail", tmpHttpsKSFile.getAbsolutePath()), this.collectiveResourcesDir);
        }
        if (!this.fileUtility.writeBytesToFile(stderr, joinResult.get("trust.jks"), tmpHttpsTSFile)) {
            this.abortAndPerformCleanup(this.getMessage("replicate.writeKeystoreFail", tmpHttpsTSFile.getAbsolutePath()), this.collectiveResourcesDir);
        }
        this.updateExistingSSLKeys(httpsKSFile, tmpHttpsKSFile, httpsTSFile, tmpHttpsTSFile, this.collectiveResourcesDir);
        stdout.println();
        stdout.println(this.getMessage("replicate.success", serverName));
        String configXML = this.getConfigXML(args, controllerHost, hostName, encoding, key, encodedServerIdentityKeystorePassword, encodedCollectiveTrustKSPassword, encodedHTTPSKSPassword, encodedHTTPSTSPassword);
        this.handleConfigXML(stdout, args, serverDir, configXML);
        stdout.println(this.getMessage("replicate.configureSecurity", new Object[0]));
    }

    private String getConfigXML(String[] args, String controllerHost, String hostName, String encoding, String key, String encodedServerIdentityKeystorePassword, String encodedCollectiveTrustKSPassword, String encodedHTTPSKSPassword, String encodedHTTPSTSPassword) {
        Integer defaultReplicaPort = DEFAULT_REPLICA_PORT;
        Integer replicaPort = Integer.getInteger("controller_1.replica", defaultReplicaPort);
        String xmlSnippet = "    <featureManager>" + NL + "        <feature>collectiveController-1.0</feature>" + NL + "    </featureManager>" + NL + NL + this.insertHostNameVariable(hostName) + NL + this.insertHostAuthInfo(args) + "    <!-- Configuration of the collective controller replica." + NL + "         TODO: If this replica is on the same host as the original controller," + NL + "               change the replicaPort." + NL + "         TODO: If the target controller's replica port is not " + replicaPort + NL + "               (the default) change the value in replicaSet. -->" + NL + "    <collectiveController replicaPort=\"" + replicaPort + "\"" + NL + "                          replicaSet=\"" + controllerHost + ":" + replicaPort + "\"" + NL + "                          isInitialReplicaSet=\"false\" />" + NL + NL + "    <!-- TODO: Define the security configuration exactly as defined in the" + NL + "               target controller from which this was replicated. -->" + NL + "    <quickStartSecurity userName=\"\" userPassword=\"\" />" + NL + NL + this.insertEncodingKey(encoding, key) + "    <!-- clientAuthenticationSupported set to enable bidirectional trust -->" + NL + "    <ssl id=\"defaultSSLConfig\"" + NL + "         keyStoreRef=\"defaultKeyStore\"" + NL + "         trustStoreRef=\"defaultTrustStore\"" + NL + "         clientAuthenticationSupported=\"true\" />" + NL + NL + "    <!-- inbound (HTTPS) keystore -->" + NL + "    <keyStore id=\"defaultKeyStore\" password=\"" + encodedHTTPSKSPassword + "\"" + NL + "              location=\"${server.config.dir}/" + "resources/security/key.jks" + "\" />" + NL + NL + "    <!-- inbound (HTTPS) truststore -->" + NL + "    <keyStore id=\"defaultTrustStore\" password=\"" + encodedHTTPSTSPassword + "\"" + NL + "              location=\"${server.config.dir}/" + "resources/security/trust.jks" + "\" />" + NL + NL + "    <!-- server identity keystore -->" + NL + "    <keyStore id=\"serverIdentity\" password=\"" + encodedServerIdentityKeystorePassword + "\"" + NL + "              location=\"${server.config.dir}/" + "resources/collective/serverIdentity.jks" + "\" />" + NL + NL + "    <!-- collective truststore -->" + NL + "    <keyStore id=\"collectiveTrust\" password=\"" + encodedCollectiveTrustKSPassword + "\"" + NL + "              location=\"${server.config.dir}/" + "resources/collective/collectiveTrust.jks" + "\" />" + NL + NL + "    <!-- collective root signers keystore" + NL + "         TODO: set password to the collectiveRootKeys password in the" + NL + "         original controller -->" + NL + "    <keyStore id=\"collectiveRootKeys\" password=\"\"" + NL + "              location=\"${server.config.dir}/" + "resources/collective/rootKeys.jks" + "\" />" + NL;
        return xmlSnippet;
    }
}

