/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.utility.tasks;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.collective.member.DockerEnvironmentUtil;
import com.ibm.ws.collective.utility.IAdminMetadataManagerMBeanConnection;
import com.ibm.ws.collective.utility.ICollectiveRegistrationMBeanConnection;
import com.ibm.ws.collective.utility.ICollectiveRepositoryMBeanConnection;
import com.ibm.ws.collective.utility.IFileUtility;
import com.ibm.ws.collective.utility.TaskErrorException;
import com.ibm.ws.collective.utility.tasks.BaseCommandTask;
import com.ibm.ws.collective.utility.utils.ConsoleWrapper;
import com.ibm.ws.collective.utils.RepositoryPathUtility;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Map;
import javax.management.RuntimeMBeanException;

public class RemoveTask
extends BaseCommandTask {
    private static final TraceComponent tc = Tr.register(RemoveTask.class);
    private final ICollectiveRegistrationMBeanConnection registrationMBean;
    private final IAdminMetadataManagerMBeanConnection metadataManagerMBean;
    private final ICollectiveRepositoryMBeanConnection repositoryMBean;

    public RemoveTask(String scriptName, IFileUtility fileUtility, ICollectiveRegistrationMBeanConnection registrationMBean, IAdminMetadataManagerMBeanConnection metadataManagerMBean, ICollectiveRepositoryMBeanConnection repositoryMBean) {
        super(tc, scriptName, fileUtility);
        this.registrationMBean = registrationMBean;
        this.metadataManagerMBean = metadataManagerMBean;
        this.repositoryMBean = repositoryMBean;
        this.reqArgs.add("--host");
        this.reqArgs.add("--port");
        this.reqArgs.add("--user");
        this.reqArgs.add("--password");
        this.promptableArgs.add("--password");
        this.flagArgs.add("--removeDeployVariables");
        this.knownArgs.addAll(this.reqArgs);
        this.knownArgs.addAll(this.promptableArgs);
        this.knownArgs.addAll(this.confirmedArgs);
        this.knownArgs.addAll(this.flagArgs);
        this.knownArgs.add("--hostName");
        this.addAutoAcceptArgument();
    }

    @Override
    public String getTaskName() {
        return "remove";
    }

    @Override
    public String getTaskUsage() {
        return this.getTaskUsage("remove.usage.options");
    }

    @Override
    public String getTaskHelp() {
        String footer = this.buildScriptOptions("common.option-key.", "common.option-desc.") + this.buildScriptOptions("certProps.option-key.autoAccept", "certProps.option-desc.autoAccept") + NL + NL + this.getOption("sslTrust.autoAccept", "com.ibm.websphere.collective.utility.autoAcceptCertificates");
        return this.getTaskHelp("remove.desc", "remove.usage.options", "connection.option-key.", "connection.option-desc.", null, footer, this.scriptName);
    }

    @Override
    public String getTaskDescription() {
        return this.getOption("remove.desc", new Object[0]);
    }

    @Override
    protected void abort(String message) {
        this.stderr.println(message);
    }

    private void abortAndThrowTaskErrorException(String message, String serverName) throws TaskErrorException {
        this.stdout.println(this.getMessage("remove.unregisterFailed", serverName));
        throw new TaskErrorException(message);
    }

    @Override
    protected void abortAndPerformCleanup(String message, File collectiveResourcesDir) throws TaskErrorException {
    }

    private boolean removeServer(String host, int port, String user, String password, String serverName, String hostName, String userDir) throws TaskErrorException {
        try {
            this.registrationMBean.remove(host, port, user, password, serverName, hostName, userDir);
            this.stdout.println(this.getMessage("remove.unregisterSuccess", serverName));
            return true;
        }
        catch (RuntimeMBeanException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Caught RuntimeMBeanException, this may be expected, but here's the stack incase it helps.", (Object[])new Object[]{e});
            }
            if (e.getCause() instanceof IllegalStateException) {
                this.stdout.println(this.getMessage("remove.unregisteredAlready", serverName));
                return true;
            }
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Unexpected RuntimeMBeanException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abortAndThrowTaskErrorException(this.getMessage("common.connectionError", e.getMessage()), serverName);
        }
        catch (UnknownHostException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("UnknownHostException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.abortAndThrowTaskErrorException(this.getMessage("common.hostError", host), serverName);
        }
        catch (ConnectException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("ConnectException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.abortAndThrowTaskErrorException(this.getMessage("common.portError", String.valueOf(port)), serverName);
        }
        catch (IOException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("IOException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.abortAndThrowTaskErrorException(this.getMessage("common.connectionError", e.getMessage()), serverName);
        }
        catch (Exception e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Unexpected Exception while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abortAndThrowTaskErrorException(this.getMessage("common.connectionError", e.getMessage()), serverName);
        }
        return false;
    }

    private boolean removeAllAdminMetadata(String host, int port, String user, String password, String resourceType, String identity) throws TaskErrorException {
        try {
            this.metadataManagerMBean.removeAllAdminMetadata(host, port, user, password, resourceType, identity);
            this.stdout.println(this.getMessage("removeAllAdminMetadata.mbeanComplete", new Object[0]));
            return true;
        }
        catch (RuntimeMBeanException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Caught RuntimeMBeanException, this may be expected, but here's the stack incase it helps.", (Object[])new Object[]{e});
            } else {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Unexpected RuntimeMBeanException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
                }
                this.stderr.println(this.getMessage("error", e.getMessage()));
                this.abort(this.getMessage("common.connectionError", e.getMessage()));
            }
        }
        catch (UnknownHostException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("UnknownHostException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.abort(this.getMessage("common.hostError", host));
        }
        catch (ConnectException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("ConnectException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.abort(this.getMessage("common.portError", String.valueOf(port)));
        }
        catch (IOException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("IOException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.abort(this.getMessage("common.connectionError", e.getMessage()));
        }
        catch (Exception e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Unexpected Exception while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("common.connectionError", e.getMessage()));
        }
        return false;
    }

    private boolean getAdminMetadata(String host, int port, String user, String password, String resourceType, String identity) throws TaskErrorException {
        boolean metadataExist = false;
        try {
            Map<String, Object> metadata = this.metadataManagerMBean.getAdminMetadata(host, port, user, password, resourceType, identity);
            this.stdout.println(this.getMessage("getAdminMetadata.mbeanComplete", new Object[0]));
            if (metadata.size() > 0) {
                metadataExist = true;
            }
        }
        catch (RuntimeMBeanException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Caught RuntimeMBeanException, this may be expected, but here's the stack incase it helps.", (Object[])new Object[]{e});
            } else {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Unexpected RuntimeMBeanException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
                }
                this.stderr.println(this.getMessage("error", e.getMessage()));
                this.abort(this.getMessage("common.connectionError", e.getMessage()));
            }
        }
        catch (UnknownHostException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("UnknownHostException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.abort(this.getMessage("common.hostError", host));
        }
        catch (ConnectException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("ConnectException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.abort(this.getMessage("common.portError", String.valueOf(port)));
        }
        catch (IOException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("IOException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.abort(this.getMessage("common.connectionError", e.getMessage()));
        }
        catch (Exception e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Unexpected Exception while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("common.connectionError", e.getMessage()));
        }
        return metadataExist;
    }

    private boolean releaseDeployVariables(String host, int port, String user, String password, String hostName, Map<String, Integer> deployVars) throws TaskErrorException {
        try {
            this.repositoryMBean.releaseDeployVariables(host, port, user, password, hostName, deployVars);
            this.stdout.println(this.getMessage("releaseDeployVariables.mbeanComplete", new Object[0]));
            return true;
        }
        catch (RuntimeMBeanException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Caught RuntimeMBeanException, this may be expected, but here's the stack incase it helps.", (Object[])new Object[]{e});
            } else {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Unexpected RuntimeMBeanException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
                }
                this.stderr.println(this.getMessage("error", e.getMessage()));
                this.abort(this.getMessage("common.connectionError", e.getMessage()));
            }
        }
        catch (UnknownHostException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("UnknownHostException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.abort(this.getMessage("common.hostError", host));
        }
        catch (ConnectException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("ConnectException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.abort(this.getMessage("common.portError", String.valueOf(port)));
        }
        catch (IOException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("IOException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.abort(this.getMessage("common.connectionError", e.getMessage()));
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof NoSuchMethodException) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("NoSuchMethodException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
                }
                this.abort(this.getMessage("common.compatibilityError", e.getMessage()));
            }
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Unexpected Exception while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("common.connectionError", e.getMessage()));
        }
        return false;
    }

    @Override
    public void handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) throws TaskErrorException {
        String parentDir;
        String deployVariablesFilePath;
        boolean deployVariablesFileExists;
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
        this.validateArgumentList(args, false);
        this.handleAutoAcceptArgument(args);
        String serverName = this.getTaskTarget(args);
        String userDir = this.fileUtility.getUserDir();
        String serverDir = userDir + "servers" + "/" + serverName + "/";
        String hostName = this.getArgumentValue("--hostName", args, this.getHostName());
        String controllerHost = this.getArgumentValue("--host", args, null);
        int controllerPort = Integer.valueOf(this.getArgumentValue("--port", args, null));
        String user = this.getArgumentValue("--user", args, null);
        String password = this.getArgumentValue("--password", args, null);
        if (DockerEnvironmentUtil.isMemberInDockerEnvironment()) {
            hostName = DockerEnvironmentUtil.getContainerPropertyFromEnvironment((String)"containerHost");
            userDir = "Docker";
            serverName = DockerEnvironmentUtil.getContainerPropertyFromEnvironment((String)"containerName");
        }
        stdout.println(this.getMessage("remove.attemptUnregister", hostName, userDir, serverName));
        if (!this.removeServer(controllerHost, controllerPort, user, password, serverName, hostName, userDir)) {
            stdout.println(this.getMessage("remove.unregisterFailed", serverName));
        }
        stdout.println();
        stdout.println(this.getMessage("remove.attemptResourceDelete", new Object[0]));
        boolean serverExists = this.fileUtility.exists(serverDir);
        if (!serverExists) {
            userDir = this.fileUtility.resolvePath(userDir);
            stdout.println(this.getMessage("serverNotFound", serverName, userDir));
            stdout.println(this.getMessage("remove.noFilesRemoved", new Object[0]));
        } else {
            String resourcesDir = this.fileUtility.resolvePath(serverDir + "resources/collective");
            if (!this.fileUtility.exists(resourcesDir)) {
                stdout.println(this.getMessage("remove.noResources", new Object[0]));
            } else if (!this.fileUtility.recurisveDelete(resourcesDir)) {
                stdout.println(this.getMessage("remove.manuallyRemove", resourcesDir));
            } else {
                stdout.println(this.getMessage("remove.filesSuccess", new Object[0]));
            }
            String collectiveFilePath = this.fileUtility.getOutputDirectory() + serverName + "/workarea/.collective";
            if (!this.fileUtility.exists(collectiveFilePath) || !this.fileUtility.delete(collectiveFilePath)) {
                // empty if block
            }
        }
        boolean userDirExists = this.fileUtility.exists(userDir);
        if (userDirExists) {
            String serverIdentity = RepositoryPathUtility.buildServerTuple((String)hostName, (String)userDir, (String)serverName);
            serverIdentity = RepositoryPathUtility.encodeServerTuple((String)serverIdentity);
            stdout.println(this.getMessage("removeAllAdminMetadata.start", new Object[0]));
            if (this.getAdminMetadata(controllerHost, controllerPort, user, password, "server", serverIdentity) && !this.removeAllAdminMetadata(controllerHost, controllerPort, user, password, "server", serverIdentity)) {
                stdout.println(this.getMessage("remove.removeAllAdminMetadataFailed", "server", serverIdentity));
            }
        } else {
            stdout.println(this.getMessage("userDirNotFound", userDir));
        }
        Boolean removeDeployVariables = Arrays.asList(args).contains("--removeDeployVariables");
        if (removeDeployVariables.booleanValue() && (deployVariablesFileExists = this.fileUtility.exists(deployVariablesFilePath = (parentDir = serverDir + "configDropins/overrides") + "/" + "deployVariables.xml"))) {
            Map<String, Integer> deployVars = this.fileUtility.parseDeployVariablesXML(stderr, new File(deployVariablesFilePath));
            if (deployVars != null && deployVars.size() > 0) {
                stdout.println(this.getMessage("releaseDeployVariables.start", new Object[0]));
                if (this.releaseDeployVariables(controllerHost, controllerPort, user, password, hostName, deployVars)) {
                    this.fileUtility.delete(deployVariablesFilePath);
                } else {
                    stdout.println(this.getMessage("remove.releaseDeployVariablesFailed", deployVars, hostName));
                }
            } else {
                this.fileUtility.delete(deployVariablesFilePath);
            }
        }
        if (serverExists) {
            stdout.println(this.getMessage("remove.updateXML", new Object[0]));
            stdout.println(NL + "    <featureManager>" + NL + "        <feature>collectiveController-1.0</feature>" + NL + "        <feature>collectiveMember-1.0</feature>" + NL + "    </featureManager>" + NL + "    <collectiveMember ... />" + NL + "    <hostAuthInfo ... />" + NL + NL);
        }
    }
}

