/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.management.j2ee.internal;

import com.ibm.websphere.management.j2ee.EJBModuleMBean;
import com.ibm.websphere.management.j2ee.EntityBeanMBean;
import com.ibm.websphere.management.j2ee.J2EEManagementObjectNameFactory;
import com.ibm.websphere.management.j2ee.MessageDrivenBeanMBean;
import com.ibm.websphere.management.j2ee.SingletonSessionBeanMBean;
import com.ibm.websphere.management.j2ee.StatefulSessionBeanMBean;
import com.ibm.websphere.management.j2ee.StatelessSessionBeanMBean;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ejbcontainer.EJBComponentMetaData;
import com.ibm.ws.ejbcontainer.EJBType;
import com.ibm.ws.ejbcontainer.management.j2ee.internal.EJBModule;
import com.ibm.ws.ejbcontainer.management.j2ee.internal.EntityBean;
import com.ibm.ws.ejbcontainer.management.j2ee.internal.MessageDrivenBean;
import com.ibm.ws.ejbcontainer.management.j2ee.internal.SingletonSessionBean;
import com.ibm.ws.ejbcontainer.management.j2ee.internal.StatefulSessionBean;
import com.ibm.ws.ejbcontainer.management.j2ee.internal.StatelessSessionBean;
import com.ibm.ws.ejbcontainer.osgi.EJBMBeanRuntime;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import javax.management.ObjectName;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component
public class EJBMBeanRuntimeImpl
implements EJBMBeanRuntime {
    private BundleContext context;
    private WsLocationAdmin locationAdmin;
    static final long serialVersionUID = 6751142916056135222L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Reference
    protected void setLocationAdmin(WsLocationAdmin locationAdmin) {
        this.locationAdmin = locationAdmin;
    }

    @Activate
    protected void activate(BundleContext context) {
        this.context = context;
    }

    private <T> ServiceRegistration<T> registerMBean(ObjectName on, Class<T> type, T o) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("jmx.objectname", on.toString());
        return this.context.registerService(type, o, props);
    }

    public ServiceRegistration<?> registerModuleMBean(String appName, String moduleName, Container container, String ddPath, List<EJBComponentMetaData> ejbs) {
        String serverName = this.locationAdmin.getServerName();
        ObjectName objectName = J2EEManagementObjectNameFactory.createModuleObjectName((J2EEManagementObjectNameFactory.ModuleType)J2EEManagementObjectNameFactory.ModuleType.EJBModule, (String)moduleName, (String)appName, (String)serverName);
        ObjectName serverObjectName = J2EEManagementObjectNameFactory.createJ2EEServerObjectName((String)serverName);
        ObjectName jvmObjectName = J2EEManagementObjectNameFactory.createJVMObjectName((String)serverName);
        ObjectName[] ejbObjectNames = new ObjectName[ejbs.size()];
        for (int i = 0; i < ejbs.size(); ++i) {
            EJBComponentMetaData ejb = ejbs.get(i);
            ejbObjectNames[i] = J2EEManagementObjectNameFactory.createEJBObjectName((J2EEManagementObjectNameFactory.EJBType)EJBMBeanRuntimeImpl.getJ2EEType(ejb.getEJBType()), (String)ejb.getName(), (String)moduleName, (String)appName, (String)serverName);
        }
        return this.registerMBean(objectName, EJBModuleMBean.class, new EJBModule(objectName, serverObjectName, jvmObjectName, container, ddPath, ejbObjectNames));
    }

    private static J2EEManagementObjectNameFactory.EJBType getJ2EEType(EJBType type) {
        switch (type) {
            case STATELESS_SESSION: {
                return J2EEManagementObjectNameFactory.EJBType.StatelessSessionBean;
            }
            case STATEFUL_SESSION: {
                return J2EEManagementObjectNameFactory.EJBType.StatefulSessionBean;
            }
            case SINGLETON_SESSION: {
                return J2EEManagementObjectNameFactory.EJBType.SingletonSessionBean;
            }
            case BEAN_MANAGED_ENTITY: {
                return J2EEManagementObjectNameFactory.EJBType.EntityBean;
            }
            case CONTAINER_MANAGED_ENTITY: {
                return J2EEManagementObjectNameFactory.EJBType.EntityBean;
            }
            case MESSAGE_DRIVEN: {
                return J2EEManagementObjectNameFactory.EJBType.MessageDrivenBean;
            }
        }
        throw new IllegalArgumentException(type.toString());
    }

    public ServiceRegistration<?> registerEJBMBean(String appName, String moduleName, String beanName, EJBType type) {
        String serverName = this.locationAdmin.getServerName();
        ObjectName objectName = J2EEManagementObjectNameFactory.createEJBObjectName((J2EEManagementObjectNameFactory.EJBType)EJBMBeanRuntimeImpl.getJ2EEType(type), (String)beanName, (String)moduleName, (String)appName, (String)serverName);
        switch (type) {
            case STATELESS_SESSION: {
                return this.registerMBean(objectName, StatelessSessionBeanMBean.class, new StatelessSessionBean(objectName));
            }
            case STATEFUL_SESSION: {
                return this.registerMBean(objectName, StatefulSessionBeanMBean.class, new StatefulSessionBean(objectName));
            }
            case SINGLETON_SESSION: {
                return this.registerMBean(objectName, SingletonSessionBeanMBean.class, new SingletonSessionBean(objectName));
            }
            case BEAN_MANAGED_ENTITY: 
            case CONTAINER_MANAGED_ENTITY: {
                return this.registerMBean(objectName, EntityBeanMBean.class, new EntityBean(objectName));
            }
            case MESSAGE_DRIVEN: {
                return this.registerMBean(objectName, MessageDrivenBeanMBean.class, new MessageDrivenBean(objectName));
            }
        }
        throw new IllegalArgumentException(type.toString());
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(EJBMBeanRuntimeImpl.class);
    }
}

