/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.admin.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.admin.internal.ConfigAdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import java.util.concurrent.Future;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.util.tracker.ServiceTracker;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class ConfigEventDispatcher {
    private static final String ME = ConfigEventDispatcher.class.getName();
    private static final TraceComponent tc = Tr.register(ConfigEventDispatcher.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    private final ServiceTracker<ConfigurationListener, ConfigurationListener> st;
    private ServiceReference<ConfigurationAdmin> configAdminReference;
    private final ConfigAdminServiceFactory caFactory;
    static final long serialVersionUID = 7387440399302146247L;

    public ConfigEventDispatcher(ConfigAdminServiceFactory casf, BundleContext bc) {
        this.caFactory = casf;
        this.st = new ServiceTracker(bc, ConfigurationListener.class.getName(), null);
        this.st.open();
    }

    public void close() {
        this.st.close();
    }

    synchronized void setServiceReference(ServiceReference<ConfigurationAdmin> reference) {
        if (this.configAdminReference == null) {
            this.configAdminReference = reference;
        }
    }

    protected Future<?> dispatch(final int eventType, final String factoryPid, final String pid) {
        final ConfigurationEvent event = this.createConfigurationEvent(eventType, factoryPid, pid);
        if (event == null) {
            return null;
        }
        final ServiceReference[] refs = this.st.getServiceReferences();
        if (refs == null) {
            return null;
        }
        final String qPid = factoryPid != null ? factoryPid : pid;
        return this.caFactory.updateQueue.add(qPid, new Runnable(){
            static final long serialVersionUID = 1390974379714960986L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            @FFDCIgnore(value={Exception.class})
            public void run() {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("dispatch: sending configuration listener event for " + qPid), (Object[])new Object[0]);
                }
                for (ServiceReference sr : refs) {
                    ConfigurationListener cl;
                    if (sr == null || (cl = (ConfigurationListener)ConfigEventDispatcher.this.st.getService(sr)) == null || !FrameworkState.isValid()) continue;
                    try {
                        cl.configurationEvent(event);
                    }
                    catch (Exception e) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"dispatch(): Exception thrown while trying to dispatch ConfigurationEvent.", (Object[])new Object[]{e});
                        }
                        FFDCFilter.processException((Throwable)e, (String)ME, (String)"dispatch(): Exception thrown while trying to dispatch ConfigurationEvent.", (Object[])new Object[]{pid, factoryPid, eventType, cl});
                    }
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
    }

    private synchronized ConfigurationEvent createConfigurationEvent(int type, String factoryPid, String pid) {
        if (this.configAdminReference == null) {
            return null;
        }
        return new ConfigurationEvent(this.configAdminReference, type, factoryPid, pid);
    }
}

