/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.ValueHandler;
import org.apache.yoko.rmi.impl.RMIPersistentStub;
import org.apache.yoko.rmi.impl.RMIState;
import org.apache.yoko.rmi.impl.RMIStub;
import org.apache.yoko.rmi.impl.RemoteDescriptor;
import org.apache.yoko.rmi.impl.RunTimeCodeBaseImpl;
import org.apache.yoko.rmi.impl.TypeDescriptor;
import org.apache.yoko.rmi.impl.TypeRepository;
import org.apache.yoko.rmi.impl.ValueDescriptor;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.ValueDefPackage.FullValueDescription;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import org.omg.SendingContext.CodeBaseHelper;
import org.omg.SendingContext.RunTime;

public class ValueHandlerImpl
implements ValueHandler {
    static final Logger logger = Logger.getLogger(ValueHandlerImpl.class.getName());
    private final TypeRepository repo;
    RunTimeCodeBaseImpl codeBase;
    Map streamMap = new HashMap();

    private ValueHandlerImpl() {
        this.repo = TypeRepository.get();
    }

    public static ValueHandlerImpl get() {
        return HandlerHolder.value;
    }

    private ValueDescriptor desc(Class clz) {
        return (ValueDescriptor)this.repo.getDescriptor(clz);
    }

    private ValueDescriptor desc(String repId) {
        return (ValueDescriptor)this.repo.getDescriptor(repId);
    }

    private ValueDescriptor desc(Class clz, String repid, RunTime runtime) {
        try {
            return this.repo.getDescriptor(clz, repid, runtime);
        }
        catch (ClassNotFoundException ex) {
            MARSHAL m = new MARSHAL("class not found " + ex.getMessage());
            m.initCause((Throwable)ex);
            throw m;
        }
    }

    public void writeValue(OutputStream out, Serializable val) {
        this.desc(val.getClass()).writeValue(out, val);
    }

    public Serializable readValue(InputStream in, int offset, Class clz, String repid, RunTime codebase) {
        try {
            return this.readValue0(in, offset, clz, repid, codebase);
        }
        catch (Error ex) {
            logger.log(Level.FINE, "Exception reading value of type " + repid, ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            logger.log(Level.FINE, "Exception reading value of type " + repid, ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable readValue0(InputStream in, int offset, Class clz, String repid, RunTime codebase) {
        Map map;
        Serializable obj = null;
        ValueDescriptor desc = repid == null ? this.desc(clz) : this.desc(clz, repid, codebase);
        Integer key = new Integer(offset);
        boolean remove = false;
        HashMap<Integer, java.lang.Object> offsetMap = null;
        try {
            map = this.streamMap;
            synchronized (map) {
                offsetMap = (HashMap<Integer, java.lang.Object>)this.streamMap.get(in);
                if (offsetMap == null) {
                    offsetMap = new HashMap<Integer, java.lang.Object>();
                    this.streamMap.put(in, offsetMap);
                    remove = true;
                }
            }
            obj = desc.readValue(in, offsetMap, key);
        }
        finally {
            if (remove) {
                map = this.streamMap;
                synchronized (map) {
                    this.streamMap.remove(in);
                }
            }
        }
        return obj;
    }

    public String getRMIRepositoryID(Class clz) {
        return this.repo.getDescriptor(clz).getRepositoryID();
    }

    public boolean isCustomMarshaled(Class clz) {
        return this.desc(clz).isChunked();
    }

    public synchronized RunTime getRunTimeCodeBase() {
        logger.finer("getRunTimeCodeBase");
        if (this.codeBase == null) {
            this.codeBase = new RunTimeCodeBaseImpl(this);
        }
        ORB orb = RMIState.current().getORB();
        POA poa = RMIState.current().getPOA();
        try {
            Object ref = poa.servant_to_reference((Servant)this.codeBase);
            return CodeBaseHelper.narrow((Object)ref);
        }
        catch (ServantNotActive ref) {
        }
        catch (WrongPolicy ex) {
            throw (INTERNAL)new INTERNAL("should not happen").initCause((Throwable)ex);
        }
        try {
            byte[] id = poa.activate_object((Servant)this.codeBase);
            Object ref = poa.id_to_reference(id);
            return CodeBaseHelper.narrow((Object)ref);
        }
        catch (ServantAlreadyActive ex) {
            throw (INTERNAL)new INTERNAL("should not happen").initCause((Throwable)ex);
        }
        catch (ObjectNotActive ex) {
            throw (INTERNAL)new INTERNAL("should not happen").initCause((Throwable)ex);
        }
        catch (WrongPolicy ex) {
            throw (INTERNAL)new INTERNAL("should not happen").initCause((Throwable)ex);
        }
    }

    public Serializable writeReplace(Serializable val) {
        if (val instanceof RMIStub) {
            RMIStub stub = (RMIStub)((java.lang.Object)val);
            Class type = stub._descriptor.type;
            RMIState state = RMIState.current();
            Stub result = state.getStaticStub(stub._get_codebase(), type);
            if (result != null) {
                result._set_delegate(stub._get_delegate());
                logger.finer("replacing with stub " + result.getClass().getName());
                return result;
            }
            return new RMIPersistentStub(stub, type);
        }
        ValueDescriptor desc = this.desc(val.getClass());
        Serializable result = desc.writeReplace(val);
        if (result != val) {
            logger.finer("replacing with value of type " + val.getClass().getName() + " with " + result.getClass().getName());
        }
        return result;
    }

    static Class getClassFromRepositoryID(String id) {
        String className = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("getClassFromRepositoryID => " + id);
        }
        try {
            if (id.startsWith("RMI:")) {
                className = id.substring(4, id.indexOf(58, 4));
            } else if (id.startsWith("IDL:")) {
                className = id.substring(4, id.indexOf(58, 4));
            } else {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("getClassFromRepositoryID =>> " + null);
                }
                return null;
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("getClassFromRepositoryID =>> " + className);
            }
            ClassLoader loader = RMIState.current().getClassLoader();
            return loader.loadClass(className);
        }
        catch (Throwable ex) {
            logger.log(Level.FINE, "error resolving class from id", ex);
            return null;
        }
    }

    String getImplementation(String id) {
        try {
            String result = "";
            Class clz = ValueHandlerImpl.getClassFromRepositoryID(id);
            if (clz != null && (result = Util.getCodebase((Class)clz)) == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("failed to find implementation " + id);
                }
                return "";
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("getImplementation " + id + " => " + result);
            }
            return result;
        }
        catch (RuntimeException ex) {
            logger.log(Level.FINE, "error implementation class from id", ex);
            throw ex;
        }
    }

    String[] getImplementations(String[] ids) {
        if (ids == null) {
            return new String[0];
        }
        String[] result = new String[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            result[i] = this.getImplementation(ids[i]);
        }
        return result;
    }

    FullValueDescription meta(String repId) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(String.format("meta \"%s\"", repId));
        }
        try {
            ValueDescriptor desc = this.desc(repId);
            if (null == desc) {
                Class clz = ValueHandlerImpl.getClassFromRepositoryID(repId);
                if (clz == null) {
                    logger.warning("class not found: " + repId);
                    throw new MARSHAL(1330446337, CompletionStatus.COMPLETED_MAYBE);
                }
                desc = this.desc(clz);
            }
            return desc.getFullValueDescription();
        }
        catch (Throwable ex) {
            logger.log(Level.WARNING, "exception in meta", ex);
            throw (OBJECT_NOT_EXIST)new OBJECT_NOT_EXIST().initCause(ex);
        }
    }

    String[] getBases(String id) {
        try {
            Class clz = ValueHandlerImpl.getClassFromRepositoryID(id);
            if (clz == null) {
                return new String[0];
            }
            Class<?>[] ifaces = clz.getInterfaces();
            Class superClz = clz.getSuperclass();
            ArrayList supers = new ArrayList();
            if (superClz != java.lang.Object.class) {
                this.addIfRMIClass(supers, superClz);
            }
            for (int i = 0; i < ifaces.length; ++i) {
                this.addIfRMIClass(supers, ifaces[i]);
            }
            String[] result = new String[supers.size()];
            for (int i = 0; i < supers.size(); ++i) {
                result[i] = ((TypeDescriptor)supers.get(i)).getRepositoryID();
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("getBases " + id + " => " + result);
            }
            return result;
        }
        catch (Throwable ex) {
            logger.log(Level.WARNING, "exception in CodeBase::bases", ex);
            return new String[0];
        }
    }

    private void addIfRMIClass(List list, Class clz) {
        TypeDescriptor desc = this.repo.getDescriptor(clz);
        if (desc instanceof RemoteDescriptor) {
            list.add(desc);
        } else if (desc instanceof ValueDescriptor) {
            list.add(desc);
        }
    }

    private static enum HandlerHolder {

        static final ValueHandlerImpl value = new ValueHandlerImpl();
    }
}

