/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.json.xml;

import com.ibm.json.xml.internal.JSONSAXHandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XMLToJSONTransformer {
    private static String className = "com.ibm.json.xml.transform.XMLToJSONTransformer";
    private static Logger logger = Logger.getLogger(className, null);

    public static void transform(InputStream inputStream, OutputStream outputStream) throws SAXException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "transform(InputStream, OutputStream)");
        }
        XMLToJSONTransformer.transform(inputStream, outputStream, false);
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "transform(InputStream, OutputStream)");
        }
    }

    public static void transform(InputStream inputStream, OutputStream outputStream, boolean bl) throws SAXException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "transform(InputStream, OutputStream)");
        }
        if (inputStream == null) {
            throw new NullPointerException("XMLStream cannot be null");
        }
        if (outputStream == null) {
            throw new NullPointerException("JSONStream cannot be null");
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, className, "transform", "Fetching a SAX parser for use with JSONSAXHandler");
        }
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            JSONSAXHandler jSONSAXHandler = new JSONSAXHandler(outputStream, bl);
            xMLReader.setContentHandler((ContentHandler)jSONSAXHandler);
            xMLReader.setErrorHandler((ErrorHandler)jSONSAXHandler);
            InputSource inputSource = new InputSource(new BufferedInputStream(inputStream));
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, className, "transform", "Parsing the XML content to JSON");
            }
            inputSource.setEncoding("UTF-8");
            xMLReader.parse(inputSource);
            jSONSAXHandler.flushBuffer();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException("Could not get a parser: " + parserConfigurationException.toString());
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "transform(InputStream, OutputStream)");
        }
    }

    public static String transform(InputStream inputStream) throws SAXException, IOException {
        return XMLToJSONTransformer.transform(inputStream, false);
    }

    public static String transform(InputStream inputStream, boolean bl) throws SAXException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "transform(InputStream, boolean)");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        String string = null;
        try {
            XMLToJSONTransformer.transform(inputStream, byteArrayOutputStream, bl);
            string = byteArrayOutputStream.toString("UTF-8");
            byteArrayOutputStream.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            IOException iOException = new IOException(unsupportedEncodingException.toString());
            iOException.initCause(unsupportedEncodingException);
            throw iOException;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "transform(InputStream, boolean)");
        }
        return string;
    }

    public static String transform(File file, boolean bl) throws SAXException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "transform(InputStream, boolean)");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        String string = null;
        string = XMLToJSONTransformer.transform((InputStream)fileInputStream, bl);
        fileInputStream.close();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "transform(InputStream, boolean)");
        }
        return string;
    }

    public static String transform(File file) throws SAXException, IOException {
        return XMLToJSONTransformer.transform(file, false);
    }
}

