/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.discovery.v2.model.TrainingExample;
import com.ibm.watson.discovery.v2.model.TrainingQuery;
import java.util.ArrayList;
import java.util.List;

public class UpdateTrainingQueryOptions
extends GenericModel {
    protected String projectId;
    protected String queryId;
    protected String naturalLanguageQuery;
    protected List<TrainingExample> examples;
    protected String filter;

    protected UpdateTrainingQueryOptions() {
    }

    protected UpdateTrainingQueryOptions(Builder builder) {
        Validator.notEmpty((String)builder.projectId, (String)"projectId cannot be empty");
        Validator.notEmpty((String)builder.queryId, (String)"queryId cannot be empty");
        Validator.notNull((Object)builder.naturalLanguageQuery, (String)"naturalLanguageQuery cannot be null");
        Validator.notNull((Object)builder.examples, (String)"examples cannot be null");
        this.projectId = builder.projectId;
        this.queryId = builder.queryId;
        this.naturalLanguageQuery = builder.naturalLanguageQuery;
        this.examples = builder.examples;
        this.filter = builder.filter;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String projectId() {
        return this.projectId;
    }

    public String queryId() {
        return this.queryId;
    }

    public String naturalLanguageQuery() {
        return this.naturalLanguageQuery;
    }

    public List<TrainingExample> examples() {
        return this.examples;
    }

    public String filter() {
        return this.filter;
    }

    public static class Builder {
        private String projectId;
        private String queryId;
        private String naturalLanguageQuery;
        private List<TrainingExample> examples;
        private String filter;

        private Builder(UpdateTrainingQueryOptions updateTrainingQueryOptions) {
            this.projectId = updateTrainingQueryOptions.projectId;
            this.queryId = updateTrainingQueryOptions.queryId;
            this.naturalLanguageQuery = updateTrainingQueryOptions.naturalLanguageQuery;
            this.examples = updateTrainingQueryOptions.examples;
            this.filter = updateTrainingQueryOptions.filter;
        }

        public Builder() {
        }

        public Builder(String projectId, String queryId, String naturalLanguageQuery, List<TrainingExample> examples) {
            this.projectId = projectId;
            this.queryId = queryId;
            this.naturalLanguageQuery = naturalLanguageQuery;
            this.examples = examples;
        }

        public UpdateTrainingQueryOptions build() {
            return new UpdateTrainingQueryOptions(this);
        }

        public Builder addExamples(TrainingExample examples) {
            Validator.notNull((Object)((Object)examples), (String)"examples cannot be null");
            if (this.examples == null) {
                this.examples = new ArrayList<TrainingExample>();
            }
            this.examples.add(examples);
            return this;
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public Builder naturalLanguageQuery(String naturalLanguageQuery) {
            this.naturalLanguageQuery = naturalLanguageQuery;
            return this;
        }

        public Builder examples(List<TrainingExample> examples) {
            this.examples = examples;
            return this;
        }

        public Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public Builder trainingQuery(TrainingQuery trainingQuery) {
            this.naturalLanguageQuery = trainingQuery.naturalLanguageQuery();
            this.examples = trainingQuery.examples();
            this.filter = trainingQuery.filter();
            return this;
        }
    }
}

