/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.discovery.v2.model.CreateDocumentClassifier;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class CreateDocumentClassifierOptions
extends GenericModel {
    protected String projectId;
    protected InputStream trainingData;
    protected CreateDocumentClassifier classifier;
    protected InputStream testData;

    protected CreateDocumentClassifierOptions() {
    }

    protected CreateDocumentClassifierOptions(Builder builder) {
        Validator.notEmpty((String)builder.projectId, (String)"projectId cannot be empty");
        Validator.notNull((Object)builder.trainingData, (String)"trainingData cannot be null");
        Validator.notNull((Object)((Object)builder.classifier), (String)"classifier cannot be null");
        this.projectId = builder.projectId;
        this.trainingData = builder.trainingData;
        this.classifier = builder.classifier;
        this.testData = builder.testData;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String projectId() {
        return this.projectId;
    }

    public InputStream trainingData() {
        return this.trainingData;
    }

    public CreateDocumentClassifier classifier() {
        return this.classifier;
    }

    public InputStream testData() {
        return this.testData;
    }

    public static class Builder {
        private String projectId;
        private InputStream trainingData;
        private CreateDocumentClassifier classifier;
        private InputStream testData;

        private Builder(CreateDocumentClassifierOptions createDocumentClassifierOptions) {
            this.projectId = createDocumentClassifierOptions.projectId;
            this.trainingData = createDocumentClassifierOptions.trainingData;
            this.classifier = createDocumentClassifierOptions.classifier;
            this.testData = createDocumentClassifierOptions.testData;
        }

        public Builder() {
        }

        public Builder(String projectId, InputStream trainingData, CreateDocumentClassifier classifier) {
            this.projectId = projectId;
            this.trainingData = trainingData;
            this.classifier = classifier;
        }

        public CreateDocumentClassifierOptions build() {
            return new CreateDocumentClassifierOptions(this);
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder trainingData(InputStream trainingData) {
            this.trainingData = trainingData;
            return this;
        }

        public Builder classifier(CreateDocumentClassifier classifier) {
            this.classifier = classifier;
            return this;
        }

        public Builder testData(InputStream testData) {
            this.testData = testData;
            return this;
        }

        public Builder trainingData(File trainingData) throws FileNotFoundException {
            this.trainingData = new FileInputStream(trainingData);
            return this;
        }

        public Builder testData(File testData) throws FileNotFoundException {
            this.testData = new FileInputStream(testData);
            return this;
        }
    }
}

