/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.discovery.v1.model.Conversions;
import com.ibm.watson.discovery.v1.model.Enrichment;
import com.ibm.watson.discovery.v1.model.NormalizationOperation;
import com.ibm.watson.discovery.v1.model.Source;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Configuration
extends GenericModel {
    @SerializedName(value="configuration_id")
    protected String configurationId;
    protected String name;
    protected Date created;
    protected Date updated;
    protected String description;
    protected Conversions conversions;
    protected List<Enrichment> enrichments;
    protected List<NormalizationOperation> normalizations;
    protected Source source;

    protected Configuration() {
    }

    protected Configuration(Builder builder) {
        Validator.notNull((Object)builder.name, (String)"name cannot be null");
        this.name = builder.name;
        this.description = builder.description;
        this.conversions = builder.conversions;
        this.enrichments = builder.enrichments;
        this.normalizations = builder.normalizations;
        this.source = builder.source;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String configurationId() {
        return this.configurationId;
    }

    public String name() {
        return this.name;
    }

    public Date created() {
        return this.created;
    }

    public Date updated() {
        return this.updated;
    }

    public String description() {
        return this.description;
    }

    public Conversions conversions() {
        return this.conversions;
    }

    public List<Enrichment> enrichments() {
        return this.enrichments;
    }

    public List<NormalizationOperation> normalizations() {
        return this.normalizations;
    }

    public Source source() {
        return this.source;
    }

    public static class Builder {
        private String name;
        private String description;
        private Conversions conversions;
        private List<Enrichment> enrichments;
        private List<NormalizationOperation> normalizations;
        private Source source;

        private Builder(Configuration configuration) {
            this.name = configuration.name;
            this.description = configuration.description;
            this.conversions = configuration.conversions;
            this.enrichments = configuration.enrichments;
            this.normalizations = configuration.normalizations;
            this.source = configuration.source;
        }

        public Builder() {
        }

        public Builder(String name) {
            this.name = name;
        }

        public Configuration build() {
            return new Configuration(this);
        }

        public Builder addEnrichment(Enrichment enrichment) {
            Validator.notNull((Object)((Object)enrichment), (String)"enrichment cannot be null");
            if (this.enrichments == null) {
                this.enrichments = new ArrayList<Enrichment>();
            }
            this.enrichments.add(enrichment);
            return this;
        }

        public Builder addNormalization(NormalizationOperation normalization) {
            Validator.notNull((Object)((Object)normalization), (String)"normalization cannot be null");
            if (this.normalizations == null) {
                this.normalizations = new ArrayList<NormalizationOperation>();
            }
            this.normalizations.add(normalization);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder conversions(Conversions conversions) {
            this.conversions = conversions;
            return this;
        }

        public Builder enrichments(List<Enrichment> enrichments) {
            this.enrichments = enrichments;
            return this;
        }

        public Builder normalizations(List<NormalizationOperation> normalizations) {
            this.normalizations = normalizations;
            return this;
        }

        public Builder source(Source source) {
            this.source = source;
            return this;
        }
    }
}

