/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.visual_recognition.v3.model;

import com.ibm.watson.developer_cloud.util.Validator;
import java.io.File;

public class FindSimilarImagesOptions {
    private String collectionId;
    private File imageFile;
    private Integer limit;

    private FindSimilarImagesOptions(Builder builder) {
        this.imageFile = builder.imageFile;
        this.collectionId = builder.collectionId;
        this.limit = builder.limit;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public File image() {
        return this.imageFile;
    }

    public Integer limit() {
        return this.limit;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private String collectionId;
        private File imageFile;
        private Integer limit;

        private Builder(FindSimilarImagesOptions options) {
            this();
            this.imageFile = options.imageFile;
            this.collectionId = options.collectionId;
            this.limit = options.limit;
        }

        public Builder() {
        }

        public FindSimilarImagesOptions build() {
            Validator.isTrue((this.collectionId != null || this.imageFile != null ? 1 : 0) != 0, (String)"collectionId or imageFile should be specified");
            return new FindSimilarImagesOptions(this);
        }

        public Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public Builder image(File imageFile) {
            Validator.notNull((Object)imageFile, (String)"'imageFile' cannot be null");
            this.imageFile = imageFile;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }
    }
}

