/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.visual_recognition.v3.model;

import com.ibm.watson.developer_cloud.util.Validator;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import okhttp3.HttpUrl;

public class ClassifyImagesOptions {
    private List<String> classifierIds;
    private String imageName = "placeholder.png";
    private byte[] imagesBinary;
    private File imagesFile;
    private Double threshold;
    private HttpUrl url;

    private ClassifyImagesOptions(Builder builder) {
        this.imagesFile = builder.imagesFile;
        this.imagesBinary = builder.imagesBinary;
        this.url = builder.url;
        this.classifierIds = builder.classifierIds;
        this.threshold = builder.threshold;
        this.imageName = builder.imageName;
    }

    public List<String> classifierIds() {
        return this.classifierIds;
    }

    public String imageName() {
        return this.imageName;
    }

    public File images() {
        return this.imagesFile;
    }

    public byte[] imagesBinary() {
        return this.imagesBinary;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public Double threshold() {
        return this.threshold;
    }

    public HttpUrl url() {
        return this.url;
    }

    public static class Builder {
        private List<String> classifierIds;
        private String imageName = "placeholder.png";
        private byte[] imagesBinary;
        private File imagesFile;
        private Double threshold;
        private HttpUrl url;

        private Builder(ClassifyImagesOptions options) {
            this();
            this.imagesFile = options.imagesFile;
            this.imagesBinary = options.imagesBinary;
            this.url = options.url;
            this.classifierIds = new ArrayList<String>(options.classifierIds);
            this.threshold = options.threshold;
        }

        public Builder() {
        }

        public ClassifyImagesOptions build() {
            Validator.isTrue((this.url != null || this.imagesFile != null || this.imagesBinary != null ? 1 : 0) != 0, (String)"url or imagesFile or imagesBinary should be specified");
            return new ClassifyImagesOptions(this);
        }

        public Builder classifierIds(List<String> classifierIds) {
            this.classifierIds = classifierIds;
            return this;
        }

        public Builder classifierIds(String classifierId) {
            if (this.classifierIds == null) {
                this.classifierIds = new ArrayList<String>();
            }
            this.classifierIds.add(classifierId);
            return this;
        }

        public Builder images(byte[] imagesBinary, String imageName) {
            Validator.notNull((Object)imagesBinary, (String)"'imagesBinary' cannot be null");
            this.imagesBinary = imagesBinary;
            this.imageName = imageName;
            return this;
        }

        public Builder images(File imagesFile) {
            Validator.notNull((Object)imagesFile, (String)"'imagesFile' cannot be null");
            this.imagesFile = imagesFile;
            return this;
        }

        public Builder threshold(double threshold) {
            Validator.isTrue((threshold <= 1.0 && threshold >= 0.0 ? 1 : 0) != 0, (String)"'threshold' needs to be between 0.0 and 1.0");
            this.threshold = threshold;
            return this;
        }

        public Builder url(HttpUrl url) {
            Validator.notNull((Object)url, (String)"'url' cannot be null");
            this.url = url;
            return this;
        }

        public Builder url(String url) {
            return this.url(HttpUrl.parse((String)url));
        }
    }
}

