/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.visual_recognition.v3.model;

import com.ibm.watson.developer_cloud.util.Validator;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ClassifierOptions {
    private String classifierName;
    private File negativeExamples;
    private Map<String, File> positiveExamplesByName;

    private ClassifierOptions(Builder builder) {
        this.classifierName = builder.classifierName;
        this.negativeExamples = builder.negativeExamples;
        this.positiveExamplesByName = builder.positiveExamplesByName;
    }

    public String classifierName() {
        return this.classifierName;
    }

    public Set<String> classNames() {
        return this.positiveExamplesByName.keySet();
    }

    public File negativeExamples() {
        return this.negativeExamples;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public File positiveExamplesByClassName(String className) {
        return this.positiveExamplesByName.get(className);
    }

    public static class Builder {
        private String classifierName;
        private File negativeExamples;
        private Map<String, File> positiveExamplesByName = new HashMap<String, File>();

        private Builder(ClassifierOptions options) {
            this();
            this.classifierName = options.classifierName;
            this.negativeExamples = options.negativeExamples;
            this.positiveExamplesByName.putAll(options.positiveExamplesByName);
        }

        public Builder() {
        }

        public Builder addClass(String className, File positiveExamples) {
            Validator.notNull((Object)className, (String)"'className' cannot be null");
            Validator.notNull((Object)positiveExamples, (String)"'positiveExamples' cannot be null");
            this.positiveExamplesByName.put(className, positiveExamples);
            return this;
        }

        public ClassifierOptions build() {
            return new ClassifierOptions(this);
        }

        public Builder classifierName(String classifierName) {
            Validator.notNull((Object)classifierName, (String)"'classifierName' cannot be null");
            this.classifierName = classifierName;
            return this;
        }

        public Builder negativeExamples(File negativeExamples) {
            this.negativeExamples = negativeExamples;
            return this;
        }
    }
}

