/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.visual_recognition.v3.model;

import com.ibm.watson.developer_cloud.util.Validator;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class AddImageToCollectionOptions {
    private String collectionId;
    private File imageFile;
    private Map<String, String> metadata;

    private AddImageToCollectionOptions(Builder builder) {
        this.imageFile = builder.imageFile;
        this.collectionId = builder.collectionId;
        this.metadata = builder.metadata;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public File image() {
        return this.imageFile;
    }

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private String collectionId;
        private File imageFile;
        private Map<String, String> metadata;

        private Builder(AddImageToCollectionOptions options) {
            this();
            this.imageFile = options.imageFile;
            this.collectionId = options.collectionId;
            this.metadata = options.metadata;
        }

        public Builder() {
        }

        public AddImageToCollectionOptions build() {
            Validator.isTrue((this.collectionId != null || this.imageFile != null ? 1 : 0) != 0, (String)"collectionId or imageFile should be specified");
            return new AddImageToCollectionOptions(this);
        }

        public Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public Builder images(File imageFile) {
            Validator.notNull((Object)imageFile, (String)"'imageFile' cannot be null");
            this.imageFile = imageFile;
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder metadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }
    }
}

