/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.language_translator.v2;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import com.ibm.watson.developer_cloud.http.HttpMediaType;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.http.ResponseConverter;
import com.ibm.watson.developer_cloud.http.ServiceCall;
import com.ibm.watson.developer_cloud.language_translator.v2.model.CreateModelOptions;
import com.ibm.watson.developer_cloud.language_translator.v2.model.IdentifiableLanguage;
import com.ibm.watson.developer_cloud.language_translator.v2.model.IdentifiedLanguage;
import com.ibm.watson.developer_cloud.language_translator.v2.model.Language;
import com.ibm.watson.developer_cloud.language_translator.v2.model.TranslationModel;
import com.ibm.watson.developer_cloud.language_translator.v2.model.TranslationResult;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.util.ResponseConverterUtils;
import com.ibm.watson.developer_cloud.util.Validator;
import java.io.File;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;

public class LanguageTranslator
extends WatsonService {
    private static final String LANGUAGES = "languages";
    private static final String MODELS = "models";
    private static final String SERVICE_NAME = "language_translation";
    private static final String PATH_IDENTIFY = "/v2/identify";
    private static final String PATH_TRANSLATE = "/v2/translate";
    private static final String PATH_IDENTIFIABLE_LANGUAGES = "/v2/identifiable_languages";
    private static final String PATH_MODELS = "/v2/models";
    private static final String BASE_MODEL_ID = "base_model_id";
    private static final String DEFAULT = "default";
    private static final String FORCED_GLOSSARY = "forced_glossary";
    private static final String MODEL_ID = "model_id";
    private static final String MONOLINGUAL_CORPUS = "monolingual_corpus";
    private static final String NAME = "name";
    private static final String PARALLEL_CORPUS = "parallel_corpus";
    private static final String SOURCE = "source";
    private static final String TARGET = "target";
    private static final String TEXT = "text";
    private static final String URL = "https://gateway.watsonplatform.net/language-translator/api";
    private static final String PATH_MODEL = "/v2/models/%s";
    private static final Type TYPE_LIST_TRANSLATION_MODEL = new TypeToken<List<TranslationModel>>(){}.getType();
    private static final Type TYPE_LIST_IDENTIFIABLE_LANGUAGE = new TypeToken<List<IdentifiableLanguage>>(){}.getType();
    private static final Type TYPE_LIST_IDENTIFIED_LANGUAGE = new TypeToken<List<IdentifiedLanguage>>(){}.getType();

    public LanguageTranslator() {
        super(SERVICE_NAME);
        if (this.getEndPoint() == null || this.getEndPoint().isEmpty()) {
            this.setEndPoint(URL);
        }
    }

    public LanguageTranslator(String username, String password) {
        this();
        this.setUsernameAndPassword(username, password);
    }

    public ServiceCall<TranslationModel> createModel(CreateModelOptions options) {
        Validator.notNull((Object)options, (String)"options cannot be null");
        Validator.notEmpty((String)options.baseModelId(), (String)"options.baseModelId cannot be null or empty");
        RequestBuilder requestBuilder = RequestBuilder.post((String)PATH_MODELS);
        requestBuilder.query(new Object[]{BASE_MODEL_ID, options.baseModelId()});
        if (options.name() != null) {
            requestBuilder.query(new Object[]{NAME, options.name()});
        }
        MultipartBody.Builder bodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        if (options.forcedGlossary() != null) {
            bodyBuilder.addFormDataPart(FORCED_GLOSSARY, options.forcedGlossary().getName(), RequestBody.create((MediaType)HttpMediaType.BINARY_FILE, (File)options.forcedGlossary()));
        }
        if (options.monolingualCorpus() != null) {
            bodyBuilder.addFormDataPart(MONOLINGUAL_CORPUS, options.monolingualCorpus().getName(), RequestBody.create((MediaType)HttpMediaType.BINARY_FILE, (File)options.monolingualCorpus()));
        }
        if (options.parallelCorpus() != null) {
            bodyBuilder.addFormDataPart(PARALLEL_CORPUS, options.parallelCorpus().getName(), RequestBody.create((MediaType)HttpMediaType.BINARY_FILE, (File)options.parallelCorpus()));
        }
        return this.createServiceCall(requestBuilder.body((RequestBody)bodyBuilder.build()).build(), ResponseConverterUtils.getObject(TranslationModel.class));
    }

    public ServiceCall<Void> deleteModel(String modelId) {
        if (modelId == null || modelId.isEmpty()) {
            throw new IllegalArgumentException("modelId cannot be null or empty");
        }
        Request request = RequestBuilder.delete((String)String.format(PATH_MODEL, modelId)).build();
        return this.createServiceCall(request, ResponseConverterUtils.getVoid());
    }

    public ServiceCall<List<IdentifiableLanguage>> getIdentifiableLanguages() {
        RequestBuilder requestBuilder = RequestBuilder.get((String)PATH_IDENTIFIABLE_LANGUAGES);
        ResponseConverter converter = ResponseConverterUtils.getGenericObject((Type)TYPE_LIST_IDENTIFIABLE_LANGUAGE, (String)LANGUAGES);
        return this.createServiceCall(requestBuilder.build(), converter);
    }

    public ServiceCall<TranslationModel> getModel(String modelId) {
        Validator.isTrue((modelId != null && !modelId.isEmpty() ? 1 : 0) != 0, (String)"modelId cannot be null or empty");
        Request request = RequestBuilder.get((String)String.format(PATH_MODEL, modelId)).build();
        return this.createServiceCall(request, ResponseConverterUtils.getObject(TranslationModel.class));
    }

    public ServiceCall<List<TranslationModel>> getModels() {
        return this.getModels(null, null, null);
    }

    public ServiceCall<List<TranslationModel>> getModels(Boolean showDefault, String source, String target) {
        RequestBuilder requestBuilder = RequestBuilder.get((String)PATH_MODELS);
        if (source != null && !source.isEmpty()) {
            requestBuilder.query(new Object[]{SOURCE, source});
        }
        if (target != null && !target.isEmpty()) {
            requestBuilder.query(new Object[]{TARGET, source});
        }
        if (showDefault != null) {
            requestBuilder.query(new Object[]{DEFAULT, showDefault});
        }
        ResponseConverter converter = ResponseConverterUtils.getGenericObject((Type)TYPE_LIST_TRANSLATION_MODEL, (String)MODELS);
        return this.createServiceCall(requestBuilder.build(), converter);
    }

    public ServiceCall<List<IdentifiedLanguage>> identify(String text) {
        RequestBuilder requestBuilder = RequestBuilder.post((String)PATH_IDENTIFY).header(new Object[]{"Accept", "application/json"}).bodyContent(text, "text/plain");
        ResponseConverter converter = ResponseConverterUtils.getGenericObject((Type)TYPE_LIST_IDENTIFIED_LANGUAGE, (String)LANGUAGES);
        return this.createServiceCall(requestBuilder.build(), converter);
    }

    public ServiceCall<TranslationResult> translate(String text, String modelId) {
        return this.translate(Collections.singletonList(text), modelId);
    }

    public ServiceCall<TranslationResult> translate(String text, Language source, Language target) {
        return this.translate(Collections.singletonList(text), source, target);
    }

    public ServiceCall<TranslationResult> translate(List<String> texts, String modelId) {
        Validator.isTrue((modelId != null && !modelId.isEmpty() ? 1 : 0) != 0, (String)"modelId cannot be null or empty");
        return this.translateRequest(texts, modelId, null, null);
    }

    public ServiceCall<TranslationResult> translate(List<String> texts, Language source, Language target) {
        return this.translateRequest(texts, null, source, target);
    }

    private ServiceCall<TranslationResult> translateRequest(List<String> texts, String modelId, Language source, Language target) {
        Validator.isTrue((texts != null && !texts.isEmpty() ? 1 : 0) != 0, (String)"texts cannot be null or empty");
        JsonObject contentJson = new JsonObject();
        JsonArray paragraphs = new JsonArray();
        for (String text : texts) {
            Validator.notNull((Object)text, (String)"text cannot be null");
            paragraphs.add((JsonElement)new JsonPrimitive(text));
        }
        contentJson.add(TEXT, (JsonElement)paragraphs);
        RequestBuilder requestBuilder = RequestBuilder.post((String)PATH_TRANSLATE).header(new Object[]{"Accept", "application/json"});
        if (source != null) {
            contentJson.addProperty(SOURCE, source.toString());
        }
        if (target != null) {
            contentJson.addProperty(TARGET, target.toString());
        }
        if (modelId != null && !modelId.isEmpty()) {
            contentJson.addProperty(MODEL_ID, modelId);
        }
        requestBuilder.bodyJson(contentJson);
        return this.createServiceCall(requestBuilder.build(), ResponseConverterUtils.getObject(TranslationResult.class));
    }
}

