/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.tradeoff_analytics.v1.model.column;

import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.tradeoff_analytics.v1.util.ColumnTypeAdapter;

@JsonAdapter(value=ColumnTypeAdapter.class)
public abstract class Column
extends GenericModel {
    private String description;
    private String format;
    @SerializedName(value="full_name")
    private String fullName;
    private Goal goal;
    @SerializedName(value="insignificant_loss")
    private Double insignificantLoss;
    private String key;
    @SerializedName(value="is_objective")
    private Boolean objective;
    @SerializedName(value="significant_gain")
    private Double significantGain;
    @SerializedName(value="significant_loss")
    private Double significantLoss;
    private ColumnType type;

    public Column(ColumnType type) {
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFormat() {
        return this.format;
    }

    public String getFullName() {
        return this.fullName;
    }

    public Goal getGoal() {
        return this.goal;
    }

    public Double getInsignificantLoss() {
        return this.insignificantLoss;
    }

    public String getKey() {
        return this.key;
    }

    public Double getSignificantGain() {
        return this.significantGain;
    }

    public Double getSignificantLoss() {
        return this.significantLoss;
    }

    public ColumnType getType() {
        return this.type;
    }

    public Boolean isObjective() {
        return this.objective;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public void setGoal(Goal goal) {
        this.goal = goal;
    }

    public void setInsignificantLoss(Double insignificantLoss) {
        this.insignificantLoss = insignificantLoss;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setObjective(boolean objective) {
        this.objective = objective;
    }

    public void setSignificantGain(Double significantGain) {
        this.significantGain = significantGain;
    }

    public void setSignificantLoss(Double significantLoss) {
        this.significantLoss = significantLoss;
    }

    protected void setType(ColumnType type) {
        this.type = type;
    }

    public Column withFullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    public Column withGoal(Goal goal) {
        this.goal = goal;
        return this;
    }

    public Column withKey(String key) {
        this.key = key;
        return this;
    }

    public Column withObjective(boolean objective) {
        this.objective = objective;
        return this;
    }

    public static enum Goal {
        MAX("max"),
        MIN("min");

        private final String goal;

        public static Goal fromString(String text) {
            if (text != null) {
                for (Goal goal : Goal.values()) {
                    if (!text.equalsIgnoreCase(goal.goal)) continue;
                    return goal;
                }
            }
            return null;
        }

        private Goal(String goal) {
            this.goal = goal;
        }

        public boolean equals(String otherGoal) {
            return otherGoal == null ? false : this.goal.equals(otherGoal);
        }

        public String toString() {
            return this.goal;
        }
    }

    public static enum ColumnType {
        CATEGORICAL("categorical"),
        DATETIME("datetime"),
        NUMERIC("numeric"),
        TEXT("text");

        private final String type;

        public static ColumnType fromString(String text) {
            if (text != null) {
                for (ColumnType col : ColumnType.values()) {
                    if (!text.equalsIgnoreCase(col.type)) continue;
                    return col;
                }
            }
            return null;
        }

        private ColumnType(String columnType) {
            this.type = columnType;
        }

        public boolean equals(String otherColumnType) {
            return otherColumnType == null ? false : this.type.equals(otherColumnType);
        }

        public String toString() {
            return this.type;
        }
    }
}

