/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.text_to_speech.v1;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.text_to_speech.v1.model.Voice;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import com.ibm.watson.developer_cloud.util.Validate;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.List;

public class TextToSpeech
extends WatsonService {
    private static final String ACCEPT = "accept";
    private static final String VOICE = "voice";
    private static final String TEXT = "text";
    private static final String PATH_SYNTHESIZE = "/v1/synthesize";
    private static final Type listVoiceType = new TypeToken<List<Voice>>(){}.getType();
    private static final String URL = "https://stream.watsonplatform.net/text-to-speech/api";

    public TextToSpeech() {
        super("text_to_speech");
        this.setEndPoint(URL);
    }

    public List<Voice> getVoices() {
        Request request = RequestBuilder.get("/v1/voices").build();
        Response response = this.execute(request);
        JsonObject jsonObject = ResponseUtil.getJsonObject(response);
        List voices = (List)GsonSingleton.getGsonWithoutPrettyPrinting().fromJson(jsonObject.get("voices"), listVoiceType);
        return voices;
    }

    public InputStream synthesize(String text, String format) {
        return this.synthesize(text, Voice.EN_LISA, format);
    }

    public InputStream synthesize(String text, Voice voice) {
        return this.synthesize(text, voice, "audio/wav");
    }

    public InputStream synthesize(String text, Voice voice, String outputFormat) {
        Validate.isTrue(text != null && !text.isEmpty(), "text cannot be null or empty");
        Validate.isTrue(voice != null, "voice cannot be null or empty");
        RequestBuilder request = RequestBuilder.get(PATH_SYNTHESIZE);
        request.withQuery(TEXT, text);
        request.withQuery(VOICE, voice.getName());
        if (outputFormat != null && !outputFormat.startsWith("audio/")) {
            throw new IllegalArgumentException("format needs to be an audio mime type, for example: audio/wav or audio/ogg; codecs=opus");
        }
        request.withQuery(ACCEPT, outputFormat != null ? outputFormat : "audio/wav");
        Response response = this.execute(request.build());
        return ResponseUtil.getInputStream(response);
    }
}

