/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.speech_to_text.v1;

import com.google.gson.annotations.SerializedName;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.SpeechSession;
import com.squareup.okhttp.MediaType;
import org.apache.commons.lang3.Validate;

public class RecognizeOptions {
    @SerializedName(value="content-type")
    private String contentType;
    private Boolean continuous;
    private Integer inactivityTimeout;
    @SerializedName(value="interim_results")
    private Boolean interimResults;
    private String[] keywords;
    @SerializedName(value="keywords_threshold")
    private Double keywordsThreshold;
    private Integer maxAlternatives;
    private String model;
    private String sessionId;
    private Boolean timestamps;
    @SerializedName(value="word_alternatives_threshold")
    private Double wordAlternativesThreshold;
    @SerializedName(value="word_confidence")
    private Boolean wordConfidence;

    public RecognizeOptions continuous(Boolean continuous) {
        this.continuous = continuous;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Boolean getContinuous() {
        return this.continuous;
    }

    public Integer getInactivityTimeout() {
        return this.inactivityTimeout;
    }

    public Boolean getInterimResults() {
        return this.interimResults;
    }

    public String[] getKeywords() {
        return this.keywords;
    }

    public Double getKeywordsThreshold() {
        return this.keywordsThreshold;
    }

    public Integer getMaxAlternatives() {
        return this.maxAlternatives;
    }

    public String getModel() {
        return this.model;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Boolean getTimestamps() {
        return this.timestamps;
    }

    public Double getWordAlternativesThreshold() {
        return this.wordAlternativesThreshold;
    }

    public Boolean getWordConfidence() {
        return this.wordConfidence;
    }

    public RecognizeOptions inactivityTimeout(Integer inactivityTimeout) {
        this.inactivityTimeout = inactivityTimeout;
        return this;
    }

    public RecognizeOptions interimResults(Boolean interimResults) {
        this.interimResults = interimResults;
        return this;
    }

    public RecognizeOptions keywords(String[] keywords) {
        this.keywords = keywords;
        return this;
    }

    public RecognizeOptions keywordsThreshold(Double keywordsThreshold) {
        this.keywordsThreshold = keywordsThreshold;
        return this;
    }

    public RecognizeOptions maxAlternatives(Integer maxAlternatives) {
        this.maxAlternatives = maxAlternatives;
        return this;
    }

    public RecognizeOptions model(String model) {
        this.model = model;
        return this;
    }

    public RecognizeOptions session(SpeechSession session) {
        this.sessionId = session.getSessionId();
        return this;
    }

    public RecognizeOptions sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public RecognizeOptions timestamps(Boolean timestamps) {
        this.timestamps = timestamps;
        return this;
    }

    public RecognizeOptions wordAlternativesThreshold(Double wordAlternativesThreshold) {
        this.wordAlternativesThreshold = wordAlternativesThreshold;
        return this;
    }

    public RecognizeOptions contentType(String contentType) {
        Validate.isTrue((MediaType.parse((String)contentType) != null ? 1 : 0) != 0, (String)"contentType is not a valid mime audio format. Valid formats start with 'audio/'", (Object[])new Object[0]);
        this.contentType = contentType;
        return this;
    }

    public RecognizeOptions wordConfidence(Boolean wordConfidence) {
        this.wordConfidence = wordConfidence;
        return this;
    }
}

