/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.relationship_extraction.v1;

import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.relationship_extraction.v1.ReturnType;
import com.ibm.watson.developer_cloud.relationship_extraction.v1.model.Dataset;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import com.ibm.watson.developer_cloud.util.Validate;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;

public class RelationshipExtraction
extends WatsonService {
    private static final String URL = "https://gateway.watsonplatform.net/relationship-extraction-beta/api";
    private Dataset dataset;
    private String returnType = "xml";

    public RelationshipExtraction() {
        super("relatonship_extraction");
        this.setEndPoint(URL);
    }

    public String extract(String text) {
        Validate.notNull(this.dataset, "dataset cannot be null");
        Validate.notNull(text, "text cannot be null");
        Request request = RequestBuilder.post("/v1/sire/0").withForm("sid", this.dataset.getId(), "rt", this.returnType, "txt", text).build();
        Response response = this.execute(request);
        return ResponseUtil.getString(response);
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    public void setReturnType(ReturnType returnType) {
        if (returnType == ReturnType.XML) {
            this.returnType = "xml";
        } else if (returnType == ReturnType.JSON) {
            this.returnType = "json";
        }
    }
}

