/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.personality_insights.v2.model;

import com.ibm.watson.developer_cloud.personality_insights.v2.model.ContentItem;
import com.ibm.watson.developer_cloud.service.model.GenericModel;
import java.util.ArrayList;
import java.util.List;

public class ProfileOptions
extends GenericModel {
    private String text;
    private String contentType;
    private List<ContentItem> contentItems;
    private Boolean includeRaw;
    private AcceptLanguage acceptLanguage;
    private Language language;

    public String getText() {
        return this.text;
    }

    public String getContentType() {
        return this.contentType;
    }

    public List<ContentItem> getContentItems() {
        return this.contentItems;
    }

    public Boolean getIncludeRaw() {
        return this.includeRaw;
    }

    public AcceptLanguage getAcceptLanguage() {
        return this.acceptLanguage;
    }

    public Language getLanguage() {
        return this.language;
    }

    public ProfileOptions text(String text) {
        this.text = text;
        this.contentType = "text/plain";
        return this;
    }

    public ProfileOptions html(String html) {
        this.text = html;
        this.contentType = "text/html";
        return this;
    }

    public ProfileOptions contentItems(List<ContentItem> contentItems) {
        this.contentItems = contentItems;
        this.contentType = "application/json";
        return this;
    }

    public ProfileOptions addContentItem(ContentItem contentItem) {
        if (this.contentItems == null) {
            this.contentItems = new ArrayList<ContentItem>();
            this.contentType = "application/json";
        }
        this.contentItems.add(contentItem);
        return this;
    }

    public ProfileOptions includeRaw(boolean includeRaw) {
        this.includeRaw = includeRaw;
        return this;
    }

    public ProfileOptions language(Language language) {
        this.language = language;
        return this;
    }

    public ProfileOptions acceptLanguage(AcceptLanguage acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    public static enum AcceptLanguage {
        ENGLISH("en"),
        SPANISH("es");

        private final String text;

        private AcceptLanguage(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }

    public static enum Language {
        ENGLISH("en"),
        SPANISH("es");

        private final String text;

        private Language(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

