/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.document_conversion.v1;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.ibm.watson.developer_cloud.document_conversion.v1.model.Answers;
import com.ibm.watson.developer_cloud.document_conversion.v1.util.ConversionTarget;
import com.ibm.watson.developer_cloud.document_conversion.v1.util.ConversionUtils;
import com.ibm.watson.developer_cloud.http.HttpMediaType;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.MultipartBuilder;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DocumentConversion
extends WatsonService {
    private static final Logger LOG = Logger.getLogger(DocumentConversion.class.getName());
    private static final String CONVERSION_TARGET = "conversion_target";
    private static final String CONVERT_DOCUMENT_PATH = "/v1/convert_document";
    private static final String URL = "https://gateway.watsonplatform.net/document-conversion/api";
    private static final JsonObject EMPTY_CONFIG = new JsonParser().parse("{}").getAsJsonObject();
    public static final String VERSION_DATE_2015_12_01 = "2015-12-01";
    private final String versionDate;

    @Deprecated
    public DocumentConversion() {
        this(VERSION_DATE_2015_12_01);
    }

    public DocumentConversion(String versionDate) {
        super("document_conversion");
        this.setEndPoint(URL);
        this.versionDate = versionDate;
    }

    private InputStream convertDocument(File document, String mediaType, ConversionTarget conversionTarget, JsonObject customConfig) {
        String type;
        if (document == null || !document.exists()) {
            throw new IllegalArgumentException("document cannot be null and must exist");
        }
        if (customConfig == null) {
            throw new NullPointerException("custom config must not be null");
        }
        String string = type = mediaType != null ? mediaType : ConversionUtils.getMediaTypeFromFile(document);
        if (type == null) {
            throw new RuntimeException("mediaType cannot be null or empty");
        }
        if (!ConversionUtils.isValidMediaType(type).booleanValue()) {
            throw new IllegalArgumentException("file with the given media type is not supported");
        }
        JsonObject configJson = new JsonObject();
        for (Map.Entry entry : customConfig.entrySet()) {
            configJson.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
        configJson.addProperty(CONVERSION_TARGET, conversionTarget.toString());
        MediaType mType = MediaType.parse((String)type);
        RequestBody body = new MultipartBuilder().type(MultipartBuilder.FORM).addPart(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"config\""}), RequestBody.create((MediaType)HttpMediaType.JSON, (String)configJson.toString())).addPart(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"file\""}), RequestBody.create((MediaType)mType, (File)document)).build();
        Request request = RequestBuilder.post(CONVERT_DOCUMENT_PATH).withQuery("version", this.versionDate).withBody(body).build();
        Response response = this.execute(request);
        return ResponseUtil.getInputStream(response);
    }

    public Answers convertDocumentToAnswer(File document) {
        return this.convertDocumentToAnswer(document, null);
    }

    public Answers convertDocumentToAnswer(File document, String mediaType) {
        return this.convertDocumentToAnswer(document, mediaType, EMPTY_CONFIG);
    }

    public Answers convertDocumentToAnswer(File document, String mediaType, JsonObject customConfig) {
        InputStream is = this.convertDocument(document, mediaType, ConversionTarget.ANSWER_UNITS, customConfig);
        String convertedDocument = this.responseToString(is);
        return (Answers)GsonSingleton.getGsonWithoutPrettyPrinting().fromJson(convertedDocument, Answers.class);
    }

    public String convertDocumentToHTML(File document) {
        return this.convertDocumentToHTML(document, null);
    }

    public String convertDocumentToHTML(File document, String mediaType) {
        return this.convertDocumentToHTML(document, mediaType, EMPTY_CONFIG);
    }

    public String convertDocumentToHTML(File document, String mediaType, JsonObject customConfig) {
        InputStream is = this.convertDocument(document, mediaType, ConversionTarget.NORMALIZED_HTML, customConfig);
        return this.responseToString(is);
    }

    public String convertDocumentToText(File document) {
        return this.convertDocumentToText(document, null);
    }

    public String convertDocumentToText(File document, String mediaType) {
        return this.convertDocumentToText(document, mediaType, EMPTY_CONFIG);
    }

    public String convertDocumentToText(File document, String mediaType, JsonObject customConfig) {
        InputStream is = this.convertDocument(document, mediaType, ConversionTarget.NORMALIZED_TEXT, customConfig);
        return this.responseToString(is);
    }

    public JsonObject loadCustomConfig(InputStream customConfig) {
        InputStreamReader reader = new InputStreamReader(customConfig);
        return new JsonParser().parse((Reader)reader).getAsJsonObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String responseToString(InputStream is) {
        try {
            String string = ConversionUtils.writeInputStreamToString(is);
            return string;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Unable to close document input stream", e);
            }
        }
    }
}

