/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.concept_insights.v2.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.AccountPermission;
import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validate;
import java.util.List;

public class Corpus
extends GenericModel {
    public static final Corpus IBM_RESEARCHERS = new Corpus("public", "ibmresearcher");
    public static final Corpus TED_TALKS = new Corpus("public", "TEDTalks");
    public static final String ACCESS_PUBLIC = "public";
    private String access;
    @SerializedName(value="users")
    private List<AccountPermission> accountPermissions;
    private String id;
    private String name;
    @SerializedName(value="ttl_hours")
    private Integer ttlInHours;
    @SerializedName(value="expires_on")
    private String expiresOn;

    public Integer getTtlInHours() {
        return this.ttlInHours;
    }

    public void setTtlInHours(Integer ttlInHours) {
        this.ttlInHours = ttlInHours;
    }

    public String getExpiresOn() {
        return this.expiresOn;
    }

    public void setExpiresOn(String expiresOn) {
        this.expiresOn = expiresOn;
    }

    public Corpus() {
    }

    public Corpus(String accountId, String name) {
        Validate.notEmpty(accountId, "accountId cannot be empty");
        Validate.notEmpty(name, "name cannot be empty");
        this.setName(name);
        this.setId("/corpora/" + accountId + "/" + name);
    }

    public String getAccess() {
        return this.access;
    }

    public List<AccountPermission> getAccountPermissions() {
        return this.accountPermissions;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setAccess(String access) {
        this.access = access;
    }

    public void setAccountPermissions(List<AccountPermission> accountPermissions) {
        this.accountPermissions = accountPermissions;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Corpus withName(String name) {
        this.setName(name);
        return this;
    }
}

