/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.concept_expansion.v1;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.ibm.watson.developer_cloud.concept_expansion.v1.model.Concept;
import com.ibm.watson.developer_cloud.concept_expansion.v1.model.Dataset;
import com.ibm.watson.developer_cloud.concept_expansion.v1.model.Job;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import com.ibm.watson.developer_cloud.util.Validate;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.util.ArrayList;
import java.util.List;

public class ConceptExpansion
extends WatsonService {
    private static final String DATASET = "dataset";
    private static final String LABEL = "label";
    private static final String PARAM_JOBID = "jobid";
    private static final String PARAM_STATE = "state";
    private static final String PREVALENCE = "prevalence";
    private static final String RESULT = "result";
    private static final String RETURN_SEEDS = "return_seeds";
    private static final String SEEDS = "seeds";
    private static String URL = "https://gateway.watsonplatform.net/concept-expansion-beta/api";
    private static final String V1_RESULT = "/v1/result";
    private static final String V1_STATUS = "/v1/status";
    private static final String V1_UPLOAD = "/v1/upload";
    private Dataset dataset;

    public ConceptExpansion() {
        super("concept_expansion");
        this.setEndPoint(URL);
        this.setDataset(Dataset.MT_SAMPLES);
    }

    public Job createJob(String[] seeds) {
        return this.createJob(null, seeds);
    }

    public Job createJob(String label, String[] seeds) {
        Validate.notEmpty(seeds, "seeds cannot be null or empty");
        Validate.notNull(this.dataset, "dataset cannot be null");
        JsonArray seedJsonArray = new JsonArray();
        for (String seed : seeds) {
            seedJsonArray.add((JsonElement)new JsonPrimitive(seed));
        }
        JsonObject payload = new JsonObject();
        payload.addProperty(LABEL, label);
        payload.addProperty(DATASET, this.dataset.getId());
        payload.add(SEEDS, (JsonElement)seedJsonArray);
        Request request = RequestBuilder.post(V1_UPLOAD).withBodyJson(payload).build();
        return this.executeRequest(request, Job.class);
    }

    private Concept formatConcept(JsonObject conceptJson) {
        return new Concept(conceptJson.get(RESULT).getAsString(), conceptJson.get(PREVALENCE).getAsDouble());
    }

    private List<Concept> formatConcepts(JsonObject conceptsJson) {
        JsonArray conceptArray = conceptsJson.get(RETURN_SEEDS).getAsJsonArray();
        ArrayList<Concept> concepts = new ArrayList<Concept>();
        for (JsonElement conceptJson : conceptArray) {
            concepts.add(this.formatConcept(conceptJson.getAsJsonObject()));
        }
        return concepts;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public List<Concept> getJobResult(Job job) {
        Validate.notNull(job, "job cannot be null");
        JsonObject payload = new JsonObject();
        payload.addProperty(PARAM_JOBID, job.getId());
        Request request = RequestBuilder.put(V1_RESULT).withBodyJson(payload).build();
        String resultAsString = ResponseUtil.getString(this.execute(request));
        return this.formatConcepts(new JsonParser().parse(resultAsString).getAsJsonObject());
    }

    public Job.Status getJobStatus(Job job) {
        Validate.notNull(job, "job cannot be null");
        Request request = RequestBuilder.get(V1_STATUS).withQuery(PARAM_JOBID, job.getId()).build();
        Response response = this.execute(request);
        JsonObject jsonObject = ResponseUtil.getJsonObject(response);
        return Job.Status.fromString(jsonObject.get(PARAM_STATE).getAsString());
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }
}

