/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.android.library.audio;

import android.media.AudioTrack;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public final class StreamPlayer {
    private final String TAG = "StreamPlayer";
    private AudioTrack audioTrack;
    private int sampleRate;

    private static byte[] convertStreamToByteArray(InputStream is) throws IOException {
        int i;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buff = new byte[10240];
        while ((i = is.read(buff, 0, buff.length)) > 0) {
            baos.write(buff, 0, i);
        }
        return baos.toByteArray();
    }

    private static int readInt(byte[] data, int offset) {
        return data[offset] & 0xFF | (data[offset + 1] & 0xFF) << 8 | (data[offset + 2] & 0xFF) << 16 | data[offset + 3] << 24;
    }

    public void playStream(InputStream stream) {
        try {
            byte[] data = StreamPlayer.convertStreamToByteArray(stream);
            if (data.length > 28) {
                this.sampleRate = StreamPlayer.readInt(data, 24);
            }
            int headSize = 44;
            int metaDataSize = 48;
            int destPos = headSize + metaDataSize;
            int rawLength = data.length - destPos;
            byte[] d = new byte[rawLength];
            System.arraycopy(data, destPos, d, 0, rawLength);
            this.initPlayer();
            this.audioTrack.write(d, 0, d.length);
            stream.close();
            if (this.audioTrack != null && this.audioTrack.getState() != 0) {
                this.audioTrack.release();
            }
        }
        catch (IOException e2) {
            Log.e((String)"StreamPlayer", (String)e2.getMessage());
        }
    }

    public void interrupt() {
        if (this.audioTrack != null) {
            if (this.audioTrack.getState() == 1 || this.audioTrack.getState() == 3) {
                this.audioTrack.pause();
            }
            this.audioTrack.flush();
            this.audioTrack.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPlayer() {
        StreamPlayer streamPlayer = this;
        synchronized (streamPlayer) {
            int bs = AudioTrack.getMinBufferSize((int)this.sampleRate, (int)4, (int)2);
            this.audioTrack = new AudioTrack(3, this.sampleRate, 4, 2, bs, 1);
            if (this.audioTrack != null) {
                this.audioTrack.play();
            }
        }
    }
}

