/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.android.library.audio.opus;

import com.ibm.watson.developer_cloud.android.library.audio.AudioConsumer;
import com.ibm.watson.developer_cloud.android.library.audio.AudioFileWriter;
import com.ibm.watson.developer_cloud.android.library.audio.opus.OggCrc;
import java.io.File;
import java.io.IOException;
import java.util.Random;

public class OpusWriter
extends AudioFileWriter {
    private String TAG = this.getClass().getSimpleName();
    public static final int PACKETS_PER_OGG_PAGE = 50;
    protected int sampleRate;
    protected int streamSerialNumber;
    private byte[] dataBuffer;
    private int dataBufferPtr;
    private byte[] headerBuffer;
    private int headerBufferPtr;
    protected int pageCount;
    private int packetCount;
    private long granulepos;
    private int frameSize;
    public AudioConsumer audioConsumer;

    public OpusWriter() {
    }

    public OpusWriter(AudioConsumer ac) {
        this.audioConsumer = ac;
        if (this.streamSerialNumber == 0) {
            this.streamSerialNumber = new Random().nextInt();
        }
        this.dataBuffer = new byte[65565];
        this.dataBufferPtr = 0;
        this.headerBuffer = new byte[255];
        this.headerBufferPtr = 0;
        this.pageCount = 0;
        this.packetCount = 0;
        this.granulepos = 0L;
        this.sampleRate = 16000;
        this.frameSize = 160;
    }

    @Override
    public void close() throws IOException {
        this.flush(true);
    }

    @Override
    public void open(File file) throws IOException {
    }

    @Override
    public void open(String filename) throws IOException {
    }

    @Override
    public void writeHeader(String comment) {
        byte[] header = OpusWriter.buildOggPageHeader(2, 0L, this.streamSerialNumber, this.pageCount++, 1, new byte[]{19});
        byte[] data = OpusWriter.buildOpusHeader(this.sampleRate);
        int chkSum = OggCrc.checksum(0, header, 0, header.length);
        chkSum = OggCrc.checksum(chkSum, data, 0, data.length);
        OpusWriter.writeInt(header, 22, chkSum);
        this.write(header);
        this.write(data);
        header = OpusWriter.buildOggPageHeader(0, 0L, this.streamSerialNumber, this.pageCount++, 1, new byte[]{(byte)(comment.length() + 8)});
        data = OpusWriter.buildOpusComment(comment);
        chkSum = OggCrc.checksum(0, header, 0, header.length);
        chkSum = OggCrc.checksum(chkSum, data, 0, data.length);
        OpusWriter.writeInt(header, 22, chkSum);
        this.write(header);
        this.write(data);
    }

    @Override
    public void writePacket(byte[] data, int offset, int len) throws IOException {
        if (len <= 0) {
            return;
        }
        if (this.packetCount > 50) {
            this.flush(false);
        }
        System.arraycopy(data, offset, this.dataBuffer, this.dataBufferPtr, len);
        this.dataBufferPtr += len;
        this.headerBuffer[this.headerBufferPtr++] = (byte)len;
        ++this.packetCount;
        this.granulepos += (long)(this.frameSize * 2);
    }

    protected void flush(boolean eos) throws IOException {
        byte[] header = OpusWriter.buildOggPageHeader(eos ? 4 : 0, this.granulepos, this.streamSerialNumber, this.pageCount++, this.packetCount, this.headerBuffer);
        int chksum = OggCrc.checksum(0, header, 0, header.length);
        chksum = OggCrc.checksum(chksum, this.dataBuffer, 0, this.dataBufferPtr);
        OpusWriter.writeInt(header, 22, chksum);
        this.write(header);
        this.write(this.dataBuffer, 0, this.dataBufferPtr);
        this.dataBufferPtr = 0;
        this.headerBufferPtr = 0;
        this.packetCount = 0;
    }

    public void write(byte[] data) {
        this.audioConsumer.consume(data);
    }

    public void write(byte[] data, int offset, int count) {
        byte[] tmp = new byte[count];
        System.arraycopy(data, offset, tmp, 0, count);
        this.audioConsumer.consume(tmp);
    }
}

