/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.android.library.audio.opus;

import com.ibm.watson.developer_cloud.android.library.audio.AudioConsumer;
import com.ibm.watson.developer_cloud.android.library.audio.opus.JNAOpus;
import com.ibm.watson.developer_cloud.android.library.audio.opus.OpusWriter;
import com.sun.jna.ptr.PointerByReference;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public class OggOpusEnc
extends OpusWriter {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corp. 2015";
    private OpusWriter writer = null;
    private PointerByReference opusEncoder;

    public OggOpusEnc(AudioConsumer ac) throws IOException {
        this.initEncoder(ac);
    }

    public void initEncoder(AudioConsumer ac) throws IOException {
        this.writer = new OpusWriter(ac);
        IntBuffer error = IntBuffer.allocate(4);
        this.opusEncoder = JNAOpus.INSTANCE.opus_encoder_create(16000, 1, 2048, error);
    }

    public void onStart() {
        this.writer.writeHeader("encoder=Lavc56.20.100 libopus");
    }

    public int encodeAndWrite(byte[] rawAudio) throws IOException {
        int read;
        int uploadedAudioSize = 0;
        ByteArrayInputStream ios = new ByteArrayInputStream(rawAudio);
        byte[] data = new byte[320];
        while ((read = ios.read(data)) > 0) {
            int bufferSize = read;
            byte[] pcmBuffer = new byte[read];
            System.arraycopy(data, 0, pcmBuffer, 0, read);
            ShortBuffer shortBuffer = ShortBuffer.allocate(bufferSize);
            for (int i = 0; i < read; i += 2) {
                int b1 = pcmBuffer[i] & 0xFF;
                int b2 = pcmBuffer[i + 1] << 8;
                shortBuffer.put((short)(b1 | b2));
            }
            shortBuffer.flip();
            ByteBuffer opusBuffer = ByteBuffer.allocate(bufferSize);
            int opus_encoded = JNAOpus.INSTANCE.opus_encode(this.opusEncoder, shortBuffer, 160, opusBuffer, bufferSize);
            opusBuffer.position(opus_encoded);
            opusBuffer.flip();
            byte[] opusData = new byte[opusBuffer.remaining()];
            opusBuffer.get(opusData, 0, opusData.length);
            if (opus_encoded <= 0) continue;
            System.out.println("This is where I'd write some data. " + (uploadedAudioSize += opusData.length) + " to be specific.");
            this.writer.writePacket(opusData, 0, opusData.length);
        }
        ios.close();
        return uploadedAudioSize;
    }

    @Override
    public void close() {
        try {
            this.writer.close();
            JNAOpus.INSTANCE.opus_encoder_destroy(this.opusEncoder);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

