/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v2.model.MessageContextStateless;
import com.ibm.watson.assistant.v2.model.MessageInputStateless;

public class MessageStatelessOptions
extends GenericModel {
    protected String assistantId;
    protected MessageInputStateless input;
    protected MessageContextStateless context;
    protected String userId;

    protected MessageStatelessOptions() {
    }

    protected MessageStatelessOptions(Builder builder) {
        Validator.notEmpty((String)builder.assistantId, (String)"assistantId cannot be empty");
        this.assistantId = builder.assistantId;
        this.input = builder.input;
        this.context = builder.context;
        this.userId = builder.userId;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String assistantId() {
        return this.assistantId;
    }

    public MessageInputStateless input() {
        return this.input;
    }

    public MessageContextStateless context() {
        return this.context;
    }

    public String userId() {
        return this.userId;
    }

    public static class Builder {
        private String assistantId;
        private MessageInputStateless input;
        private MessageContextStateless context;
        private String userId;

        private Builder(MessageStatelessOptions messageStatelessOptions) {
            this.assistantId = messageStatelessOptions.assistantId;
            this.input = messageStatelessOptions.input;
            this.context = messageStatelessOptions.context;
            this.userId = messageStatelessOptions.userId;
        }

        public Builder() {
        }

        public Builder(String assistantId) {
            this.assistantId = assistantId;
        }

        public MessageStatelessOptions build() {
            return new MessageStatelessOptions(this);
        }

        public Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public Builder input(MessageInputStateless input) {
            this.input = input;
            return this;
        }

        public Builder context(MessageContextStateless context) {
            this.context = context;
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }
    }
}

