/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class ListReleasesOptions
extends GenericModel {
    protected String assistantId;
    protected Long pageLimit;
    protected Boolean includeCount;
    protected String sort;
    protected String cursor;
    protected Boolean includeAudit;

    protected ListReleasesOptions() {
    }

    protected ListReleasesOptions(Builder builder) {
        Validator.notEmpty((String)builder.assistantId, (String)"assistantId cannot be empty");
        this.assistantId = builder.assistantId;
        this.pageLimit = builder.pageLimit;
        this.includeCount = builder.includeCount;
        this.sort = builder.sort;
        this.cursor = builder.cursor;
        this.includeAudit = builder.includeAudit;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String assistantId() {
        return this.assistantId;
    }

    public Long pageLimit() {
        return this.pageLimit;
    }

    public Boolean includeCount() {
        return this.includeCount;
    }

    public String sort() {
        return this.sort;
    }

    public String cursor() {
        return this.cursor;
    }

    public Boolean includeAudit() {
        return this.includeAudit;
    }

    public static class Builder {
        private String assistantId;
        private Long pageLimit;
        private Boolean includeCount;
        private String sort;
        private String cursor;
        private Boolean includeAudit;

        private Builder(ListReleasesOptions listReleasesOptions) {
            this.assistantId = listReleasesOptions.assistantId;
            this.pageLimit = listReleasesOptions.pageLimit;
            this.includeCount = listReleasesOptions.includeCount;
            this.sort = listReleasesOptions.sort;
            this.cursor = listReleasesOptions.cursor;
            this.includeAudit = listReleasesOptions.includeAudit;
        }

        public Builder() {
        }

        public Builder(String assistantId) {
            this.assistantId = assistantId;
        }

        public ListReleasesOptions build() {
            return new ListReleasesOptions(this);
        }

        public Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public Builder pageLimit(long pageLimit) {
            this.pageLimit = pageLimit;
            return this;
        }

        public Builder includeCount(Boolean includeCount) {
            this.includeCount = includeCount;
            return this;
        }

        public Builder sort(String sort) {
            this.sort = sort;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder includeAudit(Boolean includeAudit) {
            this.includeAudit = includeAudit;
            return this;
        }
    }

    public static interface Sort {
        public static final String NAME = "name";
        public static final String UPDATED = "updated";
    }
}

