/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v2.model.RequestAnalytics;

public class CreateSessionOptions
extends GenericModel {
    protected String assistantId;
    protected RequestAnalytics analytics;

    protected CreateSessionOptions() {
    }

    protected CreateSessionOptions(Builder builder) {
        Validator.notEmpty((String)builder.assistantId, (String)"assistantId cannot be empty");
        this.assistantId = builder.assistantId;
        this.analytics = builder.analytics;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String assistantId() {
        return this.assistantId;
    }

    public RequestAnalytics analytics() {
        return this.analytics;
    }

    public static class Builder {
        private String assistantId;
        private RequestAnalytics analytics;

        private Builder(CreateSessionOptions createSessionOptions) {
            this.assistantId = createSessionOptions.assistantId;
            this.analytics = createSessionOptions.analytics;
        }

        public Builder() {
        }

        public Builder(String assistantId) {
            this.assistantId = assistantId;
        }

        public CreateSessionOptions build() {
            return new CreateSessionOptions(this);
        }

        public Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public Builder analytics(RequestAnalytics analytics) {
            this.analytics = analytics;
            return this;
        }
    }
}

