/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v2.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v2.model.AssistantSkill;
import com.ibm.watson.assistant.v2.model.EnvironmentReference;
import java.util.List;

public class AssistantData
extends GenericModel {
    @SerializedName(value="assistant_id")
    protected String assistantId;
    protected String name;
    protected String description;
    protected String language;
    @SerializedName(value="assistant_skills")
    protected List<AssistantSkill> assistantSkills;
    @SerializedName(value="assistant_environments")
    protected List<EnvironmentReference> assistantEnvironments;

    protected AssistantData() {
    }

    protected AssistantData(Builder builder) {
        Validator.notNull((Object)builder.language, (String)"language cannot be null");
        this.name = builder.name;
        this.description = builder.description;
        this.language = builder.language;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String assistantId() {
        return this.assistantId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String language() {
        return this.language;
    }

    public List<AssistantSkill> assistantSkills() {
        return this.assistantSkills;
    }

    public List<EnvironmentReference> assistantEnvironments() {
        return this.assistantEnvironments;
    }

    public static class Builder {
        private String name;
        private String description;
        private String language;

        private Builder(AssistantData assistantData) {
            this.name = assistantData.name;
            this.description = assistantData.description;
            this.language = assistantData.language;
        }

        public Builder() {
        }

        public Builder(String language) {
            this.language = language;
        }

        public AssistantData build() {
            return new AssistantData(this);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }
    }
}

