/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v1.model.Context;
import com.ibm.watson.assistant.v1.model.DialogNodeAction;
import com.ibm.watson.assistant.v1.model.MessageInput;
import com.ibm.watson.assistant.v1.model.OutputData;
import com.ibm.watson.assistant.v1.model.RuntimeEntity;
import com.ibm.watson.assistant.v1.model.RuntimeIntent;
import java.util.ArrayList;
import java.util.List;

public class MessageRequest
extends GenericModel {
    protected MessageInput input;
    protected List<RuntimeIntent> intents;
    protected List<RuntimeEntity> entities;
    @SerializedName(value="alternate_intents")
    protected Boolean alternateIntents;
    protected Context context;
    protected OutputData output;
    protected List<DialogNodeAction> actions;
    @SerializedName(value="user_id")
    protected String userId;

    protected MessageRequest() {
    }

    protected MessageRequest(Builder builder) {
        this.input = builder.input;
        this.intents = builder.intents;
        this.entities = builder.entities;
        this.alternateIntents = builder.alternateIntents;
        this.context = builder.context;
        this.output = builder.output;
        this.userId = builder.userId;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public MessageInput input() {
        return this.input;
    }

    public List<RuntimeIntent> intents() {
        return this.intents;
    }

    public List<RuntimeEntity> entities() {
        return this.entities;
    }

    public Boolean alternateIntents() {
        return this.alternateIntents;
    }

    public Context context() {
        return this.context;
    }

    public OutputData output() {
        return this.output;
    }

    public List<DialogNodeAction> actions() {
        return this.actions;
    }

    public String userId() {
        return this.userId;
    }

    public static class Builder {
        private MessageInput input;
        private List<RuntimeIntent> intents;
        private List<RuntimeEntity> entities;
        private Boolean alternateIntents;
        private Context context;
        private OutputData output;
        private String userId;

        private Builder(MessageRequest messageRequest) {
            this.input = messageRequest.input;
            this.intents = messageRequest.intents;
            this.entities = messageRequest.entities;
            this.alternateIntents = messageRequest.alternateIntents;
            this.context = messageRequest.context;
            this.output = messageRequest.output;
            this.userId = messageRequest.userId;
        }

        public Builder() {
        }

        public MessageRequest build() {
            return new MessageRequest(this);
        }

        public Builder addIntent(RuntimeIntent intent) {
            Validator.notNull((Object)((Object)intent), (String)"intent cannot be null");
            if (this.intents == null) {
                this.intents = new ArrayList<RuntimeIntent>();
            }
            this.intents.add(intent);
            return this;
        }

        public Builder addEntity(RuntimeEntity entity) {
            Validator.notNull((Object)((Object)entity), (String)"entity cannot be null");
            if (this.entities == null) {
                this.entities = new ArrayList<RuntimeEntity>();
            }
            this.entities.add(entity);
            return this;
        }

        public Builder input(MessageInput input) {
            this.input = input;
            return this;
        }

        public Builder intents(List<RuntimeIntent> intents) {
            this.intents = intents;
            return this;
        }

        public Builder entities(List<RuntimeEntity> entities) {
            this.entities = entities;
            return this;
        }

        public Builder alternateIntents(Boolean alternateIntents) {
            this.alternateIntents = alternateIntents;
            return this;
        }

        public Builder context(Context context) {
            this.context = context;
            return this;
        }

        public Builder output(OutputData output) {
            this.output = output;
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }
    }
}

