/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v1.model;

import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.sdk.core.service.model.DynamicModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.HashMap;
import java.util.Map;

public class MessageInput
extends DynamicModel<Object> {
    @SerializedName(value="text")
    protected String text;
    @SerializedName(value="spelling_suggestions")
    protected Boolean spellingSuggestions;
    @SerializedName(value="spelling_auto_correct")
    protected Boolean spellingAutoCorrect;
    @SerializedName(value="suggested_text")
    protected String suggestedText;
    @SerializedName(value="original_text")
    protected String originalText;

    public MessageInput() {
        super((TypeToken)new TypeToken<Object>(){});
    }

    protected MessageInput(Builder builder) {
        super((TypeToken)new TypeToken<Object>(){});
        this.text = builder.text;
        this.spellingSuggestions = builder.spellingSuggestions;
        this.spellingAutoCorrect = builder.spellingAutoCorrect;
        this.setProperties(builder.dynamicProperties);
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Boolean isSpellingSuggestions() {
        return this.spellingSuggestions;
    }

    public void setSpellingSuggestions(Boolean spellingSuggestions) {
        this.spellingSuggestions = spellingSuggestions;
    }

    public Boolean isSpellingAutoCorrect() {
        return this.spellingAutoCorrect;
    }

    public void setSpellingAutoCorrect(Boolean spellingAutoCorrect) {
        this.spellingAutoCorrect = spellingAutoCorrect;
    }

    public String getSuggestedText() {
        return this.suggestedText;
    }

    public String getOriginalText() {
        return this.originalText;
    }

    public static class Builder {
        private String text;
        private Boolean spellingSuggestions;
        private Boolean spellingAutoCorrect;
        private Map<String, Object> dynamicProperties;

        private Builder(MessageInput messageInput) {
            this.text = messageInput.text;
            this.spellingSuggestions = messageInput.spellingSuggestions;
            this.spellingAutoCorrect = messageInput.spellingAutoCorrect;
            this.dynamicProperties = messageInput.getProperties();
        }

        public Builder() {
        }

        public MessageInput build() {
            return new MessageInput(this);
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder spellingSuggestions(Boolean spellingSuggestions) {
            this.spellingSuggestions = spellingSuggestions;
            return this;
        }

        public Builder spellingAutoCorrect(Boolean spellingAutoCorrect) {
            this.spellingAutoCorrect = spellingAutoCorrect;
            return this;
        }

        public Builder add(String name, Object value) {
            Validator.notNull((Object)name, (String)"name cannot be null");
            if (this.dynamicProperties == null) {
                this.dynamicProperties = new HashMap<String, Object>();
            }
            this.dynamicProperties.put(name, value);
            return this;
        }
    }
}

