/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v1.model;

import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.sdk.core.service.model.DynamicModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v1.model.MessageContextMetadata;
import java.util.HashMap;
import java.util.Map;

public class Context
extends DynamicModel<Object> {
    @SerializedName(value="conversation_id")
    protected String conversationId;
    @SerializedName(value="system")
    protected Map<String, Object> system;
    @SerializedName(value="metadata")
    protected MessageContextMetadata metadata;

    public Context() {
        super((TypeToken)new TypeToken<Object>(){});
    }

    protected Context(Builder builder) {
        super((TypeToken)new TypeToken<Object>(){});
        this.conversationId = builder.conversationId;
        this.system = builder.system;
        this.metadata = builder.metadata;
        this.setProperties(builder.dynamicProperties);
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public Map<String, Object> getSystem() {
        return this.system;
    }

    public void setSystem(Map<String, Object> system) {
        this.system = system;
    }

    public MessageContextMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(MessageContextMetadata metadata) {
        this.metadata = metadata;
    }

    public static class Builder {
        private String conversationId;
        private Map<String, Object> system;
        private MessageContextMetadata metadata;
        private Map<String, Object> dynamicProperties;

        private Builder(Context context) {
            this.conversationId = context.conversationId;
            this.system = context.system;
            this.metadata = context.metadata;
            this.dynamicProperties = context.getProperties();
        }

        public Builder() {
        }

        public Context build() {
            return new Context(this);
        }

        public Builder conversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public Builder system(Map<String, Object> system) {
            this.system = system;
            return this;
        }

        public Builder metadata(MessageContextMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder add(String name, Object value) {
            Validator.notNull((Object)name, (String)"name cannot be null");
            if (this.dynamicProperties == null) {
                this.dynamicProperties = new HashMap<String, Object>();
            }
            this.dynamicProperties.put(name, value);
            return this;
        }
    }
}

