/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v1;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.ConfigBasedAuthenticatorFactory;
import com.ibm.cloud.sdk.core.service.BaseService;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v1.model.BulkClassifyOptions;
import com.ibm.watson.assistant.v1.model.BulkClassifyResponse;
import com.ibm.watson.assistant.v1.model.Counterexample;
import com.ibm.watson.assistant.v1.model.CounterexampleCollection;
import com.ibm.watson.assistant.v1.model.CreateCounterexampleOptions;
import com.ibm.watson.assistant.v1.model.CreateDialogNodeOptions;
import com.ibm.watson.assistant.v1.model.CreateEntityOptions;
import com.ibm.watson.assistant.v1.model.CreateExampleOptions;
import com.ibm.watson.assistant.v1.model.CreateIntentOptions;
import com.ibm.watson.assistant.v1.model.CreateSynonymOptions;
import com.ibm.watson.assistant.v1.model.CreateValueOptions;
import com.ibm.watson.assistant.v1.model.CreateWorkspaceAsyncOptions;
import com.ibm.watson.assistant.v1.model.CreateWorkspaceOptions;
import com.ibm.watson.assistant.v1.model.DeleteCounterexampleOptions;
import com.ibm.watson.assistant.v1.model.DeleteDialogNodeOptions;
import com.ibm.watson.assistant.v1.model.DeleteEntityOptions;
import com.ibm.watson.assistant.v1.model.DeleteExampleOptions;
import com.ibm.watson.assistant.v1.model.DeleteIntentOptions;
import com.ibm.watson.assistant.v1.model.DeleteSynonymOptions;
import com.ibm.watson.assistant.v1.model.DeleteUserDataOptions;
import com.ibm.watson.assistant.v1.model.DeleteValueOptions;
import com.ibm.watson.assistant.v1.model.DeleteWorkspaceOptions;
import com.ibm.watson.assistant.v1.model.DialogNode;
import com.ibm.watson.assistant.v1.model.DialogNodeCollection;
import com.ibm.watson.assistant.v1.model.Entity;
import com.ibm.watson.assistant.v1.model.EntityCollection;
import com.ibm.watson.assistant.v1.model.EntityMentionCollection;
import com.ibm.watson.assistant.v1.model.Example;
import com.ibm.watson.assistant.v1.model.ExampleCollection;
import com.ibm.watson.assistant.v1.model.ExportWorkspaceAsyncOptions;
import com.ibm.watson.assistant.v1.model.GetCounterexampleOptions;
import com.ibm.watson.assistant.v1.model.GetDialogNodeOptions;
import com.ibm.watson.assistant.v1.model.GetEntityOptions;
import com.ibm.watson.assistant.v1.model.GetExampleOptions;
import com.ibm.watson.assistant.v1.model.GetIntentOptions;
import com.ibm.watson.assistant.v1.model.GetSynonymOptions;
import com.ibm.watson.assistant.v1.model.GetValueOptions;
import com.ibm.watson.assistant.v1.model.GetWorkspaceOptions;
import com.ibm.watson.assistant.v1.model.Intent;
import com.ibm.watson.assistant.v1.model.IntentCollection;
import com.ibm.watson.assistant.v1.model.ListAllLogsOptions;
import com.ibm.watson.assistant.v1.model.ListCounterexamplesOptions;
import com.ibm.watson.assistant.v1.model.ListDialogNodesOptions;
import com.ibm.watson.assistant.v1.model.ListEntitiesOptions;
import com.ibm.watson.assistant.v1.model.ListExamplesOptions;
import com.ibm.watson.assistant.v1.model.ListIntentsOptions;
import com.ibm.watson.assistant.v1.model.ListLogsOptions;
import com.ibm.watson.assistant.v1.model.ListMentionsOptions;
import com.ibm.watson.assistant.v1.model.ListSynonymsOptions;
import com.ibm.watson.assistant.v1.model.ListValuesOptions;
import com.ibm.watson.assistant.v1.model.ListWorkspacesOptions;
import com.ibm.watson.assistant.v1.model.LogCollection;
import com.ibm.watson.assistant.v1.model.MessageOptions;
import com.ibm.watson.assistant.v1.model.MessageResponse;
import com.ibm.watson.assistant.v1.model.Synonym;
import com.ibm.watson.assistant.v1.model.SynonymCollection;
import com.ibm.watson.assistant.v1.model.UpdateCounterexampleOptions;
import com.ibm.watson.assistant.v1.model.UpdateDialogNodeNullableOptions;
import com.ibm.watson.assistant.v1.model.UpdateDialogNodeOptions;
import com.ibm.watson.assistant.v1.model.UpdateEntityOptions;
import com.ibm.watson.assistant.v1.model.UpdateExampleOptions;
import com.ibm.watson.assistant.v1.model.UpdateIntentOptions;
import com.ibm.watson.assistant.v1.model.UpdateSynonymOptions;
import com.ibm.watson.assistant.v1.model.UpdateValueOptions;
import com.ibm.watson.assistant.v1.model.UpdateWorkspaceAsyncOptions;
import com.ibm.watson.assistant.v1.model.UpdateWorkspaceOptions;
import com.ibm.watson.assistant.v1.model.Value;
import com.ibm.watson.assistant.v1.model.ValueCollection;
import com.ibm.watson.assistant.v1.model.Workspace;
import com.ibm.watson.assistant.v1.model.WorkspaceCollection;
import com.ibm.watson.common.SdkCommon;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import okhttp3.HttpUrl;

public class Assistant
extends BaseService {
    public static final String DEFAULT_SERVICE_NAME = "assistant";
    public static final String DEFAULT_SERVICE_URL = "https://api.us-south.assistant.watson.cloud.ibm.com";
    private String version;

    public Assistant(String version) {
        this(version, DEFAULT_SERVICE_NAME, ConfigBasedAuthenticatorFactory.getAuthenticator((String)DEFAULT_SERVICE_NAME));
    }

    public Assistant(String version, Authenticator authenticator) {
        this(version, DEFAULT_SERVICE_NAME, authenticator);
    }

    public Assistant(String version, String serviceName) {
        this(version, serviceName, ConfigBasedAuthenticatorFactory.getAuthenticator((String)serviceName));
    }

    public Assistant(String version, String serviceName, Authenticator authenticator) {
        super(serviceName, authenticator);
        this.setServiceUrl(DEFAULT_SERVICE_URL);
        this.setVersion(version);
        this.configureService(serviceName);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        Validator.notEmpty((String)version, (String)"version cannot be empty.");
        this.version = version;
    }

    public ServiceCall<DialogNode> updateDialogNodeNullable(UpdateDialogNodeNullableOptions UpdateDialogNodeNullableOptions2) {
        Validator.notNull((Object)((Object)UpdateDialogNodeNullableOptions2), (String)"UpdateDialogNodeNullableOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", UpdateDialogNodeNullableOptions2.workspaceId());
        pathParamsMap.put("dialog_node", UpdateDialogNodeNullableOptions2.dialogNode());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/dialog_nodes/{dialog_node}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"testUpdateDialogNode");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (UpdateDialogNodeNullableOptions2.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(UpdateDialogNodeNullableOptions2.includeAudit())});
        }
        builder.bodyContent(GsonSingleton.getGsonWithSerializeNulls().toJson(UpdateDialogNodeNullableOptions2.body()), "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DialogNode>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<MessageResponse> message(MessageOptions messageOptions) {
        Validator.notNull((Object)((Object)messageOptions), (String)"messageOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", messageOptions.workspaceId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/message", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"message");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (messageOptions.nodesVisitedDetails() != null) {
            builder.query(new Object[]{"nodes_visited_details", String.valueOf(messageOptions.nodesVisitedDetails())});
        }
        JsonObject contentJson = new JsonObject();
        if (messageOptions.input() != null) {
            contentJson.add("input", GsonSingleton.getGson().toJsonTree((Object)messageOptions.input()));
        }
        if (messageOptions.intents() != null) {
            contentJson.add("intents", GsonSingleton.getGson().toJsonTree(messageOptions.intents()));
        }
        if (messageOptions.entities() != null) {
            contentJson.add("entities", GsonSingleton.getGson().toJsonTree(messageOptions.entities()));
        }
        if (messageOptions.alternateIntents() != null) {
            contentJson.addProperty("alternate_intents", messageOptions.alternateIntents());
        }
        if (messageOptions.context() != null) {
            contentJson.add("context", GsonSingleton.getGson().toJsonTree((Object)messageOptions.context()));
        }
        if (messageOptions.output() != null) {
            contentJson.add("output", GsonSingleton.getGson().toJsonTree((Object)messageOptions.output()));
        }
        if (messageOptions.userId() != null) {
            contentJson.addProperty("user_id", messageOptions.userId());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<MessageResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<BulkClassifyResponse> bulkClassify(BulkClassifyOptions bulkClassifyOptions) {
        Validator.notNull((Object)((Object)bulkClassifyOptions), (String)"bulkClassifyOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", bulkClassifyOptions.workspaceId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/bulk_classify", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"bulkClassify");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        JsonObject contentJson = new JsonObject();
        if (bulkClassifyOptions.input() != null) {
            contentJson.add("input", GsonSingleton.getGson().toJsonTree(bulkClassifyOptions.input()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<BulkClassifyResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<WorkspaceCollection> listWorkspaces(ListWorkspacesOptions listWorkspacesOptions) {
        if (listWorkspacesOptions == null) {
            listWorkspacesOptions = new ListWorkspacesOptions.Builder().build();
        }
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"listWorkspaces");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (listWorkspacesOptions.pageLimit() != null) {
            builder.query(new Object[]{"page_limit", String.valueOf(listWorkspacesOptions.pageLimit())});
        }
        if (listWorkspacesOptions.includeCount() != null) {
            builder.query(new Object[]{"include_count", String.valueOf(listWorkspacesOptions.includeCount())});
        }
        if (listWorkspacesOptions.sort() != null) {
            builder.query(new Object[]{"sort", String.valueOf(listWorkspacesOptions.sort())});
        }
        if (listWorkspacesOptions.cursor() != null) {
            builder.query(new Object[]{"cursor", String.valueOf(listWorkspacesOptions.cursor())});
        }
        if (listWorkspacesOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(listWorkspacesOptions.includeAudit())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<WorkspaceCollection>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<WorkspaceCollection> listWorkspaces() {
        return this.listWorkspaces(null);
    }

    public ServiceCall<Workspace> createWorkspace(CreateWorkspaceOptions createWorkspaceOptions) {
        boolean skipBody = false;
        if (createWorkspaceOptions == null) {
            createWorkspaceOptions = new CreateWorkspaceOptions.Builder().build();
            skipBody = true;
        }
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"createWorkspace");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (createWorkspaceOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(createWorkspaceOptions.includeAudit())});
        }
        if (!skipBody) {
            JsonObject contentJson = new JsonObject();
            if (createWorkspaceOptions.name() != null) {
                contentJson.addProperty("name", createWorkspaceOptions.name());
            }
            if (createWorkspaceOptions.description() != null) {
                contentJson.addProperty("description", createWorkspaceOptions.description());
            }
            if (createWorkspaceOptions.language() != null) {
                contentJson.addProperty("language", createWorkspaceOptions.language());
            }
            if (createWorkspaceOptions.dialogNodes() != null) {
                contentJson.add("dialog_nodes", GsonSingleton.getGson().toJsonTree(createWorkspaceOptions.dialogNodes()));
            }
            if (createWorkspaceOptions.counterexamples() != null) {
                contentJson.add("counterexamples", GsonSingleton.getGson().toJsonTree(createWorkspaceOptions.counterexamples()));
            }
            if (createWorkspaceOptions.metadata() != null) {
                contentJson.add("metadata", GsonSingleton.getGson().toJsonTree(createWorkspaceOptions.metadata()));
            }
            if (createWorkspaceOptions.learningOptOut() != null) {
                contentJson.addProperty("learning_opt_out", createWorkspaceOptions.learningOptOut());
            }
            if (createWorkspaceOptions.systemSettings() != null) {
                contentJson.add("system_settings", GsonSingleton.getGson().toJsonTree((Object)createWorkspaceOptions.systemSettings()));
            }
            if (createWorkspaceOptions.webhooks() != null) {
                contentJson.add("webhooks", GsonSingleton.getGson().toJsonTree(createWorkspaceOptions.webhooks()));
            }
            if (createWorkspaceOptions.intents() != null) {
                contentJson.add("intents", GsonSingleton.getGson().toJsonTree(createWorkspaceOptions.intents()));
            }
            if (createWorkspaceOptions.entities() != null) {
                contentJson.add("entities", GsonSingleton.getGson().toJsonTree(createWorkspaceOptions.entities()));
            }
            builder.bodyJson(contentJson);
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Workspace>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Workspace> createWorkspace() {
        return this.createWorkspace(null);
    }

    public ServiceCall<Workspace> getWorkspace(GetWorkspaceOptions getWorkspaceOptions) {
        Validator.notNull((Object)((Object)getWorkspaceOptions), (String)"getWorkspaceOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", getWorkspaceOptions.workspaceId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"getWorkspace");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (getWorkspaceOptions.export() != null) {
            builder.query(new Object[]{"export", String.valueOf(getWorkspaceOptions.export())});
        }
        if (getWorkspaceOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(getWorkspaceOptions.includeAudit())});
        }
        if (getWorkspaceOptions.sort() != null) {
            builder.query(new Object[]{"sort", String.valueOf(getWorkspaceOptions.sort())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Workspace>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Workspace> updateWorkspace(UpdateWorkspaceOptions updateWorkspaceOptions) {
        Validator.notNull((Object)((Object)updateWorkspaceOptions), (String)"updateWorkspaceOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", updateWorkspaceOptions.workspaceId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"updateWorkspace");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (updateWorkspaceOptions.append() != null) {
            builder.query(new Object[]{"append", String.valueOf(updateWorkspaceOptions.append())});
        }
        if (updateWorkspaceOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(updateWorkspaceOptions.includeAudit())});
        }
        JsonObject contentJson = new JsonObject();
        if (updateWorkspaceOptions.name() != null) {
            contentJson.addProperty("name", updateWorkspaceOptions.name());
        }
        if (updateWorkspaceOptions.description() != null) {
            contentJson.addProperty("description", updateWorkspaceOptions.description());
        }
        if (updateWorkspaceOptions.language() != null) {
            contentJson.addProperty("language", updateWorkspaceOptions.language());
        }
        if (updateWorkspaceOptions.dialogNodes() != null) {
            contentJson.add("dialog_nodes", GsonSingleton.getGson().toJsonTree(updateWorkspaceOptions.dialogNodes()));
        }
        if (updateWorkspaceOptions.counterexamples() != null) {
            contentJson.add("counterexamples", GsonSingleton.getGson().toJsonTree(updateWorkspaceOptions.counterexamples()));
        }
        if (updateWorkspaceOptions.metadata() != null) {
            contentJson.add("metadata", GsonSingleton.getGson().toJsonTree(updateWorkspaceOptions.metadata()));
        }
        if (updateWorkspaceOptions.learningOptOut() != null) {
            contentJson.addProperty("learning_opt_out", updateWorkspaceOptions.learningOptOut());
        }
        if (updateWorkspaceOptions.systemSettings() != null) {
            contentJson.add("system_settings", GsonSingleton.getGson().toJsonTree((Object)updateWorkspaceOptions.systemSettings()));
        }
        if (updateWorkspaceOptions.webhooks() != null) {
            contentJson.add("webhooks", GsonSingleton.getGson().toJsonTree(updateWorkspaceOptions.webhooks()));
        }
        if (updateWorkspaceOptions.intents() != null) {
            contentJson.add("intents", GsonSingleton.getGson().toJsonTree(updateWorkspaceOptions.intents()));
        }
        if (updateWorkspaceOptions.entities() != null) {
            contentJson.add("entities", GsonSingleton.getGson().toJsonTree(updateWorkspaceOptions.entities()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Workspace>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteWorkspace(DeleteWorkspaceOptions deleteWorkspaceOptions) {
        Validator.notNull((Object)((Object)deleteWorkspaceOptions), (String)"deleteWorkspaceOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", deleteWorkspaceOptions.workspaceId());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"deleteWorkspace");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Workspace> createWorkspaceAsync(CreateWorkspaceAsyncOptions createWorkspaceAsyncOptions) {
        boolean skipBody = false;
        if (createWorkspaceAsyncOptions == null) {
            createWorkspaceAsyncOptions = new CreateWorkspaceAsyncOptions.Builder().build();
            skipBody = true;
        }
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces_async"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"createWorkspaceAsync");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (!skipBody) {
            JsonObject contentJson = new JsonObject();
            if (createWorkspaceAsyncOptions.name() != null) {
                contentJson.addProperty("name", createWorkspaceAsyncOptions.name());
            }
            if (createWorkspaceAsyncOptions.description() != null) {
                contentJson.addProperty("description", createWorkspaceAsyncOptions.description());
            }
            if (createWorkspaceAsyncOptions.language() != null) {
                contentJson.addProperty("language", createWorkspaceAsyncOptions.language());
            }
            if (createWorkspaceAsyncOptions.dialogNodes() != null) {
                contentJson.add("dialog_nodes", GsonSingleton.getGson().toJsonTree(createWorkspaceAsyncOptions.dialogNodes()));
            }
            if (createWorkspaceAsyncOptions.counterexamples() != null) {
                contentJson.add("counterexamples", GsonSingleton.getGson().toJsonTree(createWorkspaceAsyncOptions.counterexamples()));
            }
            if (createWorkspaceAsyncOptions.metadata() != null) {
                contentJson.add("metadata", GsonSingleton.getGson().toJsonTree(createWorkspaceAsyncOptions.metadata()));
            }
            if (createWorkspaceAsyncOptions.learningOptOut() != null) {
                contentJson.addProperty("learning_opt_out", createWorkspaceAsyncOptions.learningOptOut());
            }
            if (createWorkspaceAsyncOptions.systemSettings() != null) {
                contentJson.add("system_settings", GsonSingleton.getGson().toJsonTree((Object)createWorkspaceAsyncOptions.systemSettings()));
            }
            if (createWorkspaceAsyncOptions.webhooks() != null) {
                contentJson.add("webhooks", GsonSingleton.getGson().toJsonTree(createWorkspaceAsyncOptions.webhooks()));
            }
            if (createWorkspaceAsyncOptions.intents() != null) {
                contentJson.add("intents", GsonSingleton.getGson().toJsonTree(createWorkspaceAsyncOptions.intents()));
            }
            if (createWorkspaceAsyncOptions.entities() != null) {
                contentJson.add("entities", GsonSingleton.getGson().toJsonTree(createWorkspaceAsyncOptions.entities()));
            }
            builder.bodyJson(contentJson);
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Workspace>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Workspace> createWorkspaceAsync() {
        return this.createWorkspaceAsync(null);
    }

    public ServiceCall<Workspace> updateWorkspaceAsync(UpdateWorkspaceAsyncOptions updateWorkspaceAsyncOptions) {
        Validator.notNull((Object)((Object)updateWorkspaceAsyncOptions), (String)"updateWorkspaceAsyncOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", updateWorkspaceAsyncOptions.workspaceId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces_async/{workspace_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"updateWorkspaceAsync");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (updateWorkspaceAsyncOptions.append() != null) {
            builder.query(new Object[]{"append", String.valueOf(updateWorkspaceAsyncOptions.append())});
        }
        JsonObject contentJson = new JsonObject();
        if (updateWorkspaceAsyncOptions.name() != null) {
            contentJson.addProperty("name", updateWorkspaceAsyncOptions.name());
        }
        if (updateWorkspaceAsyncOptions.description() != null) {
            contentJson.addProperty("description", updateWorkspaceAsyncOptions.description());
        }
        if (updateWorkspaceAsyncOptions.language() != null) {
            contentJson.addProperty("language", updateWorkspaceAsyncOptions.language());
        }
        if (updateWorkspaceAsyncOptions.dialogNodes() != null) {
            contentJson.add("dialog_nodes", GsonSingleton.getGson().toJsonTree(updateWorkspaceAsyncOptions.dialogNodes()));
        }
        if (updateWorkspaceAsyncOptions.counterexamples() != null) {
            contentJson.add("counterexamples", GsonSingleton.getGson().toJsonTree(updateWorkspaceAsyncOptions.counterexamples()));
        }
        if (updateWorkspaceAsyncOptions.metadata() != null) {
            contentJson.add("metadata", GsonSingleton.getGson().toJsonTree(updateWorkspaceAsyncOptions.metadata()));
        }
        if (updateWorkspaceAsyncOptions.learningOptOut() != null) {
            contentJson.addProperty("learning_opt_out", updateWorkspaceAsyncOptions.learningOptOut());
        }
        if (updateWorkspaceAsyncOptions.systemSettings() != null) {
            contentJson.add("system_settings", GsonSingleton.getGson().toJsonTree((Object)updateWorkspaceAsyncOptions.systemSettings()));
        }
        if (updateWorkspaceAsyncOptions.webhooks() != null) {
            contentJson.add("webhooks", GsonSingleton.getGson().toJsonTree(updateWorkspaceAsyncOptions.webhooks()));
        }
        if (updateWorkspaceAsyncOptions.intents() != null) {
            contentJson.add("intents", GsonSingleton.getGson().toJsonTree(updateWorkspaceAsyncOptions.intents()));
        }
        if (updateWorkspaceAsyncOptions.entities() != null) {
            contentJson.add("entities", GsonSingleton.getGson().toJsonTree(updateWorkspaceAsyncOptions.entities()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Workspace>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Workspace> exportWorkspaceAsync(ExportWorkspaceAsyncOptions exportWorkspaceAsyncOptions) {
        Validator.notNull((Object)((Object)exportWorkspaceAsyncOptions), (String)"exportWorkspaceAsyncOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", exportWorkspaceAsyncOptions.workspaceId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces_async/{workspace_id}/export", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"exportWorkspaceAsync");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (exportWorkspaceAsyncOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(exportWorkspaceAsyncOptions.includeAudit())});
        }
        if (exportWorkspaceAsyncOptions.sort() != null) {
            builder.query(new Object[]{"sort", String.valueOf(exportWorkspaceAsyncOptions.sort())});
        }
        if (exportWorkspaceAsyncOptions.verbose() != null) {
            builder.query(new Object[]{"verbose", String.valueOf(exportWorkspaceAsyncOptions.verbose())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Workspace>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<IntentCollection> listIntents(ListIntentsOptions listIntentsOptions) {
        Validator.notNull((Object)((Object)listIntentsOptions), (String)"listIntentsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", listIntentsOptions.workspaceId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/intents", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"listIntents");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (listIntentsOptions.export() != null) {
            builder.query(new Object[]{"export", String.valueOf(listIntentsOptions.export())});
        }
        if (listIntentsOptions.pageLimit() != null) {
            builder.query(new Object[]{"page_limit", String.valueOf(listIntentsOptions.pageLimit())});
        }
        if (listIntentsOptions.includeCount() != null) {
            builder.query(new Object[]{"include_count", String.valueOf(listIntentsOptions.includeCount())});
        }
        if (listIntentsOptions.sort() != null) {
            builder.query(new Object[]{"sort", String.valueOf(listIntentsOptions.sort())});
        }
        if (listIntentsOptions.cursor() != null) {
            builder.query(new Object[]{"cursor", String.valueOf(listIntentsOptions.cursor())});
        }
        if (listIntentsOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(listIntentsOptions.includeAudit())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<IntentCollection>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Intent> createIntent(CreateIntentOptions createIntentOptions) {
        Validator.notNull((Object)((Object)createIntentOptions), (String)"createIntentOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", createIntentOptions.workspaceId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/intents", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"createIntent");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (createIntentOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(createIntentOptions.includeAudit())});
        }
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("intent", createIntentOptions.intent());
        if (createIntentOptions.description() != null) {
            contentJson.addProperty("description", createIntentOptions.description());
        }
        if (createIntentOptions.examples() != null) {
            contentJson.add("examples", GsonSingleton.getGson().toJsonTree(createIntentOptions.examples()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Intent>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Intent> getIntent(GetIntentOptions getIntentOptions) {
        Validator.notNull((Object)((Object)getIntentOptions), (String)"getIntentOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", getIntentOptions.workspaceId());
        pathParamsMap.put("intent", getIntentOptions.intent());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/intents/{intent}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"getIntent");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (getIntentOptions.export() != null) {
            builder.query(new Object[]{"export", String.valueOf(getIntentOptions.export())});
        }
        if (getIntentOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(getIntentOptions.includeAudit())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Intent>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Intent> updateIntent(UpdateIntentOptions updateIntentOptions) {
        Validator.notNull((Object)((Object)updateIntentOptions), (String)"updateIntentOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", updateIntentOptions.workspaceId());
        pathParamsMap.put("intent", updateIntentOptions.intent());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/intents/{intent}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"updateIntent");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (updateIntentOptions.append() != null) {
            builder.query(new Object[]{"append", String.valueOf(updateIntentOptions.append())});
        }
        if (updateIntentOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(updateIntentOptions.includeAudit())});
        }
        JsonObject contentJson = new JsonObject();
        if (updateIntentOptions.newIntent() != null) {
            contentJson.addProperty("intent", updateIntentOptions.newIntent());
        }
        if (updateIntentOptions.newDescription() != null) {
            contentJson.addProperty("description", updateIntentOptions.newDescription());
        }
        if (updateIntentOptions.newExamples() != null) {
            contentJson.add("examples", GsonSingleton.getGson().toJsonTree(updateIntentOptions.newExamples()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Intent>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteIntent(DeleteIntentOptions deleteIntentOptions) {
        Validator.notNull((Object)((Object)deleteIntentOptions), (String)"deleteIntentOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", deleteIntentOptions.workspaceId());
        pathParamsMap.put("intent", deleteIntentOptions.intent());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/intents/{intent}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"deleteIntent");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ExampleCollection> listExamples(ListExamplesOptions listExamplesOptions) {
        Validator.notNull((Object)((Object)listExamplesOptions), (String)"listExamplesOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", listExamplesOptions.workspaceId());
        pathParamsMap.put("intent", listExamplesOptions.intent());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/intents/{intent}/examples", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"listExamples");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (listExamplesOptions.pageLimit() != null) {
            builder.query(new Object[]{"page_limit", String.valueOf(listExamplesOptions.pageLimit())});
        }
        if (listExamplesOptions.includeCount() != null) {
            builder.query(new Object[]{"include_count", String.valueOf(listExamplesOptions.includeCount())});
        }
        if (listExamplesOptions.sort() != null) {
            builder.query(new Object[]{"sort", String.valueOf(listExamplesOptions.sort())});
        }
        if (listExamplesOptions.cursor() != null) {
            builder.query(new Object[]{"cursor", String.valueOf(listExamplesOptions.cursor())});
        }
        if (listExamplesOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(listExamplesOptions.includeAudit())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ExampleCollection>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Example> createExample(CreateExampleOptions createExampleOptions) {
        Validator.notNull((Object)((Object)createExampleOptions), (String)"createExampleOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", createExampleOptions.workspaceId());
        pathParamsMap.put("intent", createExampleOptions.intent());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/intents/{intent}/examples", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"createExample");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (createExampleOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(createExampleOptions.includeAudit())});
        }
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("text", createExampleOptions.text());
        if (createExampleOptions.mentions() != null) {
            contentJson.add("mentions", GsonSingleton.getGson().toJsonTree(createExampleOptions.mentions()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Example>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Example> getExample(GetExampleOptions getExampleOptions) {
        Validator.notNull((Object)((Object)getExampleOptions), (String)"getExampleOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", getExampleOptions.workspaceId());
        pathParamsMap.put("intent", getExampleOptions.intent());
        pathParamsMap.put("text", getExampleOptions.text());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/intents/{intent}/examples/{text}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"getExample");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (getExampleOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(getExampleOptions.includeAudit())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Example>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Example> updateExample(UpdateExampleOptions updateExampleOptions) {
        Validator.notNull((Object)((Object)updateExampleOptions), (String)"updateExampleOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", updateExampleOptions.workspaceId());
        pathParamsMap.put("intent", updateExampleOptions.intent());
        pathParamsMap.put("text", updateExampleOptions.text());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/intents/{intent}/examples/{text}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"updateExample");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (updateExampleOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(updateExampleOptions.includeAudit())});
        }
        JsonObject contentJson = new JsonObject();
        if (updateExampleOptions.newText() != null) {
            contentJson.addProperty("text", updateExampleOptions.newText());
        }
        if (updateExampleOptions.newMentions() != null) {
            contentJson.add("mentions", GsonSingleton.getGson().toJsonTree(updateExampleOptions.newMentions()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Example>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteExample(DeleteExampleOptions deleteExampleOptions) {
        Validator.notNull((Object)((Object)deleteExampleOptions), (String)"deleteExampleOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", deleteExampleOptions.workspaceId());
        pathParamsMap.put("intent", deleteExampleOptions.intent());
        pathParamsMap.put("text", deleteExampleOptions.text());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/intents/{intent}/examples/{text}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"deleteExample");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<CounterexampleCollection> listCounterexamples(ListCounterexamplesOptions listCounterexamplesOptions) {
        Validator.notNull((Object)((Object)listCounterexamplesOptions), (String)"listCounterexamplesOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", listCounterexamplesOptions.workspaceId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/counterexamples", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"listCounterexamples");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (listCounterexamplesOptions.pageLimit() != null) {
            builder.query(new Object[]{"page_limit", String.valueOf(listCounterexamplesOptions.pageLimit())});
        }
        if (listCounterexamplesOptions.includeCount() != null) {
            builder.query(new Object[]{"include_count", String.valueOf(listCounterexamplesOptions.includeCount())});
        }
        if (listCounterexamplesOptions.sort() != null) {
            builder.query(new Object[]{"sort", String.valueOf(listCounterexamplesOptions.sort())});
        }
        if (listCounterexamplesOptions.cursor() != null) {
            builder.query(new Object[]{"cursor", String.valueOf(listCounterexamplesOptions.cursor())});
        }
        if (listCounterexamplesOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(listCounterexamplesOptions.includeAudit())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<CounterexampleCollection>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Counterexample> createCounterexample(CreateCounterexampleOptions createCounterexampleOptions) {
        Validator.notNull((Object)((Object)createCounterexampleOptions), (String)"createCounterexampleOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", createCounterexampleOptions.workspaceId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/counterexamples", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"createCounterexample");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (createCounterexampleOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(createCounterexampleOptions.includeAudit())});
        }
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("text", createCounterexampleOptions.text());
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Counterexample>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Counterexample> getCounterexample(GetCounterexampleOptions getCounterexampleOptions) {
        Validator.notNull((Object)((Object)getCounterexampleOptions), (String)"getCounterexampleOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", getCounterexampleOptions.workspaceId());
        pathParamsMap.put("text", getCounterexampleOptions.text());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/counterexamples/{text}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"getCounterexample");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (getCounterexampleOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(getCounterexampleOptions.includeAudit())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Counterexample>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Counterexample> updateCounterexample(UpdateCounterexampleOptions updateCounterexampleOptions) {
        Validator.notNull((Object)((Object)updateCounterexampleOptions), (String)"updateCounterexampleOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", updateCounterexampleOptions.workspaceId());
        pathParamsMap.put("text", updateCounterexampleOptions.text());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/counterexamples/{text}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"updateCounterexample");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (updateCounterexampleOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(updateCounterexampleOptions.includeAudit())});
        }
        JsonObject contentJson = new JsonObject();
        if (updateCounterexampleOptions.newText() != null) {
            contentJson.addProperty("text", updateCounterexampleOptions.newText());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Counterexample>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteCounterexample(DeleteCounterexampleOptions deleteCounterexampleOptions) {
        Validator.notNull((Object)((Object)deleteCounterexampleOptions), (String)"deleteCounterexampleOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", deleteCounterexampleOptions.workspaceId());
        pathParamsMap.put("text", deleteCounterexampleOptions.text());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/counterexamples/{text}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"deleteCounterexample");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<EntityCollection> listEntities(ListEntitiesOptions listEntitiesOptions) {
        Validator.notNull((Object)((Object)listEntitiesOptions), (String)"listEntitiesOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", listEntitiesOptions.workspaceId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/entities", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"listEntities");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (listEntitiesOptions.export() != null) {
            builder.query(new Object[]{"export", String.valueOf(listEntitiesOptions.export())});
        }
        if (listEntitiesOptions.pageLimit() != null) {
            builder.query(new Object[]{"page_limit", String.valueOf(listEntitiesOptions.pageLimit())});
        }
        if (listEntitiesOptions.includeCount() != null) {
            builder.query(new Object[]{"include_count", String.valueOf(listEntitiesOptions.includeCount())});
        }
        if (listEntitiesOptions.sort() != null) {
            builder.query(new Object[]{"sort", String.valueOf(listEntitiesOptions.sort())});
        }
        if (listEntitiesOptions.cursor() != null) {
            builder.query(new Object[]{"cursor", String.valueOf(listEntitiesOptions.cursor())});
        }
        if (listEntitiesOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(listEntitiesOptions.includeAudit())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<EntityCollection>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Entity> createEntity(CreateEntityOptions createEntityOptions) {
        Validator.notNull((Object)((Object)createEntityOptions), (String)"createEntityOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", createEntityOptions.workspaceId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/entities", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"createEntity");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (createEntityOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(createEntityOptions.includeAudit())});
        }
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("entity", createEntityOptions.entity());
        if (createEntityOptions.description() != null) {
            contentJson.addProperty("description", createEntityOptions.description());
        }
        if (createEntityOptions.metadata() != null) {
            contentJson.add("metadata", GsonSingleton.getGson().toJsonTree(createEntityOptions.metadata()));
        }
        if (createEntityOptions.fuzzyMatch() != null) {
            contentJson.addProperty("fuzzy_match", createEntityOptions.fuzzyMatch());
        }
        if (createEntityOptions.values() != null) {
            contentJson.add("values", GsonSingleton.getGson().toJsonTree(createEntityOptions.values()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Entity>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Entity> getEntity(GetEntityOptions getEntityOptions) {
        Validator.notNull((Object)((Object)getEntityOptions), (String)"getEntityOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", getEntityOptions.workspaceId());
        pathParamsMap.put("entity", getEntityOptions.entity());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/entities/{entity}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"getEntity");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (getEntityOptions.export() != null) {
            builder.query(new Object[]{"export", String.valueOf(getEntityOptions.export())});
        }
        if (getEntityOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(getEntityOptions.includeAudit())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Entity>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Entity> updateEntity(UpdateEntityOptions updateEntityOptions) {
        Validator.notNull((Object)((Object)updateEntityOptions), (String)"updateEntityOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", updateEntityOptions.workspaceId());
        pathParamsMap.put("entity", updateEntityOptions.entity());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/entities/{entity}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"updateEntity");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (updateEntityOptions.append() != null) {
            builder.query(new Object[]{"append", String.valueOf(updateEntityOptions.append())});
        }
        if (updateEntityOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(updateEntityOptions.includeAudit())});
        }
        JsonObject contentJson = new JsonObject();
        if (updateEntityOptions.newEntity() != null) {
            contentJson.addProperty("entity", updateEntityOptions.newEntity());
        }
        if (updateEntityOptions.newDescription() != null) {
            contentJson.addProperty("description", updateEntityOptions.newDescription());
        }
        if (updateEntityOptions.newMetadata() != null) {
            contentJson.add("metadata", GsonSingleton.getGson().toJsonTree(updateEntityOptions.newMetadata()));
        }
        if (updateEntityOptions.newFuzzyMatch() != null) {
            contentJson.addProperty("fuzzy_match", updateEntityOptions.newFuzzyMatch());
        }
        if (updateEntityOptions.newValues() != null) {
            contentJson.add("values", GsonSingleton.getGson().toJsonTree(updateEntityOptions.newValues()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Entity>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteEntity(DeleteEntityOptions deleteEntityOptions) {
        Validator.notNull((Object)((Object)deleteEntityOptions), (String)"deleteEntityOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", deleteEntityOptions.workspaceId());
        pathParamsMap.put("entity", deleteEntityOptions.entity());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/entities/{entity}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"deleteEntity");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<EntityMentionCollection> listMentions(ListMentionsOptions listMentionsOptions) {
        Validator.notNull((Object)((Object)listMentionsOptions), (String)"listMentionsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", listMentionsOptions.workspaceId());
        pathParamsMap.put("entity", listMentionsOptions.entity());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/entities/{entity}/mentions", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"listMentions");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (listMentionsOptions.export() != null) {
            builder.query(new Object[]{"export", String.valueOf(listMentionsOptions.export())});
        }
        if (listMentionsOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(listMentionsOptions.includeAudit())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<EntityMentionCollection>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ValueCollection> listValues(ListValuesOptions listValuesOptions) {
        Validator.notNull((Object)((Object)listValuesOptions), (String)"listValuesOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", listValuesOptions.workspaceId());
        pathParamsMap.put("entity", listValuesOptions.entity());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/entities/{entity}/values", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"listValues");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (listValuesOptions.export() != null) {
            builder.query(new Object[]{"export", String.valueOf(listValuesOptions.export())});
        }
        if (listValuesOptions.pageLimit() != null) {
            builder.query(new Object[]{"page_limit", String.valueOf(listValuesOptions.pageLimit())});
        }
        if (listValuesOptions.includeCount() != null) {
            builder.query(new Object[]{"include_count", String.valueOf(listValuesOptions.includeCount())});
        }
        if (listValuesOptions.sort() != null) {
            builder.query(new Object[]{"sort", String.valueOf(listValuesOptions.sort())});
        }
        if (listValuesOptions.cursor() != null) {
            builder.query(new Object[]{"cursor", String.valueOf(listValuesOptions.cursor())});
        }
        if (listValuesOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(listValuesOptions.includeAudit())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ValueCollection>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Value> createValue(CreateValueOptions createValueOptions) {
        Validator.notNull((Object)((Object)createValueOptions), (String)"createValueOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", createValueOptions.workspaceId());
        pathParamsMap.put("entity", createValueOptions.entity());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/entities/{entity}/values", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"createValue");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (createValueOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(createValueOptions.includeAudit())});
        }
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("value", createValueOptions.value());
        if (createValueOptions.metadata() != null) {
            contentJson.add("metadata", GsonSingleton.getGson().toJsonTree(createValueOptions.metadata()));
        }
        if (createValueOptions.type() != null) {
            contentJson.addProperty("type", createValueOptions.type());
        }
        if (createValueOptions.synonyms() != null) {
            contentJson.add("synonyms", GsonSingleton.getGson().toJsonTree(createValueOptions.synonyms()));
        }
        if (createValueOptions.patterns() != null) {
            contentJson.add("patterns", GsonSingleton.getGson().toJsonTree(createValueOptions.patterns()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Value>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Value> getValue(GetValueOptions getValueOptions) {
        Validator.notNull((Object)((Object)getValueOptions), (String)"getValueOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", getValueOptions.workspaceId());
        pathParamsMap.put("entity", getValueOptions.entity());
        pathParamsMap.put("value", getValueOptions.value());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/entities/{entity}/values/{value}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"getValue");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (getValueOptions.export() != null) {
            builder.query(new Object[]{"export", String.valueOf(getValueOptions.export())});
        }
        if (getValueOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(getValueOptions.includeAudit())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Value>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Value> updateValue(UpdateValueOptions updateValueOptions) {
        Validator.notNull((Object)((Object)updateValueOptions), (String)"updateValueOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", updateValueOptions.workspaceId());
        pathParamsMap.put("entity", updateValueOptions.entity());
        pathParamsMap.put("value", updateValueOptions.value());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/entities/{entity}/values/{value}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"updateValue");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (updateValueOptions.append() != null) {
            builder.query(new Object[]{"append", String.valueOf(updateValueOptions.append())});
        }
        if (updateValueOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(updateValueOptions.includeAudit())});
        }
        JsonObject contentJson = new JsonObject();
        if (updateValueOptions.newValue() != null) {
            contentJson.addProperty("value", updateValueOptions.newValue());
        }
        if (updateValueOptions.newMetadata() != null) {
            contentJson.add("metadata", GsonSingleton.getGson().toJsonTree(updateValueOptions.newMetadata()));
        }
        if (updateValueOptions.newType() != null) {
            contentJson.addProperty("type", updateValueOptions.newType());
        }
        if (updateValueOptions.newSynonyms() != null) {
            contentJson.add("synonyms", GsonSingleton.getGson().toJsonTree(updateValueOptions.newSynonyms()));
        }
        if (updateValueOptions.newPatterns() != null) {
            contentJson.add("patterns", GsonSingleton.getGson().toJsonTree(updateValueOptions.newPatterns()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Value>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteValue(DeleteValueOptions deleteValueOptions) {
        Validator.notNull((Object)((Object)deleteValueOptions), (String)"deleteValueOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", deleteValueOptions.workspaceId());
        pathParamsMap.put("entity", deleteValueOptions.entity());
        pathParamsMap.put("value", deleteValueOptions.value());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/entities/{entity}/values/{value}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"deleteValue");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SynonymCollection> listSynonyms(ListSynonymsOptions listSynonymsOptions) {
        Validator.notNull((Object)((Object)listSynonymsOptions), (String)"listSynonymsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", listSynonymsOptions.workspaceId());
        pathParamsMap.put("entity", listSynonymsOptions.entity());
        pathParamsMap.put("value", listSynonymsOptions.value());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/entities/{entity}/values/{value}/synonyms", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"listSynonyms");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (listSynonymsOptions.pageLimit() != null) {
            builder.query(new Object[]{"page_limit", String.valueOf(listSynonymsOptions.pageLimit())});
        }
        if (listSynonymsOptions.includeCount() != null) {
            builder.query(new Object[]{"include_count", String.valueOf(listSynonymsOptions.includeCount())});
        }
        if (listSynonymsOptions.sort() != null) {
            builder.query(new Object[]{"sort", String.valueOf(listSynonymsOptions.sort())});
        }
        if (listSynonymsOptions.cursor() != null) {
            builder.query(new Object[]{"cursor", String.valueOf(listSynonymsOptions.cursor())});
        }
        if (listSynonymsOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(listSynonymsOptions.includeAudit())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SynonymCollection>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Synonym> createSynonym(CreateSynonymOptions createSynonymOptions) {
        Validator.notNull((Object)((Object)createSynonymOptions), (String)"createSynonymOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", createSynonymOptions.workspaceId());
        pathParamsMap.put("entity", createSynonymOptions.entity());
        pathParamsMap.put("value", createSynonymOptions.value());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/entities/{entity}/values/{value}/synonyms", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"createSynonym");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (createSynonymOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(createSynonymOptions.includeAudit())});
        }
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("synonym", createSynonymOptions.synonym());
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Synonym>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Synonym> getSynonym(GetSynonymOptions getSynonymOptions) {
        Validator.notNull((Object)((Object)getSynonymOptions), (String)"getSynonymOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", getSynonymOptions.workspaceId());
        pathParamsMap.put("entity", getSynonymOptions.entity());
        pathParamsMap.put("value", getSynonymOptions.value());
        pathParamsMap.put("synonym", getSynonymOptions.synonym());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/entities/{entity}/values/{value}/synonyms/{synonym}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"getSynonym");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (getSynonymOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(getSynonymOptions.includeAudit())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Synonym>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Synonym> updateSynonym(UpdateSynonymOptions updateSynonymOptions) {
        Validator.notNull((Object)((Object)updateSynonymOptions), (String)"updateSynonymOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", updateSynonymOptions.workspaceId());
        pathParamsMap.put("entity", updateSynonymOptions.entity());
        pathParamsMap.put("value", updateSynonymOptions.value());
        pathParamsMap.put("synonym", updateSynonymOptions.synonym());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/entities/{entity}/values/{value}/synonyms/{synonym}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"updateSynonym");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (updateSynonymOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(updateSynonymOptions.includeAudit())});
        }
        JsonObject contentJson = new JsonObject();
        if (updateSynonymOptions.newSynonym() != null) {
            contentJson.addProperty("synonym", updateSynonymOptions.newSynonym());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Synonym>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteSynonym(DeleteSynonymOptions deleteSynonymOptions) {
        Validator.notNull((Object)((Object)deleteSynonymOptions), (String)"deleteSynonymOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", deleteSynonymOptions.workspaceId());
        pathParamsMap.put("entity", deleteSynonymOptions.entity());
        pathParamsMap.put("value", deleteSynonymOptions.value());
        pathParamsMap.put("synonym", deleteSynonymOptions.synonym());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/entities/{entity}/values/{value}/synonyms/{synonym}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"deleteSynonym");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DialogNodeCollection> listDialogNodes(ListDialogNodesOptions listDialogNodesOptions) {
        Validator.notNull((Object)((Object)listDialogNodesOptions), (String)"listDialogNodesOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", listDialogNodesOptions.workspaceId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/dialog_nodes", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"listDialogNodes");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (listDialogNodesOptions.pageLimit() != null) {
            builder.query(new Object[]{"page_limit", String.valueOf(listDialogNodesOptions.pageLimit())});
        }
        if (listDialogNodesOptions.includeCount() != null) {
            builder.query(new Object[]{"include_count", String.valueOf(listDialogNodesOptions.includeCount())});
        }
        if (listDialogNodesOptions.sort() != null) {
            builder.query(new Object[]{"sort", String.valueOf(listDialogNodesOptions.sort())});
        }
        if (listDialogNodesOptions.cursor() != null) {
            builder.query(new Object[]{"cursor", String.valueOf(listDialogNodesOptions.cursor())});
        }
        if (listDialogNodesOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(listDialogNodesOptions.includeAudit())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DialogNodeCollection>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DialogNode> createDialogNode(CreateDialogNodeOptions createDialogNodeOptions) {
        Validator.notNull((Object)((Object)createDialogNodeOptions), (String)"createDialogNodeOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", createDialogNodeOptions.workspaceId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/dialog_nodes", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"createDialogNode");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (createDialogNodeOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(createDialogNodeOptions.includeAudit())});
        }
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("dialog_node", createDialogNodeOptions.dialogNode());
        if (createDialogNodeOptions.description() != null) {
            contentJson.addProperty("description", createDialogNodeOptions.description());
        }
        if (createDialogNodeOptions.conditions() != null) {
            contentJson.addProperty("conditions", createDialogNodeOptions.conditions());
        }
        if (createDialogNodeOptions.parent() != null) {
            contentJson.addProperty("parent", createDialogNodeOptions.parent());
        }
        if (createDialogNodeOptions.previousSibling() != null) {
            contentJson.addProperty("previous_sibling", createDialogNodeOptions.previousSibling());
        }
        if (createDialogNodeOptions.output() != null) {
            contentJson.add("output", GsonSingleton.getGson().toJsonTree((Object)createDialogNodeOptions.output()));
        }
        if (createDialogNodeOptions.context() != null) {
            contentJson.add("context", GsonSingleton.getGson().toJsonTree((Object)createDialogNodeOptions.context()));
        }
        if (createDialogNodeOptions.metadata() != null) {
            contentJson.add("metadata", GsonSingleton.getGson().toJsonTree(createDialogNodeOptions.metadata()));
        }
        if (createDialogNodeOptions.nextStep() != null) {
            contentJson.add("next_step", GsonSingleton.getGson().toJsonTree((Object)createDialogNodeOptions.nextStep()));
        }
        if (createDialogNodeOptions.title() != null) {
            contentJson.addProperty("title", createDialogNodeOptions.title());
        }
        if (createDialogNodeOptions.type() != null) {
            contentJson.addProperty("type", createDialogNodeOptions.type());
        }
        if (createDialogNodeOptions.eventName() != null) {
            contentJson.addProperty("event_name", createDialogNodeOptions.eventName());
        }
        if (createDialogNodeOptions.variable() != null) {
            contentJson.addProperty("variable", createDialogNodeOptions.variable());
        }
        if (createDialogNodeOptions.actions() != null) {
            contentJson.add("actions", GsonSingleton.getGson().toJsonTree(createDialogNodeOptions.actions()));
        }
        if (createDialogNodeOptions.digressIn() != null) {
            contentJson.addProperty("digress_in", createDialogNodeOptions.digressIn());
        }
        if (createDialogNodeOptions.digressOut() != null) {
            contentJson.addProperty("digress_out", createDialogNodeOptions.digressOut());
        }
        if (createDialogNodeOptions.digressOutSlots() != null) {
            contentJson.addProperty("digress_out_slots", createDialogNodeOptions.digressOutSlots());
        }
        if (createDialogNodeOptions.userLabel() != null) {
            contentJson.addProperty("user_label", createDialogNodeOptions.userLabel());
        }
        if (createDialogNodeOptions.disambiguationOptOut() != null) {
            contentJson.addProperty("disambiguation_opt_out", createDialogNodeOptions.disambiguationOptOut());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DialogNode>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DialogNode> getDialogNode(GetDialogNodeOptions getDialogNodeOptions) {
        Validator.notNull((Object)((Object)getDialogNodeOptions), (String)"getDialogNodeOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", getDialogNodeOptions.workspaceId());
        pathParamsMap.put("dialog_node", getDialogNodeOptions.dialogNode());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/dialog_nodes/{dialog_node}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"getDialogNode");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (getDialogNodeOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(getDialogNodeOptions.includeAudit())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DialogNode>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DialogNode> updateDialogNode(UpdateDialogNodeOptions updateDialogNodeOptions) {
        Validator.notNull((Object)((Object)updateDialogNodeOptions), (String)"updateDialogNodeOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", updateDialogNodeOptions.workspaceId());
        pathParamsMap.put("dialog_node", updateDialogNodeOptions.dialogNode());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/dialog_nodes/{dialog_node}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"updateDialogNode");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (updateDialogNodeOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(updateDialogNodeOptions.includeAudit())});
        }
        JsonObject contentJson = new JsonObject();
        if (updateDialogNodeOptions.newDialogNode() != null) {
            contentJson.addProperty("dialog_node", updateDialogNodeOptions.newDialogNode());
        }
        if (updateDialogNodeOptions.newDescription() != null) {
            contentJson.addProperty("description", updateDialogNodeOptions.newDescription());
        }
        if (updateDialogNodeOptions.newConditions() != null) {
            contentJson.addProperty("conditions", updateDialogNodeOptions.newConditions());
        }
        if (updateDialogNodeOptions.newParent() != null) {
            contentJson.addProperty("parent", updateDialogNodeOptions.newParent());
        }
        if (updateDialogNodeOptions.newPreviousSibling() != null) {
            contentJson.addProperty("previous_sibling", updateDialogNodeOptions.newPreviousSibling());
        }
        if (updateDialogNodeOptions.newOutput() != null) {
            contentJson.add("output", GsonSingleton.getGson().toJsonTree((Object)updateDialogNodeOptions.newOutput()));
        }
        if (updateDialogNodeOptions.newContext() != null) {
            contentJson.add("context", GsonSingleton.getGson().toJsonTree((Object)updateDialogNodeOptions.newContext()));
        }
        if (updateDialogNodeOptions.newMetadata() != null) {
            contentJson.add("metadata", GsonSingleton.getGson().toJsonTree(updateDialogNodeOptions.newMetadata()));
        }
        if (updateDialogNodeOptions.newNextStep() != null) {
            contentJson.add("next_step", GsonSingleton.getGson().toJsonTree((Object)updateDialogNodeOptions.newNextStep()));
        }
        if (updateDialogNodeOptions.newTitle() != null) {
            contentJson.addProperty("title", updateDialogNodeOptions.newTitle());
        }
        if (updateDialogNodeOptions.newType() != null) {
            contentJson.addProperty("type", updateDialogNodeOptions.newType());
        }
        if (updateDialogNodeOptions.newEventName() != null) {
            contentJson.addProperty("event_name", updateDialogNodeOptions.newEventName());
        }
        if (updateDialogNodeOptions.newVariable() != null) {
            contentJson.addProperty("variable", updateDialogNodeOptions.newVariable());
        }
        if (updateDialogNodeOptions.newActions() != null) {
            contentJson.add("actions", GsonSingleton.getGson().toJsonTree(updateDialogNodeOptions.newActions()));
        }
        if (updateDialogNodeOptions.newDigressIn() != null) {
            contentJson.addProperty("digress_in", updateDialogNodeOptions.newDigressIn());
        }
        if (updateDialogNodeOptions.newDigressOut() != null) {
            contentJson.addProperty("digress_out", updateDialogNodeOptions.newDigressOut());
        }
        if (updateDialogNodeOptions.newDigressOutSlots() != null) {
            contentJson.addProperty("digress_out_slots", updateDialogNodeOptions.newDigressOutSlots());
        }
        if (updateDialogNodeOptions.newUserLabel() != null) {
            contentJson.addProperty("user_label", updateDialogNodeOptions.newUserLabel());
        }
        if (updateDialogNodeOptions.newDisambiguationOptOut() != null) {
            contentJson.addProperty("disambiguation_opt_out", updateDialogNodeOptions.newDisambiguationOptOut());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DialogNode>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteDialogNode(DeleteDialogNodeOptions deleteDialogNodeOptions) {
        Validator.notNull((Object)((Object)deleteDialogNodeOptions), (String)"deleteDialogNodeOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", deleteDialogNodeOptions.workspaceId());
        pathParamsMap.put("dialog_node", deleteDialogNodeOptions.dialogNode());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/dialog_nodes/{dialog_node}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"deleteDialogNode");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<LogCollection> listLogs(ListLogsOptions listLogsOptions) {
        Validator.notNull((Object)((Object)listLogsOptions), (String)"listLogsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("workspace_id", listLogsOptions.workspaceId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/workspaces/{workspace_id}/logs", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"listLogs");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (listLogsOptions.sort() != null) {
            builder.query(new Object[]{"sort", String.valueOf(listLogsOptions.sort())});
        }
        if (listLogsOptions.filter() != null) {
            builder.query(new Object[]{"filter", String.valueOf(listLogsOptions.filter())});
        }
        if (listLogsOptions.pageLimit() != null) {
            builder.query(new Object[]{"page_limit", String.valueOf(listLogsOptions.pageLimit())});
        }
        if (listLogsOptions.cursor() != null) {
            builder.query(new Object[]{"cursor", String.valueOf(listLogsOptions.cursor())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<LogCollection>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<LogCollection> listAllLogs(ListAllLogsOptions listAllLogsOptions) {
        Validator.notNull((Object)((Object)listAllLogsOptions), (String)"listAllLogsOptions cannot be null");
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/logs"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"listAllLogs");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        builder.query(new Object[]{"filter", String.valueOf(listAllLogsOptions.filter())});
        if (listAllLogsOptions.sort() != null) {
            builder.query(new Object[]{"sort", String.valueOf(listAllLogsOptions.sort())});
        }
        if (listAllLogsOptions.pageLimit() != null) {
            builder.query(new Object[]{"page_limit", String.valueOf(listAllLogsOptions.pageLimit())});
        }
        if (listAllLogsOptions.cursor() != null) {
            builder.query(new Object[]{"cursor", String.valueOf(listAllLogsOptions.cursor())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<LogCollection>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteUserData(DeleteUserDataOptions deleteUserDataOptions) {
        Validator.notNull((Object)((Object)deleteUserDataOptions), (String)"deleteUserDataOptions cannot be null");
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/user_data"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v1", (String)"deleteUserData");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        builder.query(new Object[]{"customer_id", String.valueOf(deleteUserDataOptions.customerId())});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }
}

