/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.viz;

import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.viz.NodeDecorator;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collection;
import org.jspecify.annotations.Nullable;

public class DotUtil {
    private static DotOutputType outputType = DotOutputType.PDF;
    private static int fontSize = 6;
    private static final String fontColor = "black";
    private static final String fontName = "Arial";
    private static final int MAX_LABEL_LENGTH = Integer.MAX_VALUE;

    public static void setOutputType(DotOutputType outType) {
        outputType = outType;
    }

    public static DotOutputType getOutputType() {
        return outputType;
    }

    private static String outputTypeCmdLineParam() {
        return "-T" + DotUtil.outputType.suffix;
    }

    public static <T> void dotify(Graph<T> g, NodeDecorator<T> labels, String dotFile, String outputFile, String dotExe) throws WalaException {
        DotUtil.dotify(g, labels, null, dotFile, outputFile, dotExe);
    }

    public static <T> void dotify(Graph<T> g, NodeDecorator<T> labels, @Nullable String title, String dotFile, String outputFile, String dotExe) throws WalaException {
        if (g == null) {
            throw new IllegalArgumentException("g is null");
        }
        File f = DotUtil.writeDotFile(g, labels, title, dotFile);
        if (dotExe != null) {
            DotUtil.spawnDot(dotExe, outputFile, f);
        }
    }

    public static void spawnDot(String dotExe, String outputFile, File dotFile) throws WalaException {
        if (dotFile == null) {
            throw new IllegalArgumentException("dotFile is null");
        }
        Object[] cmdarray = new String[]{dotExe, DotUtil.outputTypeCmdLineParam(), "-o", outputFile, "-v", dotFile.getAbsolutePath()};
        System.out.println("spawning process " + Arrays.toString(cmdarray));
        BufferedInputStream output = null;
        BufferedInputStream error = null;
        try {
            Process p = Runtime.getRuntime().exec((String[])cmdarray);
            output = new BufferedInputStream(p.getInputStream());
            error = new BufferedInputStream(p.getErrorStream());
            boolean repeat = true;
            while (repeat) {
                int nRead;
                byte[] data;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                if (output.available() > 0) {
                    data = new byte[output.available()];
                    nRead = output.read(data);
                    System.err.println("read " + nRead + " bytes from output stream");
                }
                if (error.available() > 0) {
                    data = new byte[error.available()];
                    nRead = error.read(data);
                    System.err.println("read " + nRead + " bytes from error stream");
                }
                try {
                    p.exitValue();
                    repeat = false;
                    System.out.println("process terminated with exit code " + p.exitValue());
                }
                catch (IllegalThreadStateException e) {
                    repeat = true;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new WalaException("IOException in " + DotUtil.class);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (error != null) {
                try {
                    error.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static <T> File writeDotFile(Graph<T> g, NodeDecorator<T> labels, @Nullable String title, String dotfile) throws WalaException {
        if (g == null) {
            throw new IllegalArgumentException("g is null");
        }
        StringBuilder dotStringBuffer = DotUtil.dotOutput(g, labels, title);
        if (dotfile == null) {
            throw new WalaException("internal error: null filename parameter");
        }
        try {
            File f = new File(dotfile);
            try (BufferedWriter fw = Files.newBufferedWriter(f.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                fw.write(dotStringBuffer.toString());
            }
            return f;
        }
        catch (Exception e) {
            throw new WalaException("Error writing dot file " + dotfile, e);
        }
    }

    public static <T> StringBuilder dotOutput(Graph<T> g, NodeDecorator<T> labels, @Nullable String title) throws WalaException {
        StringBuilder result = new StringBuilder("digraph \"DirectedGraph\" {\n");
        if (title != null) {
            result.append("graph [label = \"").append(title).append("\", labelloc=t, concentrate = true];");
        } else {
            result.append("graph [concentrate = true];");
        }
        String rankdir = DotUtil.getRankDir();
        if (rankdir != null) {
            result.append("rankdir=").append(rankdir).append(';');
        }
        String fontsizeStr = "fontsize=" + fontSize;
        String fontcolorStr = ",fontcolor=black";
        String fontnameStr = ",fontname=Arial";
        result.append("center=true;");
        result.append(fontsizeStr);
        result.append(";node [ color=blue,shape=\"box\"");
        result.append(fontsizeStr);
        result.append(fontcolorStr);
        result.append(fontnameStr);
        result.append("];edge [ color=black,");
        result.append(fontsizeStr);
        result.append(fontcolorStr);
        result.append(fontnameStr);
        result.append("]; \n");
        Collection<T> dotNodes = DotUtil.computeDotNodes(g);
        DotUtil.outputNodes(labels, result, dotNodes);
        for (Object n : g) {
            for (Object s : Iterator2Iterable.make(g.getSuccNodes(n))) {
                result.append(' ');
                result.append(DotUtil.getPort(n, labels));
                result.append(" -> ");
                result.append(DotUtil.getPort(s, labels));
                result.append(" \n");
            }
        }
        result.append("\n}");
        return result;
    }

    private static <T> void outputNodes(NodeDecorator<T> labels, StringBuilder result, Collection<T> dotNodes) throws WalaException {
        for (T t : dotNodes) {
            DotUtil.outputNode(labels, result, t);
        }
    }

    private static <T> void outputNode(NodeDecorator<T> labels, StringBuilder result, T n) throws WalaException {
        result.append("   ");
        result.append('\"');
        result.append(DotUtil.getLabel(n, labels));
        result.append('\"');
        result.append(DotUtil.decorateNode(n, labels));
    }

    private static <T> Collection<T> computeDotNodes(Graph<T> g) {
        return Iterator2Collection.toSet(g.iterator());
    }

    private static @Nullable String getRankDir() {
        return null;
    }

    private static <T> String decorateNode(T n, NodeDecorator<T> d) throws WalaException {
        return " [ label=\"" + DotUtil.getLabel(n, d) + "\"]\n";
    }

    private static <T> String getLabel(T n, NodeDecorator<T> d) throws WalaException {
        Object result = null;
        if (d == null) {
            result = n.toString();
        } else {
            result = d.getLabel(n);
            Object object = result = result == null ? n.toString() : result;
        }
        if (((String)result).length() >= Integer.MAX_VALUE) {
            result = ((String)result).substring(0, 0x7FFFFFFC) + "...";
        }
        return result;
    }

    private static <T> String getPort(T n, NodeDecorator<T> d) throws WalaException {
        return "\"" + DotUtil.getLabel(n, d) + "\"";
    }

    public static int getFontSize() {
        return fontSize;
    }

    public static void setFontSize(int fontSize) {
        DotUtil.fontSize = fontSize;
    }

    public static enum DotOutputType {
        PS("ps"),
        SVG("svg"),
        PDF("pdf"),
        EPS("eps");

        public final String suffix;

        private DotOutputType(String suffix) {
            this.suffix = suffix;
        }
    }
}

