/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jspecify.annotations.Nullable;

public class TemporaryFile {
    private static @Nullable Path outputDir;

    public static File urlToFile(String fileName, URL input) throws IOException {
        if (input == null) {
            throw new NullPointerException("input == null");
        }
        if (outputDir == null) {
            outputDir = Files.createTempDirectory("wala", new FileAttribute[0]);
        }
        Path filePath = outputDir.resolve(fileName);
        return TemporaryFile.urlToFile(filePath.toFile(), input);
    }

    public static File urlToFile(File F, URL input) throws IOException {
        try (InputStream openStream = input.openStream();){
            File file = TemporaryFile.streamToFile(F, openStream);
            return file;
        }
    }

    public static File streamToFile(File F, InputStream ... inputs) throws IOException {
        try (FileOutputStream output = new FileOutputStream(F);){
            byte[] buffer = new byte[1024];
            for (InputStream input : inputs) {
                int read;
                while ((read = input.read(buffer)) != -1) {
                    output.write(buffer, 0, read);
                }
                input.close();
            }
        }
        return F;
    }

    public static File stringToFile(File F, String ... inputs) throws IOException {
        try (FileOutputStream output = new FileOutputStream(F);){
            for (String input : inputs) {
                output.write(input.getBytes(StandardCharsets.UTF_8));
            }
        }
        return F;
    }
}

