/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.collections.CompoundIntIterator;
import com.ibm.wala.util.collections.EmptyIntIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.intset.BimodalMutableIntSet;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.BitVectorRepository;
import com.ibm.wala.util.intset.DebuggingMutableIntSet;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.MutableSparseIntSetFactory;
import com.ibm.wala.util.intset.SemiSparseMutableIntSet;
import com.ibm.wala.util.intset.SparseIntSet;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;

public class MutableSharedBitVectorIntSet
implements MutableIntSet {
    private static final long serialVersionUID = -6630888692508092370L;
    private static final boolean DEBUG = false;
    private static final boolean PARANOID = false;
    private static final int OVERFLOW = 20;
    private @Nullable MutableSparseIntSet privatePart;
    private @Nullable BitVectorIntSet sharedPart;

    public MutableSharedBitVectorIntSet() {
    }

    public MutableSharedBitVectorIntSet(MutableSharedBitVectorIntSet set) {
        if (set == null) {
            throw new IllegalArgumentException("set is null");
        }
        if (set.privatePart != null) {
            this.privatePart = MutableSparseIntSet.make(set.privatePart);
        }
        this.sharedPart = set.sharedPart;
    }

    public MutableSharedBitVectorIntSet(SparseIntSet s) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        if (s.size() == 0) {
            return;
        }
        this.privatePart = MutableSparseIntSet.make(s);
        this.checkOverflow();
    }

    public MutableSharedBitVectorIntSet(BitVectorIntSet s) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        this.copyValue(s);
    }

    private void copyValue(BitVectorIntSet s) {
        if (s.size() == 0) {
            this.sharedPart = null;
            this.privatePart = null;
        } else if (s.size() < 20) {
            this.sharedPart = null;
            this.privatePart = MutableSparseIntSet.make(s);
        } else {
            this.sharedPart = BitVectorRepository.findOrCreateSharedSubset(s);
            if (this.sharedPart.size() == s.size()) {
                this.privatePart = null;
            } else {
                BitVectorIntSet temp = new BitVectorIntSet(s);
                temp.removeAll(this.sharedPart);
                this.privatePart = !temp.isEmpty() ? MutableSparseIntSet.make(temp) : null;
            }
        }
    }

    private void checkIntegrity() {
        assert (this.privatePart == null || !this.privatePart.isEmpty());
        assert (this.sharedPart == null || !this.sharedPart.isEmpty());
        if (this.privatePart != null && this.sharedPart != null) assert (this.privatePart.intersection(this.sharedPart).isEmpty());
    }

    private void checkOverflow() {
        if (this.privatePart != null && this.privatePart.size() > 20) {
            BitVectorIntSet temp;
            if (this.sharedPart == null) {
                temp = new BitVectorIntSet(this.privatePart);
            } else {
                temp = new BitVectorIntSet(this.sharedPart);
                temp.addAll(this.privatePart);
            }
            this.sharedPart = BitVectorRepository.findOrCreateSharedSubset(temp);
            temp.removeAll(this.sharedPart);
            this.privatePart = !temp.isEmpty() ? MutableSparseIntSet.make(temp) : null;
        }
    }

    @Override
    public boolean contains(int i) {
        if (this.privatePart != null && this.privatePart.contains(i)) {
            return true;
        }
        return this.sharedPart != null && this.sharedPart.contains(i);
    }

    @Override
    public IntSet intersection(IntSet that) {
        if (that == null) {
            throw new IllegalArgumentException("null that");
        }
        if (that instanceof MutableSharedBitVectorIntSet) {
            return this.intersection((MutableSharedBitVectorIntSet)that);
        }
        if (that instanceof BitVectorIntSet) {
            MutableSharedBitVectorIntSet m = new MutableSharedBitVectorIntSet((BitVectorIntSet)that);
            return this.intersection(m);
        }
        if (that instanceof SparseIntSet) {
            BitVectorIntSet bv = new BitVectorIntSet(that);
            return this.intersection(bv);
        }
        BitVectorIntSet result = new BitVectorIntSet();
        IntIterator it = this.intIterator();
        while (it.hasNext()) {
            int x = it.next();
            if (!that.contains(x)) continue;
            result.add(x);
        }
        return result;
    }

    @Override
    public IntSet union(IntSet that) {
        MutableSharedBitVectorIntSet temp = new MutableSharedBitVectorIntSet();
        temp.addAll(this);
        temp.addAll(that);
        return temp;
    }

    public IntSet intersection(MutableSharedBitVectorIntSet that) {
        MutableSparseIntSet t = this.makeSparseCopy();
        t.intersectWith(that);
        MutableSharedBitVectorIntSet result = new MutableSharedBitVectorIntSet(t);
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.privatePart == null && this.sharedPart == null;
    }

    @Override
    public int size() {
        int result = 0;
        result += this.privatePart == null ? 0 : this.privatePart.size();
        return result += this.sharedPart == null ? 0 : this.sharedPart.size();
    }

    @Override
    public IntIterator intIterator() {
        if (this.privatePart == null) {
            return this.sharedPart == null ? EmptyIntIterator.instance() : this.sharedPart.intIterator();
        }
        return this.sharedPart == null ? this.privatePart.intIterator() : new CompoundIntIterator(this.privatePart.intIterator(), this.sharedPart.intIterator());
    }

    @Override
    public void foreach(IntSetAction action) {
        if (this.privatePart != null) {
            this.privatePart.foreach(action);
        }
        if (this.sharedPart != null) {
            this.sharedPart.foreach(action);
        }
    }

    @Override
    public void foreachExcluding(IntSet X, IntSetAction action) {
        if (X instanceof MutableSharedBitVectorIntSet) {
            this.foreachExcludingInternal((MutableSharedBitVectorIntSet)X, action);
        } else {
            this.foreachExcludingGeneral(X, action);
        }
    }

    private void foreachExcludingInternal(MutableSharedBitVectorIntSet X, IntSetAction action) {
        if (MutableSharedBitVectorIntSet.sameSharedPart(this, X)) {
            if (this.privatePart != null) {
                if (X.privatePart != null) {
                    this.privatePart.foreachExcluding(X.privatePart, action);
                } else {
                    this.privatePart.foreach(action);
                }
            }
        } else {
            if (this.privatePart != null) {
                this.privatePart.foreachExcluding(X, action);
            }
            if (this.sharedPart != null) {
                this.sharedPart.foreachExcluding(X.makeDenseCopy(), action);
            }
        }
    }

    private void foreachExcludingGeneral(IntSet X, IntSetAction action) {
        if (this.privatePart != null) {
            this.privatePart.foreachExcluding(X, action);
        }
        if (this.sharedPart != null) {
            this.sharedPart.foreachExcluding(X, action);
        }
    }

    @Override
    public int max() {
        int result = -1;
        if (this.privatePart != null && this.privatePart.size() > 0) {
            result = Math.max(result, this.privatePart.max());
        }
        if (this.sharedPart != null) {
            result = Math.max(result, this.sharedPart.max());
        }
        return result;
    }

    @Override
    public boolean sameValue(IntSet that) throws IllegalArgumentException, UnimplementedError {
        if (that == null) {
            throw new IllegalArgumentException("that == null");
        }
        if (that instanceof MutableSharedBitVectorIntSet) {
            return this.sameValue((MutableSharedBitVectorIntSet)that);
        }
        if (that instanceof SparseIntSet) {
            return this.sameValue((SparseIntSet)that);
        }
        if (that instanceof BimodalMutableIntSet) {
            return that.sameValue(this.makeSparseCopy());
        }
        if (that instanceof BitVectorIntSet) {
            return this.sameValue((BitVectorIntSet)that);
        }
        if (that instanceof SemiSparseMutableIntSet) {
            return that.sameValue(this);
        }
        Assertions.UNREACHABLE("unexpected class " + that.getClass());
        return false;
    }

    private boolean sameValue(SparseIntSet that) {
        if (this.size() != that.size()) {
            return false;
        }
        if (this.sharedPart == null) {
            if (this.privatePart == null) {
                return true;
            }
            return this.privatePart.sameValue(that);
        }
        return this.makeSparseCopy().sameValue(that);
    }

    private boolean sameValue(BitVectorIntSet that) {
        if (this.size() != that.size()) {
            return false;
        }
        if (this.sharedPart == null) {
            if (this.privatePart == null) {
                return true;
            }
            return that.makeSparseCopy().sameValue(this.privatePart);
        }
        if (this.privatePart == null) {
            return this.sharedPart.sameValue(that);
        }
        return this.makeDenseCopy().sameValue(that);
    }

    private boolean sameValue(MutableSharedBitVectorIntSet that) {
        if (this.size() != that.size()) {
            return false;
        }
        if (this.sharedPart == null) {
            if (this.privatePart == null) {
                return true;
            }
            if (that.sharedPart == null) {
                if (that.privatePart == null) {
                    return this.privatePart.isEmpty();
                }
                return this.privatePart.sameValue(that.privatePart);
            }
            if (that.privatePart == null) {
                return this.privatePart.sameValue(that.sharedPart);
            }
            BitVectorIntSet temp = new BitVectorIntSet(that.sharedPart);
            temp.addAllOblivious(that.privatePart);
            return this.privatePart.sameValue(temp);
        }
        if (this.privatePart == null) {
            if (that.privatePart == null) {
                return this.sharedPart.sameValue(that.sharedPart);
            }
            if (that.sharedPart == null) {
                return this.sharedPart.sameValue(that.privatePart);
            }
            MutableSparseIntSet t = that.makeSparseCopy();
            return this.sharedPart.sameValue(t);
        }
        if (that.sharedPart == null) {
            Assertions.UNREACHABLE();
            return false;
        }
        if (that.privatePart == null) {
            MutableSparseIntSet s = this.makeSparseCopy();
            return s.sameValue(that.sharedPart);
        }
        if (this.sharedPart == that.sharedPart) {
            return this.privatePart.sameValue(that.privatePart);
        }
        MutableSparseIntSet s1 = this.makeSparseCopy();
        MutableSparseIntSet s2 = that.makeSparseCopy();
        return s1.sameValue(s2);
    }

    @Override
    public boolean isSubset(IntSet that) {
        if (that == null) {
            throw new IllegalArgumentException("null that");
        }
        if (that instanceof MutableSharedBitVectorIntSet) {
            return this.isSubset((MutableSharedBitVectorIntSet)that);
        }
        IntIterator it = this.intIterator();
        while (it.hasNext()) {
            if (that.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    private boolean isSubset(MutableSharedBitVectorIntSet that) {
        if (this.size() > that.size()) {
            return false;
        }
        if (this.sharedPart == null) {
            if (this.privatePart == null) {
                return true;
            }
            if (that.sharedPart == null) {
                return this.privatePart.isSubset(that.privatePart);
            }
            if (that.privatePart == null) {
                return this.privatePart.isSubset(that.sharedPart);
            }
            MutableSparseIntSet s1 = that.makeSparseCopy();
            return this.privatePart.isSubset(s1);
        }
        if (this.privatePart == null) {
            if (that.privatePart == null) {
                if (that.sharedPart == null) {
                    return false;
                }
                return this.sharedPart.isSubset(that.sharedPart);
            }
            if (that.sharedPart == null) {
                return this.sharedPart.isSubset(that.privatePart);
            }
            MutableSparseIntSet s1 = that.makeSparseCopy();
            return this.sharedPart.isSubset(s1);
        }
        if (that.privatePart == null) {
            return this.privatePart.isSubset(that.sharedPart) && this.sharedPart.isSubset(that.sharedPart);
        }
        if (that.sharedPart == null) {
            return this.privatePart.isSubset(that.privatePart) && this.sharedPart.isSubset(that.privatePart);
        }
        if (this.sharedPart.isSubset(that.sharedPart)) {
            if (this.privatePart.isSubset(that.privatePart)) {
                return true;
            }
            MutableSparseIntSet s1 = that.makeSparseCopy();
            return this.privatePart.isSubset(s1);
        }
        BitVectorIntSet temp = new BitVectorIntSet(this.sharedPart);
        temp.removeAll(that.sharedPart);
        if (temp.isSubset(that.privatePart)) {
            if (this.privatePart.isSubset(that.privatePart)) {
                return true;
            }
            MutableSparseIntSet t = MutableSparseIntSet.make(this.privatePart);
            t.removeAll(that.privatePart);
            return t.isSubset(that.sharedPart);
        }
        return false;
    }

    @Override
    public void copySet(IntSet set) {
        if (set instanceof MutableSharedBitVectorIntSet) {
            MutableSharedBitVectorIntSet other = (MutableSharedBitVectorIntSet)set;
            this.privatePart = other.privatePart != null ? MutableSparseIntSet.make(other.privatePart) : null;
            this.sharedPart = other.sharedPart;
        } else {
            this.clear();
            this.addAll(set);
        }
    }

    @Override
    public boolean addAll(IntSet set) throws IllegalArgumentException {
        if (set == null) {
            throw new IllegalArgumentException("set == null");
        }
        if (set instanceof MutableSharedBitVectorIntSet) {
            boolean result = this.addAll((MutableSharedBitVectorIntSet)set);
            return result;
        }
        if (set instanceof SparseIntSet) {
            boolean result = this.addAllInternal((SparseIntSet)set);
            return result;
        }
        if (set instanceof BitVectorIntSet) {
            boolean result = this.addAllInternal((BitVectorIntSet)set);
            return result;
        }
        if (set instanceof DebuggingMutableIntSet) {
            SparseIntSet temp = new SparseIntSet(set);
            boolean result = this.addAllInternal(temp);
            return result;
        }
        boolean result = false;
        IntIterator it = set.intIterator();
        while (it.hasNext()) {
            int x = it.next();
            if (this.contains(x)) continue;
            result = true;
            this.add(x);
        }
        return result;
    }

    private boolean addAllInternal(BitVectorIntSet set) {
        assert (this.sharedPart != set);
        if (this.privatePart == null && this.sharedPart == null) {
            this.copyValue(set);
            return !set.isEmpty();
        }
        BitVectorIntSet temp = this.makeDenseCopy();
        boolean result = temp.addAll(set);
        this.copyValue(temp);
        return result;
    }

    @NullUnmarked
    private boolean addAllInternal(@Nullable SparseIntSet set) {
        if (this.privatePart == null) {
            if (this.sharedPart == null) {
                if (!set.isEmpty()) {
                    this.privatePart = MutableSparseIntSet.make(set);
                    this.sharedPart = null;
                    this.checkOverflow();
                    return true;
                }
                return false;
            }
            this.privatePart = MutableSparseIntSet.make(set);
            this.privatePart.removeAll(this.sharedPart);
            if (this.privatePart.isEmpty()) {
                this.privatePart = null;
                return false;
            }
            this.checkOverflow();
            return true;
        }
        if (this.sharedPart == null) {
            boolean result = this.privatePart.addAll(set);
            this.checkOverflow();
            return result;
        }
        int oldSize = this.privatePart.size();
        this.privatePart.addAll(set);
        this.privatePart.removeAll(this.sharedPart);
        boolean result = this.privatePart.size() > oldSize;
        this.checkOverflow();
        return result;
    }

    private boolean addAll(MutableSharedBitVectorIntSet set) {
        BitVectorIntSet other;
        if (set.isEmpty()) {
            return false;
        }
        if (this.isEmpty()) {
            if (set.privatePart != null) {
                this.privatePart = MutableSparseIntSet.make(set.privatePart);
            }
            this.sharedPart = set.sharedPart;
            return true;
        }
        if (set.sharedPart == null) {
            return this.addAllInternal(set.privatePart);
        }
        if (MutableSharedBitVectorIntSet.sameSharedPart(this, set)) {
            if (set.privatePart == null) {
                return false;
            }
            return this.addAllInternal(set.privatePart);
        }
        if (set.privatePart == null) {
            if (this.sharedPart == null || this.sharedPart.isSubset(set.sharedPart)) {
                int oldSize = this.size();
                if (this.privatePart != null) {
                    this.privatePart.removeAll(set.sharedPart);
                    this.privatePart = this.privatePart.isEmpty() ? null : this.privatePart;
                }
                this.sharedPart = set.sharedPart;
                return this.size() > oldSize;
            }
            BitVectorIntSet temp = this.makeDenseCopy();
            boolean b = temp.addAll(set.sharedPart);
            if (b) {
                if (temp.sameValue(set.sharedPart)) {
                    this.privatePart = null;
                    this.sharedPart = set.sharedPart;
                } else {
                    this.copyValue(temp);
                }
            }
            return b;
        }
        BitVectorIntSet temp = this.makeDenseCopy();
        boolean b = temp.addAll(other = set.makeDenseCopy());
        if (b) {
            if (temp.sameValue(other)) {
                this.privatePart = MutableSparseIntSet.make(set.privatePart);
                this.sharedPart = set.sharedPart;
            } else {
                this.copyValue(temp);
            }
        }
        return b;
    }

    @Override
    public boolean add(int i) {
        if (this.privatePart == null) {
            if (this.sharedPart == null) {
                this.privatePart = MutableSparseIntSet.makeEmpty();
                this.privatePart.add(i);
                return true;
            }
            if (this.sharedPart.contains(i)) {
                return false;
            }
            this.privatePart = MutableSparseIntSet.makeEmpty();
            this.privatePart.add(i);
            return true;
        }
        if (this.sharedPart == null) {
            boolean result = this.privatePart.add(i);
            this.checkOverflow();
            return result;
        }
        if (this.sharedPart.contains(i)) {
            return false;
        }
        boolean result = this.privatePart.add(i);
        this.checkOverflow();
        return result;
    }

    @Override
    public boolean remove(int i) {
        if (this.privatePart != null && this.privatePart.contains(i)) {
            this.privatePart.remove(i);
            if (this.privatePart.size() == 0) {
                this.privatePart = null;
            }
            return true;
        }
        if (this.sharedPart != null && this.sharedPart.contains(i)) {
            this.privatePart = this.makeSparseCopy();
            this.privatePart.remove(i);
            if (this.privatePart.size() == 0) {
                this.privatePart = null;
            }
            this.sharedPart = null;
            this.checkOverflow();
            return true;
        }
        return false;
    }

    @Override
    public void intersectWith(IntSet set) {
        if (set instanceof MutableSharedBitVectorIntSet) {
            this.intersectWithInternal((MutableSharedBitVectorIntSet)set);
        } else if (set instanceof BitVectorIntSet) {
            this.intersectWithInternal(new MutableSharedBitVectorIntSet((BitVectorIntSet)set));
        } else {
            IntIterator it = this.intIterator();
            while (it.hasNext()) {
                int x = it.next();
                if (set.contains(x)) continue;
                this.remove(x);
            }
        }
    }

    private void intersectWithInternal(MutableSharedBitVectorIntSet set) {
        if (this.sharedPart != null) {
            if (MutableSharedBitVectorIntSet.sameSharedPart(this, set)) {
                if (this.privatePart != null) {
                    if (set.privatePart == null) {
                        this.privatePart = null;
                    } else {
                        this.privatePart.intersectWith(set.privatePart);
                        if (this.privatePart.isEmpty()) {
                            this.privatePart = null;
                        }
                    }
                }
            } else if (set.sharedPart == null) {
                if (set.privatePart == null) {
                    this.privatePart = null;
                    this.sharedPart = null;
                } else {
                    MutableSparseIntSet temp = MutableSparseIntSet.make(set.privatePart);
                    temp.intersectWith(this);
                    this.sharedPart = null;
                    if (temp.isEmpty()) {
                        this.privatePart = null;
                    } else {
                        this.privatePart = temp;
                        this.checkOverflow();
                    }
                }
            } else {
                BitVectorIntSet b = this.makeDenseCopy();
                b.intersectWith(set.makeDenseCopy());
                this.copyValue(b);
            }
        } else if (this.privatePart != null) {
            this.privatePart.intersectWith(set);
            if (this.privatePart.isEmpty()) {
                this.privatePart = null;
            }
        }
    }

    public static boolean sameSharedPart(MutableSharedBitVectorIntSet a, MutableSharedBitVectorIntSet b) {
        if (b == null) {
            throw new IllegalArgumentException("b is null");
        }
        if (a == null) {
            throw new IllegalArgumentException("a is null");
        }
        return a.sharedPart == b.sharedPart;
    }

    public String toString() {
        return this.makeSparseCopy().toString();
    }

    MutableSparseIntSet makeSparseCopy() {
        if (this.privatePart == null) {
            if (this.sharedPart == null) {
                return MutableSparseIntSet.makeEmpty();
            }
            return new MutableSparseIntSetFactory().makeCopy(this.sharedPart);
        }
        if (this.sharedPart == null) {
            return MutableSparseIntSet.make(this.privatePart);
        }
        MutableSparseIntSet result = MutableSparseIntSet.make(this.privatePart);
        result.addAll(this.sharedPart);
        return result;
    }

    BitVectorIntSet makeDenseCopy() {
        if (this.privatePart == null) {
            if (this.sharedPart == null) {
                return new BitVectorIntSet();
            }
            return new BitVectorIntSet(this.sharedPart);
        }
        if (this.sharedPart == null) {
            return new BitVectorIntSet(this.privatePart);
        }
        BitVectorIntSet temp = new BitVectorIntSet(this.sharedPart);
        temp.addAllOblivious(this.privatePart);
        return temp;
    }

    public boolean hasSharedPart() {
        return this.sharedPart != null;
    }

    @Override
    public boolean containsAny(IntSet set) {
        if (set instanceof MutableSharedBitVectorIntSet) {
            MutableSharedBitVectorIntSet other = (MutableSharedBitVectorIntSet)set;
            if (this.sharedPart != null) {
                if (other.sharedPart != null && this.sharedPart.containsAny(other.sharedPart)) {
                    return true;
                }
                if (other.privatePart != null && this.sharedPart.containsAny(other.privatePart)) {
                    return true;
                }
            }
        } else if (this.sharedPart != null && this.sharedPart.containsAny(set)) {
            return true;
        }
        return this.privatePart != null && this.privatePart.containsAny(set);
    }

    @Override
    public boolean addAllInIntersection(IntSet other, IntSet filter) {
        if (other instanceof MutableSharedBitVectorIntSet) {
            return this.addAllInIntersectionInternal((MutableSharedBitVectorIntSet)other, filter);
        }
        return this.addAllInIntersectionGeneral(other, filter);
    }

    private boolean addAllInIntersectionGeneral(IntSet other, IntSet filter) {
        BitVectorIntSet o = new BitVectorIntSet(other);
        o.intersectWith(filter);
        return this.addAll(o);
    }

    private boolean addAllInIntersectionInternal(MutableSharedBitVectorIntSet other, IntSet filter) {
        if (other.sharedPart == null) {
            if (other.privatePart == null) {
                return false;
            }
            return this.addAllInIntersectionInternal(other.privatePart, filter);
        }
        if (this.sharedPart == other.sharedPart) {
            if (other.privatePart == null) {
                return false;
            }
            return this.addAllInIntersectionInternal(other.privatePart, filter);
        }
        MutableSharedBitVectorIntSet o = new MutableSharedBitVectorIntSet(other);
        o.intersectWith(filter);
        return this.addAll(o);
    }

    private boolean addAllInIntersectionInternal(SparseIntSet other, IntSet filter) {
        if (this.sharedPart == null) {
            if (this.privatePart == null) {
                this.privatePart = MutableSparseIntSet.make(other);
                this.privatePart.intersectWith(filter);
                if (this.privatePart.size() == 0) {
                    this.privatePart = null;
                }
                this.checkOverflow();
                return this.size() > 0;
            }
            boolean result = this.privatePart.addAllInIntersection(other, filter);
            this.checkOverflow();
            return result;
        }
        if (this.privatePart == null) {
            this.privatePart = MutableSparseIntSet.make(this.sharedPart);
            this.sharedPart = null;
            boolean result = this.privatePart.addAllInIntersection(other, filter);
            this.checkOverflow();
            return result;
        }
        MutableSparseIntSet temp = MutableSparseIntSet.make(other);
        temp.intersectWith(filter);
        return this.addAll(temp);
    }

    @Override
    public void clear() {
        this.privatePart = null;
        this.sharedPart = null;
    }
}

