/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.traverse;

import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.traverse.GraphDFSDiscoverTimeIterator;
import java.util.Iterator;
import org.jspecify.annotations.Nullable;

public class NumberedDFSDiscoverTimeIterator<T>
extends GraphDFSDiscoverTimeIterator<T> {
    private static final long serialVersionUID = -3919708273323217304L;
    private final Iterator<? extends T>[] pendingChildren;
    protected final NumberedGraph<T> G;

    public NumberedDFSDiscoverTimeIterator(NumberedGraph<T> G, T N) {
        if (G == null) {
            throw new IllegalArgumentException("G is null");
        }
        this.G = G;
        this.pendingChildren = new Iterator[G.getMaxNumber() + 1];
        this.init(G, new NonNullSingletonIterator<T>(N));
    }

    public NumberedDFSDiscoverTimeIterator(NumberedGraph<T> G, @Nullable Iterator<? extends T> nodes) throws IllegalArgumentException {
        if (G == null) {
            throw new IllegalArgumentException("G is null");
        }
        if (nodes == null) {
            throw new IllegalArgumentException("nodes == null");
        }
        this.G = G;
        this.pendingChildren = new Iterator[G.getMaxNumber() + 1];
        this.init(G, nodes);
    }

    public NumberedDFSDiscoverTimeIterator(NumberedGraph<T> G) throws NullPointerException {
        this(G, G == null ? null : G.iterator());
    }

    @Override
    protected Iterator<? extends T> getPendingChildren(T n) {
        return this.pendingChildren[this.G.getNumber(n)];
    }

    @Override
    protected void setPendingChildren(T v, Iterator<? extends T> iterator) {
        this.pendingChildren[this.G.getNumber(v)] = iterator;
    }
}

