/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.traverse;

import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.debug.UnimplementedError;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;

public abstract class DFSDiscoverTimeIterator<T>
extends ArrayList<T>
implements Iterator<T> {
    private static final long serialVersionUID = 4238700455408861924L;
    private @Nullable Iterator<? extends T> roots;

    protected void init(Iterator<? extends T> nodes) {
        this.roots = nodes;
        assert (nodes != null);
        if (this.roots.hasNext()) {
            T n = this.roots.next();
            this.push(n);
            this.setPendingChildren(n, this.getConnected(n));
        }
    }

    protected void init(T N) {
        this.init((T)new NonNullSingletonIterator<T>(N));
    }

    @Override
    public boolean hasNext() {
        return !this.empty();
    }

    protected abstract @Nullable Iterator<? extends T> getPendingChildren(T var1);

    protected abstract void setPendingChildren(T var1, Iterator<? extends T> var2);

    @Override
    @NullUnmarked
    public T next() throws NoSuchElementException {
        if (this.empty()) {
            throw new NoSuchElementException();
        }
        T toReturn = this.peek();
        assert (this.getPendingChildren(toReturn) != null);
        do {
            T stackTop = this.peek();
            for (T child : Iterator2Iterable.make(this.getPendingChildren(stackTop))) {
                if (this.getPendingChildren(child) != null) continue;
                this.visitEdge(stackTop, child);
                this.setPendingChildren(child, this.getConnected(child));
                this.push(child);
                return toReturn;
            }
            EmptyIterator empty = EmptyIterator.instance();
            this.setPendingChildren(stackTop, empty);
            this.pop();
        } while (!this.empty());
        while (this.roots.hasNext()) {
            T nextRoot = this.roots.next();
            if (this.getPendingChildren(nextRoot) != null) continue;
            this.push(nextRoot);
            this.setPendingChildren(nextRoot, this.getConnected(nextRoot));
            return toReturn;
        }
        return toReturn;
    }

    protected abstract Iterator<? extends T> getConnected(T var1);

    @Override
    public void remove() throws UnimplementedError {
        throw new UnimplementedError();
    }

    protected void visitEdge(T from, T to) {
    }

    private boolean empty() {
        return this.size() == 0;
    }

    private void push(T elt) {
        this.add(elt);
    }

    private T peek() {
        return (T)this.get(this.size() - 1);
    }

    private T pop() {
        Object e = this.get(this.size() - 1);
        this.remove(this.size() - 1);
        return (T)e;
    }
}

