/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.traverse;

import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.graph.Graph;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;

public class BFSPathFinder<T> {
    private final boolean DEBUG = false;
    private final Graph<T> G;
    private final Predicate<T> filter;
    private final Iterator<T> roots;
    private @Nullable ArrayDeque<T> Q = null;
    private @Nullable HashMap<Object, T> history = null;

    public BFSPathFinder(Graph<T> G, T N, Predicate<T> f) {
        if (G == null) {
            throw new IllegalArgumentException("G is null");
        }
        if (f == null) {
            throw new IllegalArgumentException("null f");
        }
        this.G = G;
        this.roots = new NonNullSingletonIterator<T>(N);
        this.filter = f;
    }

    public BFSPathFinder(Graph<T> G, T src, T target) throws IllegalArgumentException {
        if (G == null) {
            throw new IllegalArgumentException("G is null");
        }
        this.G = G;
        this.roots = new NonNullSingletonIterator<T>(src);
        if (!G.containsNode(src)) {
            throw new IllegalArgumentException("src is not in graph " + src);
        }
        this.filter = target::equals;
    }

    public BFSPathFinder(Graph<T> G, T src, Iterator<T> targets) {
        if (targets == null) {
            throw new IllegalArgumentException("targets is null");
        }
        HashSet ts = HashSetFactory.make();
        while (targets.hasNext()) {
            ts.add(targets.next());
        }
        this.G = G;
        this.roots = new NonNullSingletonIterator<T>(src);
        this.filter = ts::contains;
    }

    public BFSPathFinder(Graph<T> G, Iterator<T> sources, T target) {
        if (G == null) {
            throw new IllegalArgumentException("G is null");
        }
        if (sources == null) {
            throw new IllegalArgumentException("sources is null");
        }
        this.G = G;
        this.roots = sources;
        this.filter = target::equals;
    }

    public BFSPathFinder(Graph<T> G, Iterator<T> nodes, Predicate<T> f) {
        this.G = G;
        this.roots = nodes;
        this.filter = f;
        if (G == null) {
            throw new IllegalArgumentException("G is null");
        }
        if (this.roots == null) {
            throw new IllegalArgumentException("roots is null");
        }
    }

    @NullUnmarked
    public @Nullable List<T> find() {
        if (this.Q == null) {
            this.Q = new ArrayDeque();
            this.history = HashMapFactory.make();
            while (this.roots.hasNext()) {
                T next = this.roots.next();
                this.Q.addLast(next);
                this.history.put(next, null);
            }
        }
        while (!this.Q.isEmpty()) {
            T N = this.Q.removeFirst();
            if (this.filter.test(N)) {
                return this.makePath(N, this.history);
            }
            Iterator<T> children = this.getConnected(N);
            while (children.hasNext()) {
                T c = children.next();
                if (this.history.containsKey(c)) continue;
                this.Q.addLast(c);
                this.history.put(c, N);
            }
        }
        return null;
    }

    @NullUnmarked
    private List<T> makePath(T node, @Nullable Map<Object, T> history) {
        ArrayList<T> result = new ArrayList<T>();
        T n = node;
        result.add(n);
        T parent;
        while ((parent = history.get(n)) != null) {
            result.add(parent);
            n = parent;
        }
        return result;
    }

    protected Iterator<? extends T> getConnected(T n) {
        return this.G.getSuccNodes(n);
    }
}

